<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
?>
<style>
	.day {
		border: 1px solid black;
		min-width: 50px;
		min-height: 50px;
		width: 50px;
		height: 50px;
	}
	.sunday {
		border: 1px solid black;
        display: none;
	}

/* Tooltip container */
.mytooltip {
  position: relative;
  display: inline-block;
  cursor: pointer;
  border-bottom: 1px dotted black; /* If you want dots under the hoverable text */
}

/* Tooltip text */
.mytooltip .mytooltiptext {
  visibility: hidden;
  width: 300px;
  background-color: black;
  color: #fff;
  text-align: center;
  border-radius: 6px;
 
  /* Position the tooltip text - see examples below! */
  position: absolute;
  z-index: 1;
}

/* Show the tooltip text when you mouse over the tooltip container */
.mytooltip:hover .mytooltiptext {
  visibility: visible;
}

</style>
<?php
function build_tooltip($item,$qty,$pph,$jobHours,$job,$tooltip) {
	if (! $tooltip) {
		$tooltip="<table style='min-width: 200px;'><tr><td>Job/SO</td><td>Part</td><td align='right'>Quantity</td><td align='right'>PPH</td><td align='right'>Hours</td></tr>";
	}
	$qty=round($qty,0);
	$pph=round($pph,0);
	$jobHours=round($jobHours,2);
	if (substr($job,0,2)=="SO") {	
		$so=substr($job,2);
		$job="<a href='editOrder.php?id=$so' target='_blank'>$job</a>";
	} else {
		$job="<a href='editJob.php?id=$job' target='_blank'>$job</a>";
	}
	$tooltip.="<tr><td>$job</td><td>$item</td><td align='right'>$qty</td><td></td><td align='right'>$pph</td><td align='right'>$jobHours</td></tr>";
	return $tooltip;		
}

function build_calendar($month,$year,$workcenter,$show=1,$dateArray=array()) {
	global $db;
     // Create array containing abbreviations of days of week.
     $daysOfWeek = array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
     // What is the first day of the month in question?
     $firstDayOfMonth = mktime(0,0,0,$month,1,$year);
     // How many days does this month contain?
     $numberDays = date('t',$firstDayOfMonth);
     // Retrieve some information about the first day of the
     // month in question.
     $dateComponents = getdate($firstDayOfMonth);
     // What is the name of the month in question?
     $monthName = $dateComponents['month'];
     // What is the index value (0-6) of the first day of the
     // month in question.
     $dayOfWeek = $dateComponents['wday'];
     // Create the table tag opener and day headers
	 if ($show) {
		$calendar = "<table class='table calendar'>";
		$calendar .= "<caption>$monthName $year</caption>";
		$calendar .= "<tr>";
	}
    $backlogHours=array();
	print "Applicable Adjustments<BR>";
	$sql="select * from workcenter_down_time where workcenter_id = ? ";
	$sql.=" and MONTH(down_date) = ? and YEAR(down_date) = ? ";
	list($rs,$err)=runIQuery($db,$sql,array("iii",$workcenter,$month,$year));
	$headerWritten=0;
	foreach ($rs as $data) {
		$hours=$data['down_hours'];
		$dt=formatDateDBToWeb($data['down_date']);
		$why=$data['down_description'];
		if (! $headerWritten) {
			print "<table><tr><td>Date</td><td>Description</td><td>Hours</td></tr>\n";
			$headerWritten=1;				
		}
		print "<tr><td>$dt</td><td>$why</td><td>$hours</td></tr>\n";
	}
	if ($headerWritten) {
		print "</table>";
	}
	$sql="select * from workcenters where workcenter_id=? ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$workcenter));
	  foreach ($rs as $data) {
	  		$wc=$data['workcenter_id'];
	  		$backlogHours[$wc]=0;	
			## laser and bend
			if ($wc == 181 or $wc == 180 ) {
				$sql="select j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled, sum(coalesce(pr.quantity_good,0)) as good ";
				$sql.=" from jobs j left outer join schedule_items si on j.job_id=si.job_id ";
				$sql.=" inner join routing r on j.item_id=parent_part and r.workcenter_id=? ";
				$sql.=" inner join order_lines l on j.line_id=l.line_id and line_status not in (3,4,5,6,0) ";
				$sql.=" left outer join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id ";
				$sql.=" where coalesce(si.due_date, j.start_date) < curdate() and j.status=1 ";
				$sql.=" and j.quantity_scheduled < 25000 and coalesce(si.due_date, j.start_date) > '2022-04-01' ";
				$sql.=" group by j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled ";
		    } else {
				$sql="select j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled, sum(coalesce(pr.quantity_good,0)) as good ";
				$sql.=" from jobs j left outer join schedule_items si on j.job_id=si.job_id ";
				$sql.=" inner join routing r on j.item_id=parent_part and r.workcenter_id=? ";
				$sql.=" inner join order_lines l on j.line_id=l.line_id and line_status not in (3,4,5,6,0) ";
				$sql.=" left outer join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id ";
				$sql.=" where coalesce(si.due_date, j.start_date) < curdate() and j.status=1 ";
				$sql.=" and j.quantity_scheduled < 25000 and coalesce(si.due_date, j.start_date) > '2022-04-01' ";
				$sql.=" group by j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled ";
			}
			list($wrs,$err)=runIQuery($db,$sql,array("i",$wc));
			foreach ($wrs as $wdata) {
				$pph=$wdata['pph'];
				if ($pph == 0) {
					$pph=5;
					if ($wc == 181) {
						$pph=200;
					}
				}
				$qty=$wdata['quantity_scheduled'] - $wdata['good'];
				if ($qty < 0) {
					$qty=0;
				}
				$people=$wdata['people'];				
				if ($wc == 181) {
					$people=1;
				}
				$cap=$pph * $people;

				if ($cap > 0) {
					$jobHours = $qty / $cap;
				} else {
					$jobHours=.5;
					error_log("$scriptid something wrong pph or people 0 for $wc " . $wdata['item_id']);
				}
				$jobHours=round($jobHours,2);
				$backlogHours[$wc]+=$jobHours;
			}
	  }

	if ($show) {
		// Create the calendar headers
		foreach($daysOfWeek as $day) {
			$calendar .= "<th class='header' style='text-align: center;'>$day</th>";
		} 
		$calendar .= "</tr><tr>";
		// The variable $dayOfWeek is used to
		// ensure that the calendar
		// display consists of exactly 7 columns.
	 	if ($dayOfWeek > 0) { 
			$calendar .= "<td colspan='$dayOfWeek'>&nbsp;</td>"; 
	    }
	}
     // Create the rest of the calendar
     // Initiate the day counter, starting with the 1st.
     $currentDay = 1;
     $month = str_pad($month, 2, "0", STR_PAD_LEFT);

     while ($currentDay <= $numberDays) {

          // Seventh column (Saturday) reached. Start a new row.

          if ($dayOfWeek == 7) {

               $dayOfWeek = 0;
			   if ($show) {
				  $calendar .= "</tr><tr>";
			   }

          }
          
          $currentDayRel = str_pad($currentDay, 2, "0", STR_PAD_LEFT);
          
          $date = "$year-$month-$currentDayRel";
		  $available=0;
          if (($dayOfWeek > 0) and ($dayOfWeek < 6) and ($date >= Date("Y-m-d"))) {
          	$tooltip="";
			$hours=0;
            $onJob=0;
			$sql="select * from workcenters where workcenter_id=? ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$workcenter));
			 foreach ($rs as $data) {
			  	$wc=$data['workcenter_id'];
				$wcName=$data['workcenter_name'];
			  	$hours=$data['capacity_hours'];                  
				$sql="select sum(down_hours) from workcenter_down_time where workcenter_id=? and down_date=? ";
				list($drs,$err)=runIQuery($db,$sql,array("is",$wc,$date));
				$downHours=$drs[0][0];							
				$availableHours = $hours;
				if ($downHours) {
					$availableHours-=$downHours;
				}
				  ## laser and bend
				if ($wc == 181 or $wc == 180 ) {
					$sql="select j.job_id, j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled, sum(coalesce(pr.quantity_good,0)) as good ";
					$sql.=" from jobs j left outer join schedule_items si on j.job_id=si.job_id ";
					$sql.=" inner join routing r on j.item_id=parent_part and r.workcenter_id=? ";
					$sql.=" inner join order_lines l on j.line_id=l.line_id and line_status not in (3,4,5,6) ";
					$sql.=" left outer join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id ";
					$sql.=" where coalesce(si.due_date, j.start_date) = ? and j.status=1 ";
					$sql.=" and j.quantity_scheduled < 25000 ";
					$sql.=" group by j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled ";
				} else {
					$sql="select j.job_id, j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled, sum(coalesce(pr.quantity_good,0)) as good ";
					$sql.=" from jobs j left outer join schedule_items si on j.job_id=si.job_id ";
					$sql.=" inner join routing r on j.item_id=parent_part and r.workcenter_id=? ";
					$sql.=" inner join order_lines l on j.line_id=l.line_id and line_status not in (3,4,5,6) ";
					$sql.=" left outer join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id ";
					$sql.=" where coalesce(si.due_date, j.start_date) = ? and j.status=1 ";
					$sql.=" and j.quantity_scheduled < 25000 ";
					$sql.=" group by j.item_id, r.workcenter_id, r.pph, r.people, j.quantity_scheduled ";
				}
				  list($wrs,$err)=runIQuery($db,$sql,array("is",$wc,$date));
				  foreach ($wrs as $wdata) {
					$pph=$wdata['pph'];
					if ($pph == 0) {
						$pph=5;
						if ($wc==181) {
							$pph=200;
						}
					}
					$qty=$wdata['quantity_scheduled'] - $wdata['good'];
					if ($qty < 0) {
						$qty=0;
					}
					$people=$wdata['people'];
					$item=$wdata['item_id'];
					$job=$wdata['job_id'];
					$jobHours = $qty / $pph * $people;
                    if ($jobHours > 0) {
                        if (! $tooltip) {
							if ($show) {
								$tooltip.="<table><tr><td>Job/SO</td><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
							}
                        }
                        $jobHours=round($jobHours,2);
                        $onJob+=$jobHours;
						if ($show) {
							$tooltip=build_tooltip($item,$qty,$pph,$jobHours,$job,$tooltip);
						}
                    }
				}
				## orders
				$schdate=AddBusinessDays($date,9);
				## sales order are only going to get the assembly lines where jobs have not been created
				$sql="select order_lines.order_id, order_lines.item_id, pph, people, quantity, coalesce(shipped_quantity,0) as shipped from orders ";
				$sql.=" inner join order_lines on orders.order_id=order_lines.order_id and orders.status = 1 inner join routing on order_lines.item_id=parent_part ";
				$sql.=" left outer join jobs on order_lines.line_id=jobs.line_id where workcenter_id=? and due_date=? and job_id is null ";
				list($ors,$err)=runIQuery($db,$sql,array("is",$wc,$schdate));
				foreach ($ors as $odata) {
					$pph=$odata['pph'];
					if ($pph == 0) {
						$pph=40;
					}
					$qty=$odata['quantity'];
					$sqty=$odata['shipped'];
					if ($sqty >= $qty) {
						$qty=0;
					}
					$item=$odata['item_id'];
					$people=$odata['people'];
					$job="SO".$odata['order_id'];
					$jobHours = $qty / $pph * $people;
                    if ($jobHours > 0) {
						if ($show) {
							$tooltip=build_tooltip($item,$qty,$pph,$jobHours,$job,$tooltip);
						}
                        $onJob+=$jobHours;
                    }
				}
				$sql="select part_number, pph, people, quantity from proposed_jobs_wc, routing where proposed_date=? and part_number=parent_part and workcenter_id=?";
				list($wrs,$err)=runIQuery($db,$sql,array("si",$date,$wc));
				$proposedHours=0;
				foreach ($wrs as $wdata) {
					$pph=$wdata['pph'];
					if ($pph == 0) {
						$pph=40;
					}
					$qty=$wdata['quantity'];
					$people=$wdata['people'];
					$item=$wdata['part_number'];
					if (! $tooltip) {
						if ($show) {
							$tooltip.="<table><tr><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
						}
					}
					$jobHours = $qty / $pph * $people;
					$jobHours=round($jobHours,2);
					$job=0;
					if ($show) {
						$tooltip=build_tooltip($item,$qty,$pph,$jobHours,$job,$tooltip);
					}
					$proposedHours+=$jobHours;
				}
				$backLogHoursTotal=0;
				$hours=$availableHours - $onJob - $proposedHours;
				if ($hours < 0) {
					$hours=0;
				}
				if (Date('m',strtotime($date)) == Date('m')) {
					$trytooltip="";
					if ($backlogHours[$wc] > 0) {						
						if ($hours > $backlogHours[$wc]) {
							if (! $tooltip) {
								if ($show) {
									$tooltip.="<table><tr><td>SO</td><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
								}
							}
							if ($show) {
								$trytooltip="<tr><td colspan='2'>Backlog:</td><td></td><td></td><td></td><td align='right'>" . $backlogHours[$wc] . "</td></tr>";
							}
							$backLogHoursTotal=$backlogHours[$wc];
                            $backlogHours[$wc]=0;
						} else {
								$backlogHours[$wc]-=$hours;                            
								if (! $tooltip) {
									if ($show) {
										$tooltip.="<table><tr><td>SO</td><td>Part</td><td align='right'>Qty<td><td>PPH</td><td>Hours</td></tr>";
									}
								}
								if ($show) {
									$trytooltip="<tr><td colspan='2'>Backlog Used:</td><td></td><td></td><td></td><td align='right'>" . $hours . "</td></tr>";
								}
								$backLogHoursTotal=$hours;
						}
					}
				}
				$hours=$onJob+$proposedHours+$backLogHoursTotal;
				$hours=round($hours,2);
				$pct = $hours / $availableHours * 100;
				$available=$pct;
				if ($show) {
					$tooltip.=$trytooltip;
				}
			  }
			  $available=round($available,0);
		}
		if ($show) {
			$calendar .= "<td class='day' rel='$date' ";
		}
          if (($dayOfWeek > 0) and ($dayOfWeek < 6) and ($date >= Date("Y-m-d"))) {
			  if ($show) {
				if ($available >= 100) {
					$calendar .= " style='background-color: #ff9999;' ";
				} else {
					if ($available > 0) {
						$calendar .= " style='background-color: #ffff99;' ";
				  } else {
					  $calendar .= " style='background-color: #99ffbb;' ";
					}
				}
			}
		}
		  if ($show) {
			$calendar .="><div style='float: right; font-size: 16px;'>$currentDay</div>";
		  }
          if (($dayOfWeek > 0) and ($dayOfWeek < 6) and ($date >= Date("Y-m-d"))) {
	
			  if ($show) {
				if ($tooltip) {
		
					$tooltip.="<tr><td colspan='4'>Available: $availableHours On WO: $onJob Proposed: $proposedHours Backlog: $backLogHoursTotal</td></tr>";
					$tooltip.="</table>";
				}
				$st=str_replace("'","\'",$tooltip);
				$sd = "<center>" . formatDateDBToWeb($date) . "</center>";
				  $used=$available;
				  $calendar.="<br><br><center><div class='mytooltip' onclick=\"showTip('$st','$sd');\">";
				  $calendar .= $used . "%";     
				  $calendar.="<span class='mytooltiptext'>$tooltip</span>";
				  $calendar .="</div>";
				  $calendar .="</center>";
			  } else {
				  if ($available <= 0) {
					  $suffix="th";
					  if (in_array($currentDay,array(1,21,31))) {
						$suffix="st";
					  } else {
						  if (in_array($currentDay,array(2,22))) {
							$suffix="nd";
						  } else {
							  if (in_array($currentDay,array(3,23))) {
								$suffix="rd";								  
							  }
						  }
					  }
					  if (! $calendar) {
						$calendar.="On the $currentDay" . $suffix . ", $wcName is over capacity<br>";
					  } else {
						  if (! strstr($calendar,"other day")) {
							$calendar.="And other days.<br>";
						  }
					  }
				  }
			  }
		  }
		  if ($show) {
			$calendar .= "</td>";
		}
          // Increment counters
          $currentDay++;
          $dayOfWeek++;
     }
     
     

     // Complete the row of the last week in month, if necessary

     if ($dayOfWeek != 7) { 
     
          $remainingDays = 7 - $dayOfWeek;
          $calendar .= "<td colspan='$remainingDays'>&nbsp;</td>"; 

     }
     
     $calendar .= "</tr>";

     $calendar .= "</table>";

     return $calendar;

}

if (isset($_GET['month'])) {
	$month=$_GET['month'];
}
if (isset($_GET['year'])) {
	$year=$_GET['year'];
}
$workCenterSelected=$_GET['wc'];
$sql="select workcenter_name from workcenters where workcenter_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$workCenterSelected));
$data=$rs[0];
$wcName=$data[0];

print renderPanel("$wcName Capacity $month/$year","Capacity","green","span11","green");
print build_calendar($month,$year,$workCenterSelected);
print renderClosePanel();
