<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Capacity";
include('header.php');

$sql="select item_name, item_description, status_name from items left outer join item_status on items.status=status_id where coalesce(under_review,0)=0 and customer_id=693 order by item_name ";
$rs=mysqli_query($db,$sql);
$itemlist=array();
$itemcount=0;
while ($data=mysqli_fetch_array($rs)) {
	if ($data['status_name'] != 'Active') {
		$itemlist[]=$data['item_name'] . "-" . $data['status_name'];		
	} else {
		$itemlist[]=$data['item_name'];
	}
	$itemcount++;
}		
$itemcount=count($itemlist);
?>
<script>
var itemList=<?=json_encode($itemlist)?>;
</script>

<style>
	.day {
		border: 1px solid black;
		min-width: 50px;
		min-height: 50px;
		width: 50px;
		height: 50px;
	}
	.sunday {
		display: none;
		border: 1px solid black;
	}

/* Tooltip container */
.mytooltip {
  position: relative;
  display: inline-block;
  cursor: pointer;
  border-bottom: 1px dotted black; /* If you want dots under the hoverable text */
}

/* Tooltip text */
.mytooltip .mytooltiptext {
  visibility: hidden;
  width: 300px;
  background-color: black;
  color: #fff;
  text-align: center;
  border-radius: 6px;
 
  /* Position the tooltip text - see examples below! */
  position: absolute;
  z-index: 1;
}

/* Show the tooltip text when you mouse over the tooltip container */
.mytooltip:hover .mytooltiptext {
  visibility: visible;
}


	ul.ui-autocomplete {
    list-style: none;
    border: 1px solid black;
    background-color: white;
    width: 200px;
}

</style>


<?php


$month=Date("m");
if (isset($_POST['month'])) {
	$month=$_POST['month'];
}
$year=Date("Y");
if (isset($_POST['year'])) {
	$year=$_POST['year'];
}

$workCenterSelected=0;
if (isset($_POST['wc'])) {
	$workCenterSelected=$_POST['wc'];
}

if ($isCustomer) {
	$customer=$isCustomer;
	$_SESSION['customer']=$customer;
}

if (isset($_POST['new_part'])) {
	$newpart=trim($_POST['new_part']);
	if ($newpart) {
		$qty=trim($_POST['new_quantity']);
		$dt=formatDateWebtoDB($_POST['new_date']);
		$cmpdt=AddBusinessDays(Date("Y-m-d"),9);
		if ($dt < $cmpdt) {
			$dt=$cmpdt;
		}
		$schdate=SubtractBusinessDays($dt,9);
		$sql="insert into proposed_jobs_wc (part_number, proposed_date, due_date, quantity) values (?, ?, ?,?) ";
		list($rs,$err)=runIQuery($db,$sql,array("sssi",$newpart,$schdate,$dt,$qty));
	}
}


print renderPanel("Work Center Capacity","Capacity","green","span11","green");
print "<div class='span7' id='wc_calendar'>";
print "</div>";
print "<div class='span5'>";
print "<form name='listform' method='POST' action='workCenterCapacity.php'>\n";
print renderStartItem(TRUE,"month","Month");
print "<select name='month' id='month' class='form-control chosen-select' onchange='refreshCalendar()'>";
print "<option value='01'";
if ($month == 1) {
	print " selected";
}
print ">January</option>";
print "<option value='02'";
if ($month == 2) {
	print " selected";
}
print ">February</option>";
print "<option value='03'";
if ($month == 3) {
	print " selected";
}
print ">March</option>";
print "<option value='04'";
if ($month == 4) {
	print " selected";
}
print ">April</option>";
print "<option value='05'";
if ($month == 5) {
	print " selected";
}
print ">May</option>";
print "<option value='06'";
if ($month == 6) {
	print " selected";
}
print ">June</option>";
print "<option value='07'";
if ($month == 7) {
	print " selected";
}
print ">July</option>";
print "<option value='08'";
if ($month == 8) {
	print " selected";
}
print ">August</option>";
print "<option value='09'";
if ($month == 9) {
	print " selected";
}
print ">September</option>";
print "<option value='10'";
if ($month == 10) {
	print " selected";
}
print ">October</option>";
print "<option value='11'";
if ($month == 11) {
	print " selected";
}
print ">November</option>";
print "<option value='12'";
if ($month == 12) {
	print " selected";
}
print ">December</option>";
print "</select>";
print renderEndItem();
print renderStartItem(TRUE,"year","Year");
print "<select name='year' id='year' class='form-control chosen-select' onchange='refreshCalendar()'>";
$y=Date("Y");
print "<option value='$y' ";
if ($year == $y) {
	print " selected ";
}
print ">$y</option>";
$y++;
print "<option value='$y' ";
if ($year == $y) {
	print " selected ";
}
print ">$y</option>";
print "</select>";
print renderEndItem();
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name ";
$wrs=mysqli_query($db,$sql);
print renderSelect(TRUE,"wc",$workCenterSelected,"Work Center","N",$wrs,1,"refreshCalendar();");
print "<div style='clear: both;'></div>";
print "<div style='clear: both;'></div>";
print renderTextBox(TRUE,"new_part","","New Part");
print renderTextBox(TRUE,"new_quantity","0","New Quantity");
print renderDateBox(TRUE,"new_date","","New Due Date");
print "<div style='clear: both;'></div>";
print renderButton("Add","green","document.listform.submit();","addbtn");
print "<hr>";
print "<center>Current Pending Entries</center>";
$dt=AddBusinessDays(Date("m/d/Y"),9);
$dt=formatDateDBToWeb($dt);
print "<center>Nearest Due Date Available is $dt</center>";
print "<table class='table table-striped'><thead><tr><th>Part</th><th>Quantity</th><th>Due Date</th><th>Weld Date</th><th>Remove<th></tr></thead><tbody>";
$sql="select * from proposed_jobs_wc order by proposed_date ";
list($rs,$err)=runIQuery($db,$sql);
$proposed=count($rs);
foreach ($rs as $data) {
	$part=$data['part_number'];
	$pjid=$data['pj_id'];
	$qty=$data['quantity'];
	$dt=formatDateDBToWeb($data['due_date']);
	print "<tr><td>$part</td><td align='right'>$qty</td><td>$dt</td>";
	print "<td>";
	$dt=formatDateDBToWeb($data['proposed_date']);
	print $dt;
	print "</td>";
	print "<td>";
	print renderButton("Remove","red","deleteJob('$pjid');","dj$pjid");
	print "</td>";
	print "</tr>\n";
}
print "</tbody></table>";
if ($proposed) {
	## walk through each other work center to see if they are over capacity in the date range
	$sql="select workcenter_id, workcenter_name from workcenters where workcenter_id =? ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$workCenterSelected));
	foreach ($rs as $data) {
		$workcenter=$data['workcenter_id'];
		$wcName=$data['workcenter_name'];
		print build_calendar($month,$year,$workcenter,0);
	}
}


print "<div style='border: 1px solid black; padding: 5px;' id='detail'>";
print "</div>";
print "</form>";
print "</div>";
print renderClosePanel();

?>
<script>
	function deleteJob(jobid) {
		url='deleteRecord.php?key=pj_id&table=proposed_jobs_wc&id='+jobid;
		$.ajax({url: url, success: function(data) {document.listform.submit();}});
	}
	function sortby(byval) {
		if ('<?=$seq?>' == byval) {
			document.listform.seq.value=byval + ' desc';
		} else {
			document.listform.seq.value=byval;
		}
		document.listform.submit();
	}
	function showTip(data, dt) {
		$('#detail').html(dt+data);
	}
	function refreshCalendar() {
		wc=$('#wc').val();
		yr=$('#year').val();
		mo=$('#month').val();
		$('#wc_calendar').html("<img src='img/loading.gif'>");
		url='workCenterCapacityAjax.php?wc='+wc+'&year='+yr+'&month='+mo+'&rand='+Math.random();
		$.ajax({url: url, success: function(data) {
				$('#wc_calendar').html(data);
		}});
	}
	function page_init() {
		$('#new_part').autocomplete({source: itemList, minLength: 4, messages: {
        noResults: '',
        results: function() {}}});
		url='workCenterCapacityAjax.php?wc=<?=$workCenterSelected?>&year=<?=$year?>&month=<?=$month?>&rand='+Math.random();
		$.ajax({url: url, success: function(data) {
				$('#wc_calendar').html(data);
		}})
	}
</script>
<?php

include('footer.php');

?>