<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

#$sql="delete from order_lines where item_id='NEW' and quantity=0";
#list($rs,$err)=runIQuery($db,$sql);
$inserted=0;
$start=Date("m/1/Y");
$end=Date("m/d/Y");
$customer=0;
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
}
print "<form name='updform' action='wonLossReport.php' method='GET'>\n";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");

$sql="select customer_id, name from customers order by name";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print "<div class='btn btn-success' onclick='document.updform.submit();'>Run Report</div>\n";
print "<div class='btn btn-primary' onclick='exportReport()'>Export</div>\n";
print "</form>\n";

$sql="select po_number, date_order, ship_name, date_shipped, status_name, customers.name, orders.order_id, sum(quantity) as total_quantity, sum(quantity * price) as total_dollars 
from orders, order_status, order_lines, customers where orders.order_id in (select order_id from order_status_update where old_status=10) 
and status=status_id and orders.customer_id=customers.customer_id and date_order >= ? and date_order <= ? and orders.order_id=order_lines.order_id ";
if ($customer) {
	$sql.=" and orders.customer_id = ? ";
	$sql.=" group by po_number, date_order, ship_name, date_shipped, status_name, customers.name, orders.order_id order by status_name, date_order ";
	list($rs,$err)=runIQUery($db,$sql,array("ssi",formatDateWebToDB($start),formatDateWebtoDB($end),$customer));
} else {
	$sql.=" group by po_number, date_order, ship_name, date_shipped, status_name, customers.name, orders.order_id order by status_name, date_order ";
	list($rs,$err)=runIQUery($db,$sql,array("ss",formatDateWebToDB($start),formatDateWebtoDB($end)));
}
$holdStatus="";
$statusCount=0;
$statusQuantity=0;
$statusDollars=0;
$gtotCount=0;
$gtotQuantity=0;
$gtotDollars=0;
$totalWon=0;
$totalWonQuantity=0;
$totalWonDollars=0;
$totalLost=0;
$totalLostQuantity=0;
$totalLostDollars=0;
$totalQuoteQuantity=0;
$totalQuoteDollars=0;
$totalQuote=0;
print "<table class='table table-striped'><thead><tr><th>Status</th><th>Customer</th><th>Date Quoted</th><th>Date Shipped</th><th>Ship Name</th><th>Order/Quote</th><th>Total Qty</th><th>Total $</th></tr></thead><tbody>";
foreach ($rs as $data) {
	$order=$data['order_id'];
	$totalQuantity=$data['total_quantity'];
	$totalDollars=$data['total_dollars'];
	$dto=formatDateDBToWeb($data['date_order']);
	$shipName=$data['ship_name'];
	$dts=formatDateDBToWeb($data['date_shipped']);
	$status=$data['status_name'];
	if ($status != $holdStatus) {
		if ($holdStatus) {
			print "<tr><td>Total $holdStatus</td>";
			print "<td colspan='4'>";
			print "<td>";
			print number_format($statusCount,0);
			print "</td>";
			print "<td>";
			print number_format($statusQuantity,0);
			print "</td>";
			print "<td>";
			print number_format($statusDollars,2);
			print "</td>";
			print "</tr>";
			if ($holdStatus == "Cancelled") {
				$totalLost += $statusCount;
				$totalLostQuantity += $statusQuantity;
				$totalLostDollars += $statusDollars;
			} else {
				if ($holdStatus != "Quote") {
					$totalWon += $statusCount;
					$totalWonQuantity += $statusQuantity;
					$totalWonDollars += $statusDollars;
				} else {
					$totalQuote += $statusCount;
					$totalQuoteQuantity += $statusQuantity;
					$totalQuoteDollars += $statusDollars;
				}
			}
		}
		$holdStatus=$status;
		$statusCount=0;
		$statusQuantity=0;
		$statusDollars=0;
	}
	$po=$data['po_number'];
	$customer=$data['name'];
	$countit=1;
	if ($status == "Cancelled") {
		## check for others with the same PO Number but different orders that are  not cancelled 
		## if so, do not count this quote as cancelled.  But also do not count it as 'Won' as only the one that was flipped open counts
		$sql="select * from orders, customers  where po_number=? and orders.customer_id=customers.customer_id and name=? and orders.status <> 5";
		list($ckrs,$err)=runIQuery($db,$sql,array("ss",$po,$customer));
		if(count($ckrs)> 0) {
			$countit=0;
		}
	}
	if ($countit) {
		print "<tr>";
		print "<td>";
		print $status;
		print "</td>";
		print "<td>";
		print $customer;
		print "</td>";
		print "<td>";
		print $dto;
		print "</td>";
		print "<td>";
		print $dts;
		print "</td>";
		print "<td>";
		print $shipName;
		print "</td>";
		print "<td>";
		print "<a href='editOrders.php?id=$order' target='_blank' rel='opener'>";
		print $order;
		print "</a>";
		print "</td>";
		print "<td>";
		print number_format($totalQuantity,0);
		print "</td>";
		print "<td>";
		print number_format($totalDollars,2);
		print "</td>";
		print "</tr>";
		$statusQuantity += $totalQuantity;
		$statusDollars += $totalDollars;
		$statusCount++;
		$gtotQuantity += $totalQuantity;
		$gtotDollars += $totalDollars;
		$gtotCount++;
	}
}
if ($holdStatus) {
	print "<tr><td>Total $holdStatus</td>";
	print "<td colspan='4'>";
	print "<td>";
	print number_format($statusCount,0);
	print "</td>";
	print "<td>";
	print number_format($statusQuantity,0);
	print "</td>";
	print "<td>";
	print number_format($statusDollars,2);
	print "</td>";
	print "</tr>";
	if ($holdStatus == "Cancelled") {
		$totalLost += $statusCount;
		$totalLostQuantity += $statusQuantity;
		$totalLostDollars += $statusDollars;
	} else {
		if ($holdStatus != "Quote") {
			$totalWon += $statusCount;
			$totalWonQuantity += $statusQuantity;
			$totalWonDollars += $statusDollars;
		} else {
			$totalQuote += $statusCount;
			$totalQuoteQuantity += $statusQuantity;
			$totalQuoteDollars += $statusDollars;
		}
	}
}
print "<tr><td>Total</td>";
print "<td colspan='4'>";
print "<td>";
print number_format($gtotCount,0);
print "</td>";
print "<td>";
print number_format($gtotQuantity,0);
print "</td>";
print "<td>";
print number_format($gtotDollars,2);
print "</td>";
print "</tr>";
print "<tr><td>Still In Quote</td>";
print "<td colspan='4'>";
print "<td>";
print number_format($totalQuote,0);
print "</td>";
print "<td>";
print number_format($totalQuoteQuantity,0);
print "</td>";
print "<td>";
print number_format($totalQuoteDollars,2);
print "</td>";
print "</tr>";
print "<tr><td>Total Won</td>";
print "<td colspan='4'>";
print "<td>";
print number_format($totalWon,0);
print "</td>";
print "<td>";
print number_format($totalWonQuantity,0);
print "</td>";
print "<td>";
print number_format($totalWonDollars,2);
print "</td>";
print "</tr>";
print "<tr><td>Total Lost</td>";
print "<td colspan='4'>";
print "<td>";
print number_format($totalLost,0);
print "</td>";
print "<td>";
print number_format($totalLostQuantity,0);
print "</td>";
print "<td>";
print number_format($totalLostDollars,2);
print "</td>";
print "</tr>";
if ($gtotCount > 0) {
	print "<tr><td>Win Percentage</td>";
	print "<td colspan='4'>";
	print "<td>% ";
	$pct = $totalWon / $gtotCount * 100;
	print number_format($pct,1);
	print "</td>";
	print "<td>% ";
	$pct = $totalWonQuantity / $gtotQuantity * 100;
	print number_format($pct,1);
	print "</td>";
	print "<td>% ";
	$pct = $totalWonDollars / $gtotDollars * 100;
	print number_format($pct,1);
	print "</td>";
	print "</tr>";
}

print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>
function page_init() {
	$('.datepicker').datepicker();
}
function exportReport() {
	document.updform.action='wonLossExport.php';
	document.updform.target='_blank';
	document.updform.submit();
	document.updform.action='wonLossReport.php';
	document.updform.target='_self';
}
</script>
<?php
include('footer.php');
?>