<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=WonLoss.xls");
header("Pragma: no-cache");
header("Expires: 0");

$inserted=0;
$customer=0;
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
}

$sql="select po_number, date_order, ship_name, date_shipped, status_name, customers.name, orders.order_id, sum(quantity) as total_quantity, sum(quantity * price) as total_dollars from orders, order_status, order_lines, customers where orders.order_id in (select order_id from order_status_update where old_status=10) and status=status_id and orders.customer_id=customers.customer_id and date_order >= ? and date_order <= ? and orders.order_id=order_lines.order_id ";
if ($customer) {
	$sql.=" and orders.customer_id = ? ";
	$sql.=" group by po_number, date_order, ship_name, date_shipped, status_name, customers.name, orders.order_id order by status_name, date_order ";
	list($rs,$err)=runIQUery($db,$sql,array("ssi",formatDateWebToDB($start),formatDateWebtoDB($end),$customer));
} else {
	$sql.=" group by po_number, date_order, ship_name, date_shipped, status_name, customers.name, orders.order_id order by status_name, date_order ";
	list($rs,$err)=runIQUery($db,$sql,array("ss",formatDateWebToDB($start),formatDateWebtoDB($end)));
}
$holdStatus="";
$statusCount=0;
$statusQuantity=0;
$statusDollars=0;
$gtotCount=0;
$gtotQuantity=0;
$gtotDollars=0;
$totalWon=0;
$totalWonQuantity=0;
$totalWonDollars=0;
$totalLost=0;
$totalLostQuantity=0;
$totalLostDollars=0;
$totalQuoteQuantity=0;
$totalQuoteDollars=0;
$totalQuote=0;
print "Status\tCustomer\tDate Quoted\tDate Shipped\tShip Name\tOrder/Quote\tTotal Qty\tTotal $\n";
foreach ($rs as $data) {
	$order=$data['order_id'];
	$totalQuantity=$data['total_quantity'];
	$totalDollars=$data['total_dollars'];
	$dto=formatDateDBToWeb($data['date_order']);
	$shipName=$data['ship_name'];
	$dts=formatDateDBToWeb($data['date_shipped']);
	$status=$data['status_name'];
	if ($status != $holdStatus) {
		if ($holdStatus) {
			print "Total $holdstatus\t\t\t\t";
			print $statusCount;
			print "\t";
			print $statusQuantity;
			print "\t";
			print $statusDollars;
			print "\n";
			if ($holdStatus == "Cancelled") {
				$totalLost += $statusCount;
				$totalLostQuantity += $statusQuantity;
				$totalLostDollars += $statusDollars;
			} else {
				if ($holdStatus != "Quote") {
					$totalWon += $statusCount;
					$totalWonQuantity += $statusQuantity;
					$totalWonDollars += $statusDollars;
				} else {
					$totalQuote += $statusCount;
					$totalQuoteQuantity += $statusQuantity;
					$totalQuoteDollars += $statusDollars;
				}
			}
		}
		$holdStatus=$status;
		$statusCount=0;
		$statusQuantity=0;
		$statusDollars=0;
	}
	$customer=$data['name'];
	$po=$data['po_number'];
	$countit=1;
	if ($status == "Cancelled") {
		## check for others with the same PO Number but different orders that are  not cancelled 
		## if so, do not count this quote as cancelled.  But also do not count it as 'Won' as only the one that was flipped open counts
		$sql="select * from orders, customers  where po_number=? and orders.customer_id=customers.customer_id and name=? and orders.status <> 5";
		list($ckrs,$err)=runIQuery($db,$sql,array("ss",$po,$customer));
		if(count($ckrs)> 0) {
			$countit=0;
		}
	}
	if ($countit) {
		print "$status\t$customer\t$dto\t$dts\t$shipName\t$order\t";
		print $totalQuantity;
		print "\t";
		print $totalDollars;
		print "\n";
		$statusQuantity += $totalQuantity;
		$statusDollars += $totalDollars;
		$statusCount++;
		$gtotQuantity += $totalQuantity;
		$gtotCount++;
	}
}
if ($holdStatus) {
	print "Total $holdstatus\t\t\t\t";
	print $statusCount;
	print "\t";
	print $statusQuantity;
	print "\t";
	print $statusDollars;
	print "\n";
	if ($holdStatus == "Cancelled") {
		$totalLost += $statusCount;
		$totalLostQuantity += $statusQuantity;
		$totalDollars += $statusDollars;
	} else {
		if ($holdStatus != "Quote") {
			$totalWon += $statusCount;
			$totalWonQuantity += $statusQuantity;
			$totalWonDollars += $statusDollars;
		} else {
			$totalQuote += $statusCount;
			$totalQuoteQuantity += $statusQuantity;
			$totalQuoteDollars += $statusDollars;
		}
	}
}
print "Total\t\t\t\t";
print $gtotCount;
print "\t";
print $gtotQuantity;
print "\t";
print $gtotDollars;
print "\n";
print "Still In Quote\t\t\t\t";
print $totalQuote;
print "\t";
print $totalQuoteQuantity;
print "\n";
print $totalQuoteDollars;
print "\n";
print "Total Won\t\t\t\t";
print $totalWon;
print "\t";
print $totalWonQuantity;
print "\t";
print $totalWonDollars;
print "\n";
print "Total Lost\t\t\t\t";
print $totalLost;
print "\t";
print $totalLostQuantity;
print "\t";
print $totalLostDollars;
print "\n";
if ($gtotCount > 0) {
	print "Win Percentage\t\t\t\t% ";
	$pct = $totalWon / $gtotCount * 100;
	print $pct;
	print "\t% ";
	$pct = $totalWonQuantity / $gtotQuantity * 100;
	print $pct;
	print "\t% ";
	$pct = $totalWonDollars / $gtotDollars * 100;
	print $pct;
	print "\n";
}

