<?php
require_once 'vendor/autoload.php';

## get s3key and secret from weld's system
$url="https://preferredwelderp1.com/getS3Keys.php";
$resource = curl_init();
curl_setopt($resource, CURLOPT_URL, $url);
curl_setopt($resource, CURLOPT_HEADER, 0);
curl_setopt($resource, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($resource, CURLOPT_BINARYTRANSFER, 1);
curl_setopt($resource, CURLOPT_POST, 1);
curl_setopt($resource, CURLOPT_POSTFIELDS,
        "user=chris.allen@worldsourcetech.com&password=Chris@443");
list($weldKey,$weldSecret) = explode(",",curl_exec($resource));
curl_close($resource);

use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;
// Set Amazon S3 Credentials
$weldS3client = S3Client::factory(
    array(
        'credentials' => array(
            'key' => $weldKey,
            'secret' => $weldSecret
        ),
        'version' => 'latest',
        'region'  => 'us-east-1'
    )
);


$weldBucket="welderp";
$weldS3client->createBucket(array('Bucket' => $weldBucket));

$weldS3client->waitUntil('BucketExists', array('Bucket' => $weldBucket));


/**
 * Upload a file or string
 *
 * Source is either a path to a file or data to upload
 * fname is the name of the file
 * body is false if source is a path, if source is data to upload you must make it true
 *
 * @param string $source
 * @param string $fname
 * @param boolean $body
 * @return boolean
 */
function uploadWeldFile($source, $fname, $body = false) {
    global $weldSclient;
    global $weldBucket;

    $ext = pathinfo(strtolower($fname), PATHINFO_EXTENSION);
    $type = "application/octet-stream";
    if ($ext == "html") {
        $type = "text/html";
    }
    if ($ext == "png") {
        $type = "image/png";
    }
    if ($ext == "jpg") {
        $type = "image/jpeg";
    }
    if ($ext == "pdf") {
        $type = "application/pdf";
    }
    if ($ext == "dwg") {
        $type = "image/vnd.dwg";
    }
    if ($ext == "docx") {
        $type = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    }
    if ($ext == "stp") {
        $type = "application/step";
    }

    try {
        $opts = [
            'Bucket' => $weldBucket,
            'Key'    => $fname,
            'ContentType' => $type,
            'ContentDisposition' => 'inline'
        ];

        if ($body) {
            $opts['Body'] = $source;
        } else {
            $opts['SourceFile'] = $source;
        }

        $weldS3client->putObject($opts);
        return true;
    } catch (S3Exception $e) {
        return false;
    }
}