<?php
//take the dates from weeklyReport and turn them into db friendly dates
$start=formatDateWebtoDB($startDate);
$end=formatDateWebtoDB($endDate);

//data for rma summary

//number of rma customers
$sql="SELECT DISTINCT customer_id FROM orders WHERE po_number LIKE '%RMA%' AND date_due >= ? AND date_due <= ? "; 
list($rs,$err)=runIQuery($db,$sql,array("ss",$start,$end));
$rmaCustomers=count($rs);
if ($customer) {
	$rmaCustomers=1;
}

//number of rma orders
$sql="SELECT DISTINCT order_id FROM orders WHERE po_number LIKE '%RMA%' AND date_due >= ? AND date_due <= ? "; 
if ($customer) {
	$sql.=" and customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$customer));
} else {
	list($rs,$err)=runIQuery($db,$sql,array("ss",$start,$end));
}
$rmaOrders=count($rs);

//total number of rma parts shipped
$sql="SELECT DISTINCT part_number FROM packing_slip, packing_slip_lines WHERE packing_slip_id=packing_list_id AND date_shipped >= '$start' AND date_shipped <= DATE_ADD('$end', INTERVAL 1 DAY) AND shipped=1 ";
if ($customer) {
	$sql.=" and customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
} else {
	list($rs,$err)=runIQuery($db,$sql);
}
$totalShippedPart=count($rs);

//total number of rma pieces shipped
$sql="SELECT sum(quantity) FROM packing_slip, packing_slip_lines WHERE packing_slip_id=packing_list_id AND date_shipped >= '$start' AND date_shipped <= DATE_ADD('$end',INTERVAL 1 DAY) AND shipped=1 ";
if ($customer) {
	$sql.=" and customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
} else {
	list($rs,$err)=runIQuery($db,$sql);
}
$totalShippedPiece=$rs[0][0];

//bulk of rma data for multiple tables
$sql="SELECT DISTINCT customers.name, orders.po_number, orders.rma_reason, rma_reasons.reason_description, orders.notes_to_self, order_lines.line_id, 
	order_lines.price, order_lines.due_date, orders.date_due, orders.date_order, order_lines.item_id, 
	COALESCE(rma_update.true_quantity, order_lines.quantity) AS quantity,
	COALESCE(rma_update.assigned_team, rma_reasons.reason_team, 0) AS team, departments.department_name, 
	COALESCE(rma_update.true_reason, orders.rma_reason) AS reason, rma_update.management_notes 
	FROM orders 
	INNER JOIN customers ON orders.customer_id = customers.customer_id
INNER JOIN order_lines ON orders.order_id = order_lines.order_id
LEFT OUTER JOIN rma_update ON order_lines.line_id=rma_update.line_id
LEFT OUTER JOIN rma_reasons ON orders.rma_reason = rma_reasons.reason_id
LEFT OUTER JOIN departments ON COALESCE(rma_update.assigned_team, rma_reasons.reason_team, 0)=departments.department_id
WHERE orders.po_number LIKE '%RMA%'
AND orders.date_due >= ? AND orders.date_due <= ? ";
if ($customer) {
	$sql.=" and orders.customer_id=?";
	list($rmars,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$customer));
} else {
	list($rmars,$err)=runIQuery($db,$sql,array("ss",$start,$end));
}


//irma query
$sql="SELECT DISTINCT customers.name, orders.po_number, job_defects.date_reported, order_lines.item_id, order_lines.due_date, job_defects.jd_id, orders.date_order, order_lines.line_id,
operations.operation_name, job_defects.defect_notes, job_defects.management_notes, site_admins.full_name AS reported_by, salespeople.full_name AS entered_by,
job_defects.defect_type, routing.display_sequence,
COALESCE(job_defects.real_caused_by, job_defects.caused_by) AS caused_by,
COALESCE(job_defects.real_quantity, job_defects.quantity) AS quantity,
COALESCE(job_defects.real_defect_type, job_defects.defect_type) AS real_defect_type
FROM job_defects 
INNER JOIN jobs ON job_defects.job_id=jobs.job_id
INNER JOIN order_lines ON jobs.line_id=order_lines.line_id
INNER JOIN orders ON order_lines.order_id=orders.order_id
INNER JOIN routing ON job_defects.routing_id=routing.routing_id
LEFT OUTER JOIN operations ON routing.operation_id=operations.operation_id
LEFT OUTER JOIN customers ON orders.customer_id=customers.customer_id
-- LEFT OUTER JOIN defect_types ON job_defects.defect_type=defect_types.defect_id
LEFT OUTER JOIN site_admins ON job_defects.user_id=site_admins.user_id
LEFT OUTER JOIN salespeople ON orders.salesperson_id=salespeople.salesperson_id
WHERE job_defects.date_reported >= ? AND job_defects.date_reported <= ?";
if ($customer) {
	$sql.=" AND orders.customer_id=?";
	list($irmars,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$customer));
} else {
	list($irmars,$err)=runIQuery($db,$sql,array("ss",$start,$end));
}

?>