<?php
$expanded=1;
$locked=0;

include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

print renderPanel("Weekly RMA and IRMA Report","","red","span11","cogs");

// getting the user filters for the search form for time period and customer

if (isset($_GET['start_date'])) {
	$startDate=$_GET['start_date'];
} else {
	$startDate=Date("m/d/Y");
}
if (isset($_GET['end_date'])) {
	$endDate=$_GET['end_date'];
} else {
	$endDate=Date("m/d/Y");
}
$customer=0;
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
}
if (! $customer) {
	$customer=0;
	if (isset($_GET['name'])) {
		$name=$_GET['name'];
		$sql="select customer_id from customers where name=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$name));
		$data=$rs[0];
		$customer=$data[0];
	}	
}
//search form for date range and customer
print "<form name='findform' action='weeklyReport.php' method='GET'>";
print renderDateBox(TRUE,"start_date",$startDate,"Start Date");
print renderDateBox(TRUE,"end_date",$endDate,"End Date");
// add inactive customers code -Josh 02/20/2023
$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print renderButton("Run Report","red","document.findform.submit();");
//print renderButton("Export","primary","exportForm();");
print "</form>";

//rma summary goes here
print "<div id='summary'></div>";

// rma data for the time period
//variables for rma data table
$partsrma=array();

//including weeklyReportSub.php, which does the sql queries for weeklyReport.php
include('weeklyReportSub.php');

$partsrma=array();
$reasonrma=array();
$duplicates=0;
$totalRMACost=0;
$materialList=array();

//tables by customer, with fields that can be edited 
//RMA data table
print "<center><h3>RMA</h3></center>";
print "<table class='table table-striped'><thead><tr>";
print "<th>Customer</th>";
print "<th>PO</th>";
print "<th>RMA Reason</th>";
print "<th>Notes</th>";
print "<th>Date Due</th>";
print "<th>Item</th>";
//print "<th>Material</th>";
print "<th>Quantity</th>";
print "<th>Dollars</th>";
//print "<th>Original Reviewed By</th>";
print "<th>Original Entered By</th>";
print "<th>Original Entered Date</th>";
print "<th>Original Due</th>";
print "<th>Team</th>";
print "<th>True Reason</th>";
print "<th>Management Notes</th>";
print "</tr>\n</thead>";
print "<tbody>";

foreach ($rmars as $data) {
	$customer=$data['name'];
	$po=$data['po_number'];
	$reason=$data['reason_description'];
	$notes=$data['notes_to_self'];
	$item=$data['item_id'];
	$quantity=$data['quantity'];
	$team=$data['department_name'];
	$teamID=$data['department_id'];
	$true=$data['reason'];
	$mnotes=$data['management_notes'];
	$line=$data['line_id'];
	//price divided by 1.2 for the cost, cost times 2 to get the price
	$price=number_format(($data['price']*1.67),2);
	
	// unset($materialList);
	// findMaterials($item);

	//getting the original order
	if (strstr($po,"-")) {
		list($originalOrder,$rma)=explode("-",$po);
	} else {
		$originalOrder=$po;
	}

	$sql="SELECT orders.date_due, orders.date_order, salespeople.full_name FROM orders LEFT OUTER JOIN salespeople ON salespeople.salesperson_id=orders.salesperson_id WHERE orders.po_number=?";
	list($ors,$err)=runIQuery($db,$sql,array('s',$originalOrder));
	if (count($ors)) {
		foreach($ors as $odata) {
			$enteredBy=$odata['full_name'];
			$enteredDate=formatDateDBToWeb($odata['date_order']);
			$originalDue=formatDateDBToWeb($odata['date_due']);
		}
	} else {
		$enteredBy="";
		$enteredDate="";
		$originalDue="";
	}

	if (! isset($reasonrma[$reason])) {
		$reasonrma[$reason]=$quantity;
	} else {
		$reasonrma[$reason]+=$quantity;
	}
	if (! isset($partsrma[$item])) {
		$partsrma[$item]=$quantity;
	} else {
		$duplicates++;
		$partsrma[$item]+=$quantity;
	}
	
	$partcount=count($partsrma);
	$piececount=0;
	foreach($partsrma as $key => $value) {
		$piececount+=$value;
	}
	//total rma cost
	$totalRMACost+=$price;

	print "<tr>";
	print "<td>$customer</td>";
	print "<td>$po</td>"; //needs to be changed still - simplified version of what machine had
	print "<td>$reason</td>";
	print "<td>";
	print nl2br($notes);
	print "</td>";
	print "<td>";
	print formatDateDBToWeb($data['due_date']);
	print "</td>";
	print "<td>$item</td>";
	// print "<td>";
	// if ($materialList==!NULL) {
	// 	print "<ul>";
	// 	foreach($materialList as $material) {
	// 		if ($material) {
	// 			print "<li>$material</li>";
	// 		}
	// 	}
	// 	print "</ul>";
	// 	} 
	// print "</td>";
	print "<td>";
	if ($isAdmin) {
		print "<input type='text' style='width: 100px; text-align: right;' name='qty' value='$quantity' onchange=\"updateField('quantity',this.value,'$line');\">";
	} else {
		print $quantity; 
	}
	print "</td>";
	print "<td>$$price</td>";
	//print "<td>Reviewed By</td>";
	print "<td>$enteredBy</td>";
	print "<td>$enteredDate</td>";
	print "<td>$originalDue</td>";
	print "<td>";
	if ($isAdmin) {
		$sql="SELECT department_id, department_name FROM departments ORDER BY department_name";	
		$drs=mysqli_query($db,$sql);
		print "<select name='team' onchange=\"updateField('team',this.value,'$line');\">";
		print renderOptions($drs,$teamID,1,0);
		print "</select>";
	} else {
		print $team; 
	}
	print "</td>";
	print "<td>";
	if ($isAdmin) {
		$sql="SELECT reason_id, reason_description FROM rma_reasons ORDER BY reason_description";
		$rrs=mysqli_query($db,$sql);
		print "<select name='true_reason' onchange=\"updateField('reason',this.value,'$line');\">";
		print renderOptions($rrs,$true,0,0);
		print "</select>";
	} else {
		print $true; 
	}
	print "</td>";
	print "<td>";
	if ($isAdmin) {
		print "<textarea name='notes' onchange=\"updateField('notes',this.value,'$line');\">$mnotes</textarea>";
	} else {
		print $mnotes; 
	}
	print "</td>";
	print "</tr>";

} 

print "</tbody></table>";

//rma summary data
print "<div id='rmasummary' style='margin-top: 100px'>";
print "<h3 style='text-align: left'>RMA Summary</h3>";
print "<div><table class='table-striped'>";
print "<tr><td>Total RMA Cost:</td><td>$";
print number_format($totalRMACost,2);
print "</td></tr>";
print "<tr><td>Different Customers:</td><td>$rmaCustomers</td></tr>"; //from weeklyReportSub
print "<tr><td>Number of Orders:</td><td>$rmaOrders</td></tr>";
print "<tr><td>Total Part Count:</td><td>$partcount</td></tr>";
print "<tr><td>Duplicates:</td><td>$duplicates</td></tr>";
print "<tr><td>Total Parts Shipped:</td><td>$totalShippedPart</td></tr>";
if ($totalShippedPart > 0) {
	$pct=$partcount/$totalShippedPart*100;
	$pct=number_format($pct,1);
} else {
	$pct=0;
}
print "<tr><td>Percent RMA by Part:</td><td>$pct%</td></tr>";
print "<tr><td>Total Piece Count:</td><td>$piececount</td></tr>";
print "<tr><td>Total Pieces Shipped:</td><td>$totalShippedPiece</td></tr>";
if ($totalShippedPiece > 0) {
	$pct=$piececount / $totalShippedPiece * 100;
	$pct=number_format($pct,1);
} else {
	$pct=0;
}
print "<tr><td>Percent RMA by Piece:</td><td>$pct%</td></tr>";
print "</table></div>";

//rma table by reasons
print "<div><table class='table-striped' style='margin-top: 10px'>";
print "<tr><th>Reason</th><th>RMA Part Count</th></tr>";
foreach ($reasonrma as $key => $value) {
	print "<tr><td>$key</td><td>$value</td></tr>";
}
print "</table></div>";
print "</div>";


//irma stuff
//IRMA data table
print "<center><h3>IRMA</h3></center>";
print "<table class='table table-striped'><thead><tr>";
print "<th>Customer</th>";
print "<th>Purchase Order</th>";
print "<th>Defect</th>";
print "<th>Date of Defect</th>";
print "<th>Defect Notes</th>";
print "<th>Item</th>";
//print "<th>Material</th>";
print "<th>Quantity</th>";
print "<th>Dollars</th>";
print "<th>Reported By</th>";
print "<th>Entered By</th>";
print "<th>Caused By</th>";
print "<th>Original Enter Date</th>";
print "<th>Original Due</th>";
print "<th>Operation</th>";
print "<th>True Defect</th>";
print "<th>Management Notes</th>";
print "</tr>\n</thead>";
print "<tbody>";
//taking irma data and turning it into variables
$irmadefects=array();
$partsirma=array();
$iduplicates=0;
$totalIRMACost=0;
foreach ($irmars as $data) {
	$customer=$data['name'];
	$po=$data['po_number'];
	$type=$data['defect_type'];
	$realType=$data['real_defect_type'];
	$item=$data['item_id'];
	$quantity=$data['quantity'];
	$cause=$data['caused_by'];
	$dateReported=formatDateDBToWeb($data['date_reported']);
	$dateDue=formatDateDBToWeb($data['due_date']);
	$dateEntered=formatDateDBToWeb($data['date_order']);
	$operation=$data['operation_name'];
	$notes=$data['defect_notes'];
	$mnotes=$data['management_notes'];
	$enteredBy=$data['entered_by'];
	$reportedBy=$data['reported_by'];
	$jd=$data['jd_id'];
	$lineID=$data['line_id'];
	$display=$data['display_sequence'];

	//getting the caused by from the id
	$sql="SELECT CONCAT(first_name,' ', last_name) as emp_name FROM employees WHERE employee_id=?";
	list($ers,$error)=runIQuery($db,$sql,array('i',$cause));
	$causedBy=$ers[0][0];

	//getting the defect type from the id
	$sql="SELECT defect_name FROM defect_types WHERE defect_id=?";
	list($drs,$error)=runIQuery($db,$sql,array('i',$type));
	$defect=$drs[0][0];
	list($rdrs,$error)=runIQuery($db,$sql,array('i',$realType));
	$realDefect=$rdrs[0][0];

	//getting a default cost
	// $sql="SELECT price FROM order_lines WHERE line_id=?";
	// list($irs,$err)=runIQuery($db,$sql,array("i",$lineID));
	// $idata=$irs[0];
	// $cost=0;
	// if ($idata['price'] > 0) {
	// 	$cost=$idata['price'] * $quantity;
	// }
	$cost=calculateCost($db,$item,$lineID,$display);
	$cost=round($cost,2);

	$totalIRMACost+=$cost;

	if (! isset($irmadefects[$defect])) {
		$irmadefects[$defect]=$quantity;
	} else {
		$irmadefects[$defect]+=$quantity;
	}
	if (! isset($partsirma[$item])) {
		$partsirma[$item]=$quantity;
	} else {
		$partsirma[$item]+=$quantity;
		$iduplicates++;
	}

	$partcount=count($partsirma);
	$piececount=0;
	foreach($partsirma as $key => $value) {
		$piececount+=$value;
	}

	//getting materials
	// unset($materialList);
	// findMaterials($item);

	print "<tr>";
	print "<td>$customer</td>";
	print "<td>$po</td>";
	print "<td>$defect</td>";
	print "<td>$dateReported</td>";
	print "<td>$notes</td>";
	print "<td>$item</td>";
	// print "<td><ul>";
	// if (count($materialList)) {
	// foreach($materialList as $material) {
	// 	print "<li>$material</li>";
	// }
	// print "</ul></td>";
	// } else {
	// 	print "<td></td>";
	// }
	print "<td>";
	if ($isAdmin) {
		print "<input type='text' style='width: 100px; text-align: right;' name='qty' value='$quantity' onchange=\"updateDefect('quantity',this.value,'$jd');\">";
	} else {
		print $quantity;
	}
	print "</td>";
	print "<td>$";
	print number_format($cost,2);
	print "</td>";
	print "<td>$reportedBy</td>";
	print "<td>$enteredBy</td>";
	print "<td>";
	if ($isAdmin) {
		$sql="SELECT employee_id, CONCAT(first_name,' ', last_name) as emp_name FROM employees ORDER BY emp_name";	
		$crs=mysqli_query($db,$sql);
		print "<select name='cause' onchange=\"updateDefect('cause',this.value,'$jd');\">";
		print renderOptions($crs,$cause,1,0);
		print "</select>";
	} else {
		print $causedBy; 
	}
	print "</td>";
	print "<td>$dateEntered</td>";
	print "<td>$dateDue</td>";
	print "<td>$operation</td>";
	print "<td>";
	if ($isAdmin) {
		$sql="SELECT defect_id, defect_name FROM defect_types ORDER BY defect_name";
		$trs=mysqli_query($db,$sql);
		print "<select name='defect' onchange=\"updateDefect('defect',this.value,'$jd');\">";
		print renderOptions($trs,$type,0,0);
		print "</select>";
	} else {
		print $realDefect; 
	}
	print "</td>";
	print "<td>";
	if ($isAdmin) {
		print "<textarea name='notes' onchange=\"updateDefect('notes',this.value,'$jd');\">$mnotes</textarea>";
	} else {
		print $mnotes; 
	}
	print "</td>";
	print "</tr>";
}
print "</tbody></table>";


//irma summary data
print "<div id='irmasummary' style='margin-top: 20px'>";
print "<h3>IRMA Summary</h3>";
print "<div><table class='table-striped'>";
print "<tr><td>Total IRMA Cost:</td><td>$";
print number_format($totalIRMACost,2);
print "</td></tr>";
print "<tr><td>Total IRMA Part Count:</td><td>$partcount</td></tr>";
print "<tr><td>Total IRMA Piece Count:</td><td>$piececount</td></tr>";
print "<tr><td>Duplicate IRMA:</td><td>$iduplicates</td></tr>";
print "</table></div>";

//irma table by reasons
print "<div id='irmacount'><table class='table-striped' style='margin-top: 10px'>";
print "<tr><th>Defect</th><th>IRMA Part Count</th></tr>";
foreach ($irmadefects as $key => $value) {
	print "<tr><td>$key</td><td>$value</td></tr>";
}
print "</table></div>";
print "</div>";


print renderClosePanel();
?>

<script>

	function page_init() {
		$('#irmasummary').insertBefore($('#summary'));
		$('#rmasummary').insertBefore($('#irmasummary'));
	}

function updateDefect(fieldname, newvalue, jd) {
	$.ajax({
                url:`updateJobDefects.php?field=${fieldname}&value=${newvalue}&id=${jd}&rand=${Math.random()}`,    
                type: "post",    
                success:function(result){
                    $.gritter.add("Updated.");
                }
            });
}

function updateField(fieldname,newvalue,line) {
        $.ajax({
                url:`updateRMAUpdate.php?field=${fieldname}&value=${newvalue}&line=${line}&rand=${Math.random()}`,    
                type: "post",    
                success:function(result){
                    $.gritter.add("Updated.");
                }
            });
    }

</script>

<?php 
include('footer.php');
?>