<?php 

//run an ajax based query here to get the pallet options and render them in the model
?>

<!-- Load Pallet Modal -->
<div class="modal fade" id="load_pallet_modal" tabindex="-1" role="dialog" aria-labelledby="load_pallet_modal" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="load_pallet_modal_label">Load Parts to Pallet <span id="bayAndPallet"></span> from Transport Cart</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <form class="form" action="#">
            <div class="row form-group">
              <div class="col-sm-6">
                <input type="text" class="form-control" name="itemId" id="item_id" placeholder="Scan Item">
              </div>
              <div class="col-sm-6">
                <input type="number" class="form-control" name="confirmQuan" id="confirm_quan" placeholder="Quantity">
                <span id="quantityPlannedLabel">Quantity Planned:</span> <span id="quantityRequired"></span>
              </div>
              <div class="row" id="quantityMsg" style="visibility:hidden;">
              <div class="col-sm-12">
              <span id="quantityMessage"></span>
              </div>
              </div>
            </div>
            <input type="hidden" name="bayName" id="bay_name" value="">
            <input type="hidden" name="bayId" id="bay_id" value="">
            <input type="hidden" name="palletId" id="pallet_id" value="">
            <input type="hidden" name="orderId" id="order_id" value="">
            <input type="hidden" name="palletSequence" id="pallet_sequence" value="">
            <input type="hidden" name="quantity_planned" id="quantity_planned" value="">
          </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button id="newPallet" id="confirmLoad" class="btn btn-success" onClick="confirmLoad();">Save</button>
      </div>
    </div>
  </div>
</div>

<script>
 function confirmLoad(){
   // confirm correct quantities for item scanned to the bay and pallet selected.
    //later do something with confirm shortage (eg they have to put a note in and click confirm or something to let others know where the remaining parts are)
     //1. check required quanitty
      //2. update quantityMessage
      //3. [later] if quanity is less than expected, disable save until "acknowlege less than message clicked"
      //4. ajax update pallets_have_items, confirmed_quantity, confirmed_by, confirmed where pallet_id and item_id
      //5. .done if successful show success message and button to scan another or done 
    let confirmShortage = 0;
    let item = $("#item_id").val();
    let order = $("#order_id").val();
    let quantity = $("#confirm_quan").val();
    let palletId = $("#pallet_id").val();
    let sequence = $("#pallet_sequence").val();
    let bayName = $("#bay_name").val();
    let bayId = $("#bay_id").val();

          $.ajax({
        method: "POST",
        url: "ajax/getPalletItemQuan.php",
        data: {pallet:palletId,part:item,orderId:order}
        }).done(function(palletQuanResult) 
        {
        
          let decodedResults = JSON.parse(palletQuanResult);
          if (decodedResults.success =="true") 
          { 
              console.log(decodedResults.response);
              let quantityPlanned = decodedResults.response[0].quantityPlanned;
              let confirmedQuantity = decodedResults.response[0].confirmedQuan;
            if (confirmedQuantity < quantityPlanned)
            {
            
              $("#quantityPlanned").css("visibility", "visible");
              $("#quantityMsg").css("visibility", "visible");
              if(quantity != quantityPlanned )
              {
                //later do something with confirm shortage (eg they have to put a note in and click confirm or something to let others know where the remaining parts are)
                confirmShortage = 1;
                if(quantity > quantityPlanned){
                  overShort = quantity-quantityPlanned+' over';        
                }
                else {
                  overShort = quantityPlanned-quantity+' short';
                }
              
                $("#quantityMessage").html("<span class='alert alert-danger center'>This pallet is expecting "+quantityPlanned+" total items and is currently  "+overShort+"</span>");
              }
              else 
              {
                $.ajax({
                  method: "POST",
                  url: "ajax/scanItemsOntoPallet.php",
                  data: {confirmedQuan:quantity,pallet:palletId,part:item,orderId:order,bay_name:bayName,item_sequence:sequence,bay:bayId}
                  }).done(function(confirmedOnPalletResult) {
                    let decodedConfirmResults = JSON.parse(confirmedOnPalletResult);
                    
                    if (decodedConfirmResults.success == 'true')
                    {
                      
                      window.location.href = "/bayOps.php";

                    }
                    else 
                    {
                      alert('There was an error 114: '+ decodedConfirmResults.response);
                      window.location.href = "/bayOps.php";
                    }
                  })
              }
            }
            else 
            {
              alert('There was an error 122: '+ decodedConfirmResults.response);
                      window.location.href = "/bayOps.php";
            }
          }
        else 
        {
          alert('There was an error 128: '+ decodedResults.response);
                    window.location.href = "/bayOps.php";
        }
      })
 }
     

  
  
</script>