<?php
$packingSlip=$_GET['pack'];
$all=1;
#if (isset($_GET['all'])) {
	#$all=$_GET['all'];
#}
$type="PACK";
$isTransfer=0;
if (isset($_GET['transfer'])) {
	$isTransfer=$_GET['transfer'];
}
if ($isTransfer) {
	$pageTitle="Transfer $packingSlip";	
	$type="MT";
} else {
	$pageTitle="Packing Slip $packingSlip";
}
include('dbConnection.php');
include('security.php');
include('functions.php');
$sql="select * from packing_slip where packing_slip_id=?";
if ($isTransfer) {
	$sql="select * from transfers where packing_slip_id=?";
}
list($rs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$pdata=$rs[0];
$customer_id=$pdata['customer_id'];
$vendorID=$pdata['vendor_id'];
$dateSigned=formatDateDBToWeb($pdata['date_signed']);
$sql="select * from customers where customer_id=?";
list($crs,$err)=runIQuery($db,$sql,array("i",$customer_id));
$cdata=$crs[0];
$sql="select * from company_shiptos where business_unit=$businessUnit order by use_on_packer desc, shipto_id";
list($srs,$err)=runIQuery($db,$sql);
$sdata=$srs[0];
$coname=$sdata['ship_name'];
function printFooter($pdata,$sdata,$lc=0) {
	$retval="";
	global $type, $db;
	$retval.="<tr><td>&nbsp;</td></tr>\n";
	if ($lc < 20) {
	$retval.="<tr><td>&nbsp;</td></tr>\n";
	$retval.="<tr><td>&nbsp;</td></tr>\n";
	}
	$retval.="</table>";
	$retval.="<table width='100%' style='font-size: 12px;' align='center'>";
	$retval.="<tr><td colspan='6'>";
	$retval.="By signing this packing slip, you are agreeing that the listed parts and quantities are accurate and acceptable.  You will have 5 business days from the date below to claim any discrepancies.";
	$retval.="</td></tr>\n";
	if ($lc < 20) {
		$retval.="<tr><td>&nbsp;</td></tr>\n";
		$retval.="<tr><td>&nbsp;</td></tr>\n";
		$retval.="<tr><td>&nbsp;</td></tr>\n";
	}
	$retval.="</table>";
	$retval.="<table align='right'>";
	$retval.="<tr>";
	$notes=$pdata['notes_to_customer'];
	$retval.="<tr><td>$notes</td></tr>\n";
	$retval.="<td align='right'>RECEIVED BY:";
	$id=$pdata['packing_slip_id'];
	if ($pdata['signed_by']) {		
		include('s3.php');
		$s3client->registerStreamWrapper();
		$file="signature-$type$id.png";
		if (file_exists("s3://$bucket/$file")) {
			$retval.= "<img src='showDBImagePNG.php?file=$file' height='100'>";		
		} else {
			print "no exist";
		}
		$retval.=" " . $pdata['signed_by'];
		$retval.=" " . formatDateDBToWeb($pdata['date_signed']);
		$retval.="</td></tr>";
	} else {
		$retval.="__________________ DATE: ________</td></tr>";
	}
	 
	$retval.="<tr>";
	$retval.="<td align='right'>";
	$retval.=$sdata['ship_address'];
	$retval.=" &bull; ";
	$retval.=$sdata['ship_city'];
	$retval.=", ";
	$retval.=$sdata['ship_state'];
	$retval.=" ";
	$retval.=$sdata['ship_zip'];
	$retval.=" &bull; ";
	$retval.="PHONE: ";
	$retval.=$sdata['ship_phone'];
	$retval.=" &bull; ";
	$retval.=$sdata['ship_email'];
	$retval.="</td></tr>";
	$retval.="</table>";
	return $retval;
}
function printHeader($pdata,$cdata,$date_shipped,$sdata,$packingSlip, $folderNumber) {
	## sdata is company shipto
	## data is packing slip header info
	## cdata is customer info
	global $isTransfer;
	$retval="";
	$coname=$sdata['ship_name'];
	$retval.="<table width='100%' align='center'>";
	$retval.="<tr><Td valign='top'><img src='images/logo.png' height='150'><BR>$coname";	
	$retval.="</Td>";
	$retval.="<td colspan='2'>";
	if ($isTransfer) {
		$retval.="<h2>Transfer $packingSlip</h2>";
	} else {
		$retval.="<h2>Packing Slip $packingSlip</h2>";
		$retval.="<h4>(Invoice $folderNumber)</h2>";
	}
	$retval.="</td>";
	$retval.="<td align='center'>";	
	$retval.="<div style='font-size: 20px;'>*$packingSlip*</div>";
	$retval.="</td>";
	$retval.="</tr>";
	$retval.="<tr><td colspan=2 align='right' valign='top'>";
	$retval.="Date: $date_shipped<BR>";
	$retval.="Page: 1 of 1<BR>";
	$retval.="</td></tr>\n";
	$retval.="<tr><td valign='top' style='border: 1px solid black; font-size: 24px;'>";
	$retval.="<div style='font-size: 14px;'>Sold To:</div>";
	$retval.=$cdata['name'];
	$retval.="</td><td width=200></td>";
	$retval.="<td valign='top' style='border: 1px solid black; font-size: 24px;'>";
	$retval.="<div style='font-size: 14px;'>Ship To:</div>";
	if ($pdata['ship_name']) {
		$retval.=$pdata['ship_name'];
		$retval.="<BR>";
	} else {
		$retval.=$cdata['name'];		
		$retval.="<BR>";
	}
	if ($pdata['attention']) {
		if (trim($pdata['attention'])!=trim($pdata['ship_name'])) {
			$retval.=trim($pdata['attention']);
			$retval.="<BR>";
		}
	}
	if ($pdata['ship_address']) {
		if (trim($pdata['ship_address'])!=trim($pdata['ship_name'])) {
			$retval.=$pdata['ship_address'];
			$retval.="<BR>";
		}
	} else {
		if (trim($cdata['address'])!=trim($pdata['ship_name'])) {
			$retval.=$cdata['address'];
		}
	}
	$retval.=$pdata['ship_city'];
	$retval.=", ";
	$retval.=$pdata['ship_state'];
	$retval.=" ";
	$retval.=$pdata['ship_zip'];
	$retval.="<BR>";
	if ($pdata['ship_email']) {
		$retval.=$pdata['ship_email'];
		$retval.="<BR>";
	}
	$retval.=$pdata['ship_phone'];
	$retval.="</td></tr>";
	$retval.="<tr><Td>&nbsp;</Td></tr>\n";
	$tracking_number=$pdata['tracking_number'];
	if ($tracking_number) {
		$retval.="<tr><td colspan='3' align='right'>$tracking_number</td></tr>";
	}
	$notes_to_customer=$pdata['notes_to_customer'];
	$retval.="</table>";
	$retval.="<table width='100%' cellpadding=3 cellspacing=0 align='center'>";
	$retval.="<tr><td style='border-bottom: 1px solid black;'>Line</td><td style='border-bottom: 1px solid black;'>Part</td><td style='border-bottom: 1px solid black;' align='right'>Quantity</td><td style='border-bottom: 1px solid black;' align='center'>Your PO#</td><td style='border-bottom: 1px solid black;' align='center'>Your PO Line</td></tr>\n";
	return $retval;
}
?>
<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<html lang="en">
<head>
<meta charset="utf-8"/>
<title><?=$pageTitle?></title>	
<link rel="stylesheet" href="css/layout.css" type="text/css" media="screen" />
<?php
print "</head>";
print "<body style='font-size: 14px;' onunload='window.opener.reload();'>\n";
print "<center>";
if ($pdata['signed_by']) {
	print "<button type='button' style='color: white; background-color: green; height: 100px; width: 200px;' onclick='signSlip();'>Sign Again</button>";
} else {	
	print "<button type='button' style='color: white; background-color: green; height: 100px; width: 200px;' onclick='signSlip();'>Sign</button>";
}
print "</center>";
$date_shipped=formatDateDBToWeb($pdata['date_shipped']);
$date_printed=formatDateDBToWeb($pdata['date_printed']);
$sql="select date_shipped, date_printed from packing_slip where packing_slip_id=?";
list($urs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$udata=$urs[0];	
$date_shipped=formatDateDBToWeb($udata['date_shipped']);
$date_printed=formatDateDBToWeb($udata['date_printed']);

$sql="select distinct folder_number from packing_slip_lines, orders where packing_list_id=? and packing_slip_lines.order_id=orders.order_id ";
list($rs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$data=$rs[0];
$folderNumber=$data[0];
## not the weldments 62 or purchase 71
$sql="select * from packing_slip_lines where packing_list_id=? and order_line not in (select line_id from order_line_operations where operation_id in (62,71))
and part_number not in ('LOT CHARGE','MIN LOT CHARGE', 'DELIVERY CHARGE')  order by order_id, order_line";
list($rs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$lc=99;
$printlc=0;
foreach ($rs as $data) {
	$lc++;
	$printlc++;
	if ($lc > 20) {
		if ($lc < 99) {
			print printFooter($pdata,$sdata,$lc);
			print "\n";
			print "<p style='page-break-after: always;'>&nbsp;</p>\n";
		}
		print printHeader($pdata,$cdata,$date_shipped,$sdata,$packingSlip,$folderNumber);
		$lc=1;
	}
	$item=$data['part_number'];
	$desc=$data['description'];
	$qty=$data['quantity'];
	$order=$data['order_id'];
	$line=$data['order_line'];	
	$po=$data['po_number'];
	$po_line=$data['po_line'];
	if ($po_line==0) {
		$po_line="";
	}	
	print "<tr><td valign='top' align='center' style='border-left: 1px solid black; '>$printlc</td>";
	print "<td valign='top' style='border-left: 1px solid black; '><b>$item $desc</b></td>";
	print "<td valign='top' align='right' style='border-left: 1px solid black; '><b>$qty</b></td>";
	$sql="select po_number, po_line from orders, order_lines where orders.order_id=? and orders.order_id=order_lines.order_id and order_lines.line_id=?";
	list($drs,$err)=runIQuery($db,$sql,array("ii",$order,$line));
	$ldata=$drs[0];
	print "<td valign='top' style='border-left: 1px solid black; ' align='center'><b>$po</b></td>";
	print "<td valign='top' style='border-left: 1px solid black; border-right: 1px solid black; ' align='center'>$po_line</td>";
	print "</tr>\n";
}
if ($lc > 0) {
	print printFooter($pdata,$sdata,$lc);
}
?>
<script>
function signSlip() {
	url='signature.php?type=<?=$type?>&id=<?=$packingSlip?>&all=<?=$all?>&rand='+Math.random();
	window.open(url,'_blank');
}
function page_init() {
	window.opener.document.location.reload();
}
</script>
</body>
</html>