<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
require_once('s3.php');
$id=$_GET['id'];
$table="orders";
?>
<div id='responser'></div>
<?php
	$title= "Order " . $id;
	print renderPanel($title,"","green","span11","star");
	print renderButton("Done","","self.close();");
	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];

	$dh = listFiles();

	foreach ($dh as $fulldir) {
		$tmp = explode('/', $fulldir); //only get the final file
		$filename = array_pop($tmp);

		if (! in_array($filename,array(".",".."))) {
			list($prefix,$rest)=explode("-",$filename);
			if ($prefix == "SO".$id) {
				$rest=substr($filename,strlen($prefix)+1,999);
				$fid=str_replace("-","",str_replace(".","",$filename));
				$flink = rawurlencode($fulldir);
				print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' target='_blank'>View $rest</a>&nbsp;<br>";
			}
		}
	}

	$qbid=$data['quickbooks_order_number'];
	$priority=$data['priority'];
	$priorityColor="black";
	$priorityName="Normal";
	$sql="select priority_color, priority_name from order_priorities where priority_id=?";
	list($prs,$err)=runIQuery($db,$sql,array("i",$priority));
	if (count($prs)>0) {
		$pdata=$prs[0];
		$priorityColor=$pdata['priority_color'];
		$priorityName=$pdata['priority_name'];
	}
	$customer_id=$data['customer_id'];
	if (! $customer_id) {
		$customer_id=0;
	}
	$sql="select * from customers where customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
	$cdata=$rs[0];
	$customer_name=$cdata['name'];
	$customer_address=$cdata['address'];
	$customer_address2=$cdata['address2'];
	$customer_city=$cdata['city'];
	$customer_state=$cdata['state'];
	$customer_zip=$cdata['zip'];
	$customer_phone=$cdata['phone'];
	$customer_email=$cdata['email'];
	$date_order=formatDateDBToWeb($data['date_order']);
	$date_due=formatDateDBToWeb($data['date_due']);
	if (! $date_due) {
		$date_due=Date("m/d/Y");
	}
	$status=$data['status'];
	$po_number=$data['po_number'];
	$attention=$data['attention'];
	$salesperson_id=$data['salesperson_id'];
	$notes_to_customer=$data['notes_to_customer'];
	$notes_to_self=$data['notes_to_self'];
	$email=$data['email'];
	$phone=$data['phone'];
	$ship_name=$data['ship_name'];
	$ship_address=$data['ship_address'];
	$ship_address2=$data['ship_address2'];
	$ship_city=$data['ship_city'];
	$ship_state=$data['ship_state'];
	$ship_zip=$data['ship_zip'];
	// add inactive customers code -Josh 02/20/2023
	$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
	list($crs,$err)=runIQuery($db,$sql,["i",$customer_id]);
	print renderSelect(TRUE,"customer_id",$customer_id,"Customer","N",$crs,true,"updateCustomer(this.value);this.style.backgroundColor='white';");
    if ($customer_id) {
		$sql="select name from customers where customer_id=$customer_id";
		$rs=mysqli_query($db,$sql);
		$data=mysqli_fetch_array($rs);
		$name=$data['name'];
	}
	$sql="select priority_id, priority_name from order_priorities order by priority_id ";
	$crs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"order_priority",$priority,"Priority","N",$crs,0,"updatePriority(this.value);");
	print "<span style='font-size: 20px; color: $priorityColor'>Priority: $priorityName</span>";
	print "<BR>";
	print "<div id='customer_info' style='width: 150px; background-color: white;'>";
	print $customer_address;
	print "<BR>";
	if ($customer_address2) {
		print $customer_address2;
		print "<BR>";
	}
	print "$customer_city, $customer_state $customer_zip";
	print "<BR>";
	print $customer_phone;
	print "<BR>";
	print "<a href='mailto:$customer_email'>$customer_email</a>";
	print "</div>";
	print renderTextBox(TRUE,"date_due",$date_due,"Date Due");
	print renderTextBox(TRUE,"po_number",$po_number,"PO#");
	$sql="select status_id, status_name from order_status order by status_name";
	$rs=mysqli_query($db,$sql);
	if ($status=="") {
		$status=1;
	}
	print renderSelect(TRUE,"status",$status,"Status","N",$rs,true);
	$sql="select salesperson_id, full_name from salespeople where inactive=0 order by last_name, first_name";
	$rs=mysqli_query($db,$sql);
	print renderSelect(TRUE,"salesperson_id",$salesperson_id,"Salesperson","N",$rs,true);
	print "<div style='clear: both;'></div>\n";
	print $attention;
	print "<br>";
	print $ship_name;
	print "<br>";
	print $ship_address;
	print "<br>";
	print "$ship_city, $ship_state $ship_zip<br>";
	print "<div style='clear: both;'></div>";
	print "$phone $email<br>";
	print "<div style='clear: both;'></div>\n";
	print "<table  class='table-bordered table-striped table-condensed flip-content'>\n<thead class='flip-content'>\n";
	print "<tr><th >Part</th><th>Rev</th><th >Description</th><th class='numeric'>Quantity</th></th><th class='numeric'>Price</th><th >PO Line</th><th>Due Date</th><th>Powder</th><th>Extended</th><th>WO</th></tr></thead><tbody id='orderLineList'>\n";
	$i=0;
	$toggle=1;
	$sql="select * from order_lines where order_id=$id order by coalesce(po_line,0) * 1, line_id ";
	$pitext="";
	$rs=mysqli_query($db,$sql);
	while ($ldata=mysqli_fetch_array($rs)) {
		print "<tr>";
		$line_id=$ldata['line_id'];
		$pol=$ldata['po_line'];
		$item=$ldata['item_id'];
		$desc=$ldata['item_description'];
		$qty=$ldata['quantity'];
		$price=$ldata['price'];
		$rev=$ldata['revision'];
		$sq=$ldata['shipped_quantity'];
		$powder=$ldata['powder_color'];
		$due=formatDateDBToWeb($ldata['due_date']);
		$ext=number_format($qty*$price,2);
		print "<td ><input type='hidden' name='ol$i' id='ol$i' value='$line_id'>$item</td>";
		print "<td>$rev</td>";
		print "<td>$desc</td>";
		print "<td class='numeric' valign='top'>$qty</td>";
		print "<td class='numeric' valign='top'>$price</td>";
		print "<td>$pol</td>";
		print "<td>$due</td>";
		print "<td><select name='powder$i' id='powder$i'>";
		print "<option value='0'>No Powder</option>";
		$sql="select vc_id, color_code, vendor_name from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by color_code, vendor_name";
		list($crs,$err)=runIQuery($db,$sql);
		foreach ($crs as $cdata) {
			$c=$cdata['color_code'];
			$vc=$cdata['vc_id'];
			$v=$cdata['vendor_name'];
			print "<option value ='$vc' ";
			if ($vc == $powder) {
				print " selected ";
			}
			print ">$c - $v</option>";
		}
		print "</select>";
		print "</td>";
		print "<td class='numeric' valign='top'>$ext</td>";
		print "<td valign='top' align='center'>";
		$sql="select * from jobs where line_id=$line_id";
		$jrs=mysqli_query($db,$sql);
		$job=0;
		$joblist=array();
		while ($jdata=mysqli_fetch_array($jrs)) {
			if ($job) {
				print "<BR>";
			}
			$job=$jdata['job_id'];
			$joblist[]=$job;
			print "&nbsp;<a href='editJob.php?id=$job' target='_blank' style='font-weight: bold; background-color: white;'>$job</a>&nbsp;";
		}
		if (count($joblist)>0) {
			$sql="select job_id from jobs_orders where order_line=? and job_id not in (" . implode(",",$joblist) . ")   order by job_id";
		} else {
			$sql="select job_id from jobs_orders where order_line=?  order by job_id";
		}
		list($jrs,$err)=runIQuery($db,$sql,array("i",$line_id));
		foreach ($jrs as $jdata) {
			$job=$jdata['job_id'];
			print "&nbsp;<a href='editJob.php?id=$job' target='_blank' style='font-weight: bold; background-color: white;'>$job</a>&nbsp;";
		}
		print "</td>";
		print "<td align='center'>";
		print "</td>";
		print "</tr>\n";
		$i++;
		$current=$i;
		print "</tbody>";
		print "<tfoot>";
		print "<tr><td class='numeric'>Total: </td><td colspan='6'></td>";
		print "<td class='numeric'><input type=text id='otot' readonly style='border: 0px; width: 60px; text-align: right;  background-color: white;' value=''></td></tr>\n";
	} ## end while getting data
	print "</tfoot>";
	print "</table>\n";
	print "<div class='span8 '>\n";
	print nl2br($notes_to_customer);
	print "</div>\n";
	print "<div class='span8 '>\n";
	print nl2br($notes_to_self);
	print "</div>";
include('footer.php');
