<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
date_default_timezone_set("America/Detroit");
$bol=$_GET['bol'];
$pageTitle="BOL $bol";
include('dbConnection.php');
include('functions.php');
include('security.php');
print "<!doctype HTML>";
print "<html>";
print "<head>";
print "</head>";
function generateHeader($db,$bol,$pageno) {
	$retval="";
	$retval.="<table align='center' style='width: 800px; '>";
	$retval.="<tr><td colspan='2' align='center' style='border-top: 1px solid black;'>BILL OF LADING <div style='float: right;'>Page $pageno of <span class='totpage'>1</span></div></td></tr>";
	$retval.="\n";
	$retval.="<tr><td style='width: 50%' valign='top'>";
	$sql="select * from active_bol where bol_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$bol));
	$data=$rs[0];
	$bolNumber=$data['bol_id'];
	$trailer=$data['trailer_number'];
	$carrier=$data['carrier_id'];
	$sql="select carrier_name from carriers where carrier_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$carrier));
	$carrier=$rs[0][0];
	$instructions=nl2br($data['special_instructions']);
	$retval.="<table style='width: 100%' ><tr><td align='center' style='border-top: 1px solid black;'>SHIP FROM</td></tr>";
	$retval.="<tr><td>Preferred Machine</td></tr>";
	$retval.="<tr><td>6673 Pine Ridge Court SW Suite C</td></tr>";
	$retval.="<tr><td>Jenison, MI 49428 USA</td></tr>";
	$retval.="<tr><td>SID# 26-4042941</td></tr>";
	$retval.="<tr><td>&nbsp;</td></tr>";
	$retval.="\n";
	$retval.="<tr><td align='center' style='border-top: 1px solid black;'>SHIP TO</td></tr>";
	$sql="select distinct customer_id, ship_name, ship_address, ship_address2, ship_city, ship_state, ship_zip from packing_slip, active_bol_skids, skids 
	where active_bol_skids.bol_id=? and active_bol_skids.skid_id=skids.skid_id and skids.packing_slip_id=packing_slip.packing_slip_id ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$bol));
	if (count($rs) > 1) {
		$name="Preferred Machine ";
		$address="On behalf of:";
		$address2="See Packing Slips";
		$csz="";		
	} else {
		$data=$rs[0];
		$name=$data['ship_name'];
		$address=$data['ship_address'];
		$address2=$data['ship_address2'];
		$csz=$data['ship_city'] . ", " . $data['ship_state'] . " " . $data['ship_zip'] . " USA";
	}
	$retval.="<tr><td>$name</td></tr>";
	$retval.="<tr><td>$address</td></tr>";
	if ($address2) {
		$retval.="<tr><td>$address2</td></tr>";
	}
	$retval.="<tr><td>$csz</td></tr>";
	$retval.="<tr><td>CID#</td></tr>";
	$retval.="<tr><td>&nbsp;</td></tr>";
	$retval.="<tr><td align='center' style='border-top: 1px solid black;'>SPECIAL INSTRUCTION</td></tr>";
	$retval.="<tr><td>$instructions</td></tr>";	
	$retval.="</table>";
	$retval.="\n";
	$retval.="</td>";
	$retval.="\n";
	$retval.="<td style='width: 50%; border-bottom: 1px solid black;' valign='top' >";
	$retval.="<table><tr><td>Bill of Lading Number</td><td>$bol</td></tr>";
	$retval.="<tr><td>&nbsp;</td></tr>";
	$retval.="<tr><td>Carrier Name</td><td>$carrier</td></tr>";
	if ($data['customer_id'] == 715) {
		$retval.="<tr><td>Freight Charge Terms:</td><td>Third Party</td></tr>";
	} else {
		$retval.="<tr><td>Freight Charge Terms:</td><td>FOB Origin</td></tr>";		
	}
	$retval.="<tr><td>Trailer Number</td><td>$trailer</td></tr>";
	$retval.="<tr><td>Seal Number(s)</td><td>____________________</td></tr>";
	$retval.="</table>";
	$retval.="\n";
	if ($data['customer_id'] == 693) {
		$retval.="<table><tr>";
		$retval.="<td align='center' style='border-top: 1px solid black;'>THIRD PARTY FREIGHT BILL TO</td></tr>";
		$retval.="<tr><td>DEMATIC</td></tr>";
		$retval.="<tr><td>Dematic - Third Party Bill </td></tr>";
		$retval.="<tr><td>507 Plymouth Ave NE</td></tr>";
		$retval.="<tr><td>Grand Rapids, MI 49505 USA</td></tr>";
		$retval.="<tr><td>&nbsp;</td></tr>";
		$retval.="</table>";
	}
	$retval.="</td>";
	$retval.="</tr>";
	$retval.="\n";
	$retval.="<tr><td colspan='2' align='center' style='border-top: 1px solid black;' >CUSTOMER ORDER AND CARRIER INFORMATION</td></tr>";
	$retval.="<tr>";
	$retval.="<td colspan='2' align='center' style='border-top: 1px solid black;'>";
	$retval.="<table width='800'><tr><td style='border-left: 1px solid black; border-right: 1px solid black; border-bottom: 1px solid black;'>CUSTOMER ORDER NUMBER</td>";
	$retval.="<td style='border-right: 1px solid black; border-bottom: 1px solid black;'>PACKING SLIP</td>";
	$retval.="<td style='border-right: 1px solid black; border-bottom: 1px solid black;'># Packages</td><td style='border-right: 1px solid black;'>WEIGHT";
	$retval.="</td><td style='border-right: 1px solid black; border-bottom: 1px solid black;'>PALLET</td><td style='border-right: 1px solid black; border-bottom: 1px solid black;'>Commodity Description</td></tr>";
	$retval.="\n";
	return $retval;
}
function generateFooter($bol) {
	global $db;
	include('s3.php');
	$retval="";
	$retval.="</table></td></tr>"; 			
	$retval.="<tr><td colspan='2' style='border-top: 1px solid black;'>";
	$retval.="<br>";
	$s3client->registerStreamWrapper();
	$file="signature-BOL$bol.png";
	$retval.="<br>";
	if (file_exists("s3://$bucket/$file")) {
		$retval.="<img src='showDBImagePNG.php?file=$file' height='100'>&nbsp;<b>Shipper Signature</b>";
	} else {
		$retval.="______________________________ <b>Shipper Signature</b>";
	}
	$retval.="<br>";
	$retval.="SHIPPER SIGNATURE/DATE";
	$retval.="<div style='font-size: 8px;'>";
	$retval.="This is to certify that the aboved name materials are properly classified, packaged, marked and tagged, and are in proper condition for transportation according to the applicable regulations of the DOT";
	$retval.="</div>";
	$retval.="</td></tr>";
	$retval.="</table>";
	return $retval;
}
print "<body style='font-size: 13px;'>\n";
$totpages=0;
$lc=99;
$sql="select packing_slip_id, sum(weight) as totweight, count(*) as totskids from active_bol_skids, skids where bol_id = ? 
	and active_bol_skids.skid_id=skids.skid_id group by packing_slip_id order by packing_slip_id  ";
list($rs,$err)=runIQuery($db,$sql,array("i",$bol));
$totweight=0;
$totpackages=0;
foreach ($rs as $data) {
	$packslip=$data['packing_slip_id'];
	$sql="select po_id from packing_slip_lines where packing_list_id = ? ";
	list($prs,$perr)=runIQuery($db,$sql,array("i",$packslip));
	$pdata=$prs[0];
	$poNumber=$pdata['po_id'];
	$pkg=$data['totskids'];
	$wgt=$data['totweight'];
	$totweight+=$wgt;
	$totpackages+=$pkg;
	$lc++;
	if ($lc > 19) {
		$lc=0;
		$totpages++;
		if ($totpages > 1) {
			print generateFooter($bol);
			print "<div style='page-break-after: always;'>&nbsp;</div>";
		}
		print generateHeader($db,$bol,$totpages);		
	}
	print "<tr><td style='border-left: 1px solid black; border-right: 1px solid black;'>$poNumber</td>";
	print "<td style='border-right: 1px solid black;'>$packslip</td>";
	print "<td align='right' style='border-right: 1px solid black;'>$pkg</td>";
	print "<td align='right' style='border-right: 1px solid black;'>";
	print number_format($wgt,2);
	print "</td>";
	print "<td style='border-right: 1px solid black;'>Pallet</td><td style='border-right: 1px solid black;'>Manufactured Parts</td></tr>";
}
print "<tr><td></td><td></td><td align='right'  style='border-right: 1px solid black;'>";
print number_format($totpackages,0);
print "</td><td align='right'  style='border-right: 1px solid black;'>";
print number_format($totweight,2);
print "</td></tr>";
print generateFooter($bol);
print "<table style='width: 800px;' align='center'>";
print "<tr>";
print "<tr><td valign='top' style='border-top: 1px solid black;'>";
print "<div style='font-size: 8px;'>";
print "Where the rate is dependent on value shippers are required to state specifically in writing the agreed value or declared value as follows:<br>";
print "The agreed or declared value of this property is specifically stated by the shipper to be not exceeding<br>";
print "<br>";
print "___________________________ per ______________________";
print "</div>";
print "</td><td colspan='2' style='border-top: 1px solid black;'>";
print "</td>";
print "</tr>";
print "<tr><td colspan='2' style='font-size: 12px; border-top: 1px solid black;'>";
print "NOTE Liability Limitation for loss or damage in this shipment is applicable - See U.S.C. 14706(c)(1)(A) and (B)";
print "</td></tr>";
print "<tr><td valign='top' style='border-top: 1px solid black;'>";
print "<div style='font-size: 10px;'>";
print "RECEIVED. Subject to individually determined rates or contracts that have been agreed upon in writing between the carrier and shipper if applicable, otherwise to the rates, classifications, and rules that have been established by the carrier and area avialable to the shipper, on request. The shipper hereby certifies that he/she is familiar with all the terms and conditions of the NMFC Uniform Straight Bill of Lading, and the said terms and conditions are there by agreed gy the shipper and accepted for him/herself and his/her assigns.  ";
print "</div>";
print "</td><td  valign='top' style='border-top: 1px solid black;'>";
print "The carrier shall not make delivery of this shipment without payment of freight and all other lawful charges.";
print "<br><BR>";
print "<tr><td colspan='2' style='border-top: 1px solid black;'>";
print "<table><tr>";
print "<td valign='top'>";
print "</td>";
print "<td valign='top' style='width: 40%'>";
print "<table style='font-size: 10px;'><tr><td>TRAILER LOADED</td><TD>FREIGHT COUNTED</TD></TR>";
PRINT "<TR><TD>[ ] by Shipper</td><td>[ ] by Shipper";
print "</td></tr>";
PRINT "<TR><TD>[ ] by Driver</td><td>[ ] by Driver Pallets said to contain";
print "</td></tr>";
PRINT "<TR><TD></td><td>[ ] by Driver";
print "</td></tr>";
print "</table>";
print "</td>";
print "<td valign='top'>";
print "CARRIER SIGNATURE/PICKUP DATE";
print "<div style='font-size: 8px;'>";
print "Carrier acknowledges receipt of packages and required placards. Carrier certifies emergency response information was made available and/or carrier has the DOT emergency response guidebook or equivalent documentation in the vehicle.";
print "</div>";
print "</td></tr>";
print "</table>";
print "</td></tr>";
print "</table>";

?>
<script>
var x=document.getElementsByClassName('totpage');
var i; for (i = 0; i < x.length; i++) { x[i].innerHTML='<?=$totpages?>'; }
function signBOL() {
	url='signature.php?type=BOL&id=<?=$bol?>';
	window.open(url,'_blank');
}
<?php
print "\n</script>";
print "</body></html>";
?>