<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$vendor=2172;
if (isset($_POST['vendor'])) {
    $vendor=$_POST['vendor'];
}

print renderPanel("Vendor Orders","","red");
print "<p>This report will show you all POs that are Open, Sent to Vendor, or Partially Received</p>";
print "<form name='listform' method='POST' action='vendorOrders.php'>\n";
$sql="select vendor_id, vendor_name from vendors order by vendor_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"vendor",$vendor,"Vendor","N",$rs);
print "<table class='table-bordered table-striped ' id='openPOList'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "PO#";
print "</th>";
print "<th valign='top'>";
print "Job#";
print "</th>";
print "<th valign='top'>";
print "Reference";
print "</th>";
print "<th valign='top'>";
print "Date SO Due";
print "</th>";
print "<th valign='top'>";
print "Dollar Value";
print "</th>";
print "</tr>\n";
print "</thead><tbody>";
$holdMonth="00";
$mtotal=0;
$sql="select o.po_id, reference, j.job_id, ol.due_date, (l.quantity - l.quantity_received) * l.price as total  from purchase_orders o inner join po_lines l on o.po_id=l.po_id inner join jobs j on l.job_id=j.job_id inner join order_lines ol on j.line_id=ol.line_id   where o.status in (1,3,5) and o.who > 0 and vendor_id=?  order by ol.due_date ";
$exportsql=renderQuery($sql,array("i",$vendor));
list($rs,$err)=runIQuery($db,$sql,array("i",$vendor));
foreach ($rs as $data)  {
	$po=$data['po_id'];
    $dt=$data['due_date'];
    $reference=$data['reference'];
    $total=$data['total'];
    $job=$data['job_id'];
    $month=date_format(new DateTime($dt),"m");
    if ($month <> $holdMonth) {
        if ($holdMonth <> "00") {
                print "<td colspan='3'></td>";
                print "<td>$holdMonth Total";
                print "</td>";
                print "<td>";
                print number_format($mtotal,2);
                print "</td>";
                print "</tr>";
        }
        $holdMonth=$month;
        $mtotal=0;
    }
    $mtotal+=$total;
	print "<tr>";
	print "<td valign='top'><a href='editPO.php?openpo=1&table=purchase_orders&key=po_number&id=$po' target='_blank'>";
	print $po;
    print "</a></td>";
    print "<td valign='top'>";
    print $job;
	print "</td>";
    print "<td valign='top'>";
    print $reference;
	print "</td>";
    print "<td valign='top'>";
    print formatDateDBToWeb($dt);
	print "</td>";
    print "<td valign='top'>";
    print number_format($total,2);
	print "</td>";
	print "</tr>\n";
}
if ($holdMonth <> "00") {
    print "<td colspan='3'></td>";
    print "<td>$holdMonth Total";
    print "</td>";
    print "<td>";
    print number_format($mtotal,2);
    print "</td>";
    print "</tr>";
}
print "</tbody></table>";
print renderClosePanel();
include('footer.php');
