<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$start="01/01/" . Date("Y");
$end="12/31/" . Date("Y");
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
}
$vendor=0;
if (isset($_GET['vendor'])) {
	$vendor=$_GET['vendor'];
}
print renderPanel("Vendor On Time Delivery","","red","span11","star");
print "<form name='findform' action='vendorDelivery.php' method='GET'>";
print renderDateBox(TRUE,"start",$start,"Start PO Date");
print renderDateBox(TRUE,"end",$end,"End PO Date");
$sql="select vendor_id, vendor_name from vendors order by vendor_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"vendor",$vendor,"Vendor","N",$rs,0);
print renderButton("Find","green","document.findform.submit();");
print renderButton("Export","blue","document.findform.action='exportVendorDelivery.php';document.findform.target='_blank';document.findform.submit();document.findform.action='vendorDelivery.php';document.findform.target='_self';");
print "</form>";
$st=formatDateWebtoDB($start);
$et=formatDateWebtoDB($end);
$sql="select distinct o.po_id, coalesce(email_date, po_date) as date_sent, r.date_received, v.lead_time, l.date_expected from purchase_orders o left outer join email_log on document_number=po_id and email_type='PO' ";
$sql.=" inner join po_lines l on o.po_id=l.po_id left outer join receipt_lines rl on l.line_id=rl.line_id left outer join receipts r on rl.receipt_id=r.receipt_id ";
$sql.=" inner join vendors v on o.vendor_id=v.vendor_id  ";
$sql.=" WHERE  po_date >= ? and po_date <= ? ";
$sql.=" and o.vendor_id=? ";
list($rs,$err)=runIQuery($db,$sql,array("ssi",$st,$et,$vendor));
print "<table class='table table-striped'>";
print "<thead>";
print "<th>PO#</th>";
print "<th>Date Sent</th>";
print "<th>Date Received</th>";
print "<th>Date Due</th>";
print "<th>Lead Time</th>";
print "<th>Late?</th>";
print "</tr>";
print "</thead>";
print "<tbody>";
$totc=0;
$totlate=0;
foreach ($rs as $data) {
    $totc++;
    $po=$data['po_id'];
    $dtsent=$data['date_sent'];
    $dtr=$data['date_received'];
    if (strstr($dtr," ")) {
        list($dtr,$time)=explode(" ",$dtr);
    }
    $lead=$data['lead_time'];
    $due=$data['date_expected'];
    $dtck=AddBusinessDays($dtsent,$lead);
    $late="";
    if ($dtr) {
        if ($dtck < $dtr) {
            if ($due < $dtr) {
                $late="YES";
                $totlate++;
            }
        }
    } else {
        if ($dtck < Date("Y-m-d")) {
            if ($due < Date("Y-m-d")) {
                $late="YES";
                $totlate++;
            }
        }
    }
	print "<tr>";
	print "<td>";
	print $po;
	print "</td>";
	print "<td>";
	print formatDateDBToWeb($dtsent);
	print "</td>";
	print "<td>";
	print formatDateDBToWeb($dtr);
	print "</td>";
    print "<td>";
    print formatDateDBToWeb($due);
    print "</td>";
	print "<td>";
	print $lead;
	print "</td>";
	print "<td>";
    print $late;
	print "</td>";
	print "</tr>";
}
print "</tbody>";
print "</table>";
if ($totc > 0) {
    $pct=$totlate/$totc * 100;
    $pct=round($pct,1);
    print "<center>";
    print "Total POs: $totc, Total Late: $totlate, Pct: $pct%";
    print "</center>";
}
print renderClosePanel();
?>
<script>
function page_init() {
	$('.datepicker').datepicker();
}
</script>
<?php
include('footer.php');
?>