<?php 
// Main ticketing functions included in core files.
#ini_set('display_errors', 1);
#ini_set('display_startup_errors', 1);
#error_reporting(E_ALL);
// include('vendor/autoload.php');
include_once('vendor/autoload.php');
// include('security.php');
// include('functions.php');
 //var_dump($_SESSION);
if(isset($_POST)){
    if(isset($_POST['function']) && $_POST['function']=='setSessionForNewSalesOrderAssociation'){

        setSessionForNewSalesOrderAssociation($_POST['conversation']);
    }
    elseif (isset($_POST['useFunction']) && $_POST['useFunction']=='linkOrderToEmailRequest'){
        linkOrderToEmailRequest($_POST['conversationID'],$_POST['orderID'],$_POST['user'],$_POST['database']);
    }}

// possible external function for future - not currently in use
function createQuote($data){

}

// links sales order to quote requests
function linkOrderToEmailRequest($conversationID,$orderID,$user,$db){
    $sql = "INSERT INTO quotes_have_requests (order_id,conversation_id,user_id,created_at) VALUES (?,?,?,now())";
    $inserted = list($rs,$err)=runIQuery($db,$sql,array("i",$convsersationID,$orderID,$user));
    if($inserted){
        echo json_encode(array('success'=>'true','response'=>$inserted));
        exit();
    }
    else{
        echo json_encode(array('success'=>'false','response'=>$inserted));
        exit();
    }
}

//gets tagged sales orders from wst added table "quotes_have_requests"
function getAttachedSalesOrders($convsersationID,$db){
    $sql = "SELECT * FROM quotes_have_requests WHERE conversation_id =?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$convsersationID));
    if(count($rs)>0){
        // var_dump($rs);
        return $rs;
    }
}


//gets all quotes 
function readQuotes($convsersationID=FALSE,$employeeId=False,$customerId=False,$statusId=False)
{
    
   
if ($convsersationID !=False)
    {
       
        return _getSingleConverstaion($convsersationID);
       
    }
    else 
    {
        if($employeeId!=False || $customerId!=False || $statusId!=False)
        {
            $query = array();
            $query['embed'] = 'tags';
            if($employeeId != False){

                $query['assignedTo'] = $employeeId;
            }
            if($customerId !=False){
                $query['customerEmail'] = $customerId;
            }
            if($statusId != False){
                $query['status'] = $statusId;
            }
        }
      
        if(isset($query)){
            return _getConversations($query);
        }
        else{
            return _getConversations();
        }
        
    }

}

//not in use - currently using reply function and add tags - but you could update other data about the ticket here in the future (subject, etc)
function update($ticketId,$data){

}

//not in use currently using "closed" status but here you could add a delete function to completely remove 
function destroy($ticketId){

}

// helper function to get conversations with query as an optional param
function _getConversations($query=False){
    $client = new \GuzzleHttp\Client();
    
    if($query!=False)
    {
        $response = $client->get("https://worldsourcedev.com/freescout/api/conversations", [
            'headers' => [
                    "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
            ],
            'query' => $query
        ]);
        // $body = $response->getBody();
        // return json_decode((string) $body);
    }
    else 
    {
        $response = $client->get("https://worldsourcedev.com/freescout/api/conversations", [
            'headers' => [
                    "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
            ]
        ]);
    }

    $body = $response->getBody();
    $responseCode = $response->getStatusCode();
    if($responseCode >=200 && $responseCode <400)
    {
        return json_decode((string) $body); 
    }
    else 
    {
        //From time to time the google mailbox needs to have a new application password created and input into freescout 
        echo "There was an error fetching quote requests, you may need to re-authorize the Google mailbox, please contact help@projects.worldsourcetech.com for assistance.";
    }

       
}

//session helpers
function setSessionForNewSalesOrderAssociation($id)
{
        $_SESSION['newSalesOrderFromTicket'] = $id;
        echo json_encode(array('success'=>'true','conversation_id'=>$_SESSION['newSalesOrderFromTicket']));
        exit();
}       

function setSessionForExistingSalesOrderAssociation($id)
{
    $_SESSION['existingSalesOrderFromTicket'] = $id;    
}


function assoicateSalesOrderWithTicket($salesOrderID,$ticketID,$userID){
        //called from updateOrder.php or from quoteRequests page if tagging a request to an existing quote.
        //insert into salesOrdersHaveRequests
        //unset any session vars
       
            $quoteAssnSQL = "INSERT INTO quotes_have_requests (order_id,conversation_id,user_id,created_at)";
            $quoteAssnSQL.= " VALUES (?,?,now())";
			list($results,$err)=runIQuery($db,$quoteAssnSQL,array("iii",$salesOrderID,ticketID));
            
            if(!$err){
               
                return true;
            }
            else {
                
                return $err;
            }
}

// function getSalesOrderReplyStats($salesOrderID){

// }

// function _replyConvsersation($id,$data){
//      //getAPIKey

// }

function getCustomers($db){

    $sql = "SELECT * FROM customers";
    list($results,$err)=runIQuery($db,$sql);
    if(count($results) >0){
        return $results;
    }
    else{
        echo "Error getting customers";
    }
}

function getEmployees($db){
    $sql = "SELECT site_admins.user_id, site_admins.email, salespeople.email, salespeople.full_name FROM site_admins
    LEFT JOIN salespeople on convert(site_admins.email using latin1) collate latin1_general_ci = salespeople.email 
    WHERE salespeople.email IS NOT NULL";
	// cma 11/22/2022 added only active
	$sql.=" and coalesce(inactive,0) = 0 ";
    list($results,$err)=runIQuery($db,$sql);
    if(count($results) >0){
        return $results;
    }
    else {
        echo "Error getting customers";
    }
}

function _getSingleConverstaion($convsersationID){


    $client = new \GuzzleHttp\Client();
$response = $client->get("https://worldsourcedev.com/freescout/api/conversations/".$convsersationID, [
    'headers' => [
            "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
        ],
    'query' => [
            "embed" => "threads,tags",
        ],
]);
    $body = $response->getBody();
    $decoded = json_decode((string) $body);

    $responseCode = $response->getStatusCode();
    $responsePhrase = $response->getReasonPhrase();

    $responseDecoded=json_decode($body);
    if($responseCode >=200 && $responseCode <400)
    {
        return $decoded;
        // echo json_encode(array('success'=>'true','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$newStatus,'closedRecorded'=>$closedRecorded));
    }
    else 
    {
        echo json_encode(array('success'=>'false','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$newStatus,'closedRecorded'=>$closedRecorded)); 
    }
}

function updateStatusOnly($conversationId,$status,$switch,$ticketingUser)
{

    if($switch === 'true'){
        if($status =='active'){
            $newStatus = 'pending';
        }
        elseif($status=='pending'){
            $newStatus ='active';
        }
        else {
            $newStatus = $status;
        }
    }
    else {
        $newStatus = $status;
    }

    $client = new \GuzzleHttp\Client();
    $response = $client->put("https://worldsourcedev.com/freescout/api/conversations/".$conversationId, [
        'headers' => [
                "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
                "Content-Type" => "application/json",
            ],
            'json' => [
                "byUser" => $ticketingUser,
                    "status" => $newStatus,        
            ],
    ]);
    $body = $response->getBody();
    
    $responseCode = $response->getStatusCode();
    $responsePhrase = $response->getReasonPhrase();
    
    $responseDecoded=json_decode($body);
    if($responseCode >=200 && $responseCode <400)
    {
        if($newStatus =='closed'){
            $tags = array (
                0 => 'closedbypreferred'
            );
            updateTag($conversation,$newStatus,$status,$tags);
        }
        // echo json_encode(array('success'=>'true','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$newStatus,'closedRecorded'=>$closedRecorded));
    }
    else 
    {
        $tags = array ();
        updateTag($conversation,$newStatus,$status,$tags);
        // echo json_encode(array('success'=>'false','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$newStatus,'closedRecorded'=>$closedRecorded)); 
    }
}

function updateTag($convsersationID,$newStatus,$status,$tags)
{

    $client = new \GuzzleHttp\Client();
    $response = $client->put("https://worldsourcedev.com/freescout/api/conversations/".$convsersationID."/tags", [
        'headers' => [
                "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
                "Content-Type" => "application/json",
            ],
        'json' => [
                    "tags" => $tags,
                ],
    ]);
    $body = $response->getBody();
    $decoded = json_decode((string) $body);

    $responseCode = $response->getStatusCode();
    $responsePhrase = $response->getReasonPhrase();
    
    $responseDecoded=json_decode($body);

    if($responseCode >=200 && $responseCode <400)
    {
       
            echo json_encode(array('success'=>'true','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$status,'newStatusVal'=>$newStatus,'closedTagAdded'=>'true'));
        
    }
    else 
    {
        echo json_encode(array('success'=>'false','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$status,'newStatusVal'=>$newStatus)); 
    }
    
}


?>