<?php 
// ### WST Quoting Module - update only the status of a ticket. 
//*** REQUIRED POST VALUES: 'conversation' for the conversation id to be updated, 'newStatus' for the status you would like to update to, and 'switch' which should be set to 'true' unless the values have already been reversed on the front end because this client has reversed the usual definitions of pending vs active.


// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
session_start();
include('../../../autoload.php');
include('../../../../dbConnection.php');
include('../../../../functions.php');
// include('../../../../security.php');
$convsersationID = $_POST['conversation'];
$status = $_POST['newStatus'];
$user = $_POST['user'];
// should we reverse pending and active here - 'true' for yes, 'false' for no (already done on front end, see below)
$switch = $_POST['switch'];

// Please note client wanted to change active/pending conventions - this is already done in many of the select drop downs (value of pending with text of Active)
// However, for raw api calls you should set swtich to 'true' (in quotes as text string) and this will take care of making the change to the correct status in the ticketing system.
// var_dump($db);
$closedRecoreded = 'NA';
if($switch === 'true'){

    if($status =='active'){
        $newStatus = 'pending';
    }
    elseif($status=='pending'){
        $newStatus ='active';
    }
    else {
        $newStatus = $status;
    }
    updateStatus($user,$convsersationID,$newStatus,$status);
}
else {
    $newStatus = $status;
    updateStatus($user,$convsersationID,$newStatus,$status);
    // if($newStatus == 'closed'){
        // $sql = "INSERT INTO previously_closed_quote_requests (conversation_id,created_at) VALUES (?,now())";
        // $inserted = list($rs,$err)=runIQuery($db,$sql,array("i",$convsersationID));
        // if($inserted){
           
        //     $closedRecorded = 'true';
        //     sendRequest($user,$convsersationID,$newStatus);
        //     }
        // }
        // else{
           
        //     $closedRecoreded = 'false';
        //     sendRequest($user,$convsersationID,$newStatus);
        // }
    // }
    }

function updateStatus($user,$convsersationID,$newStatus,$status)
{
    $client = new \GuzzleHttp\Client();
    $response = $client->put("https://worldsourcedev.com/freescout/api/conversations/".$convsersationID, [
        'headers' => [
                "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
                "Content-Type" => "application/json",
            ],
        'json' => [
                    "byUser" => $user,
                        "status" => $newStatus,
                ],
    ]);
    $body = $response->getBody();
 
    $decoded = json_decode((string) $body);

    $responseCode = $response->getStatusCode();
    $responsePhrase = $response->getReasonPhrase();
    
    $responseDecoded=json_decode($body);
    if($responseCode >=200 && $responseCode <400)
    {
        if($newStatus =='closed'){
            $tags = array (
                0 => 'closedbypreferred'
            );
            updateTag($convsersationID,$newStatus,$status,$tags);
        }
        else {
            //remove any other tags for now since we are only using one tag to deterimin if previously closed.
            $tags = array ();
            updateTag($convsersationID,$newStatus,$status,$tags);
            // echo json_encode(array('success'=>'true','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$status,'newStatusVal'=>$newStatus));
        }
        
    }
    else 
    {
        echo json_encode(array('success'=>'false','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$status,'newStatusVal'=>$newStatus)); 
    }
}

function updateTag($convsersationID,$newStatus,$status,$tags)
{

    $client = new \GuzzleHttp\Client();
    $response = $client->put("https://worldsourcedev.com/freescout/api/conversations/".$convsersationID."/tags", [
        'headers' => [
                "X-FreeScout-API-Key" => "cf086d817babd70ee2b4991cf26f0877",
                "Content-Type" => "application/json",
            ],
        'json' => [
                    "tags" => $tags,
                ],
    ]);
    $body = $response->getBody();
    $decoded = json_decode((string) $body);

    $responseCode = $response->getStatusCode();
    $responsePhrase = $response->getReasonPhrase();
    
    $responseDecoded=json_decode($body);

    if($responseCode >=200 && $responseCode <400)
    {
       
            echo json_encode(array('success'=>'true','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$status,'newStatusVal'=>$newStatus,'closedTagAdded'=>'true'));
        
    }
    else 
    {
        echo json_encode(array('success'=>'false','response'=>$responseCode,'file'=>'updateConvsersationStatus.php','tried_toChangeto'=>$status,'newStatusVal'=>$newStatus)); 
    }
}

?>