<?php 
//### WST Quoting Module - get the fastest user to quote (and slowest)

// error_reporting(E_ALL);
// ini_set('display_errors','on');

include('../../../../../dbConnection.php');
include('../../../../../functions.php');
include('../../../../../security.php');
include('../../soQuoteTicketing.php');
include('../getOrCreateTicketEmployee.php');

$averages = array();
$count = 0;

//GET USERS that have sent quotes related to email requests to quote@preferredmacinellc.com 
$sql = "SELECT activity, activity_id, who, order_activity.order_id,activity_date, conversation_id FROM order_activity
LEFT JOIN quotes_have_requests on order_activity.order_id = quotes_have_requests.order_id WHERE
order_activity.activity = 'SENT' AND conversation_id IS NOT NULL";
list($rs,$err)=runIQuery($db,$sql);

if(!$err)
{
    foreach ($rs as $resultKey =>$resultItem)
    {
        $who = $resultItem['who'];
        $readQuote = readQuotes($resultItem['conversation_id']);
        
            $thisTime=$readQuote->createdAt;
            // echo "  User: ".$who;
            // echo "  Quote Created At: ".$thisTime;
            // echo "  Quote Sent: ".$resultItem['activity_date'];
    
            $now = date("Y-m-d H:i:s");
            $date1 = strtotime($thisTime);
            $date2 = strtotime($resultItem['activity_date']);


            // Formulate the Difference between two dates
            $diff = abs($date2 - $date1);

            // echo "  Time Elapsed: ". $diff;

            // echo "<br><br>";
           
            if (array_key_exists($who, $averages)) {
                $count+=1;

                $runningTotal = $averages[$who]['total']+=diff;
                // echo "count number: ".$count;
                // echo "<br>";
                // echo "Running Total: ".$runningTotal;
                // echo "<br>";
            
                $runningAverage = $runningTotal / $count;
                // echo "Running Average: ".$runningAverage;
                // echo "<br><br>";
                $averages[$who]['total'] = $runningTotal;
                $averages[$who]['runningAverage'] = $runningAverage;
            }
            else {
                $count = 1;
                $averages[$who]['total'] = $diff;
                $averages[$who]['runningAverage'] = $diff/$count;
            }
    }

array_multisort($averages, SORT_DESC,SORT_NUMERIC);
// var_dump($averages);
// echo "<br><br>";
// arsort($averages);

echo json_encode(array('success'=>'true','results'=>array('fastest'=>array_key_last($averages),'slowest'=>array_key_first($averages),'full_array'=>$averages)));
exit();

}
    
else 
{
    echo json_encode(array('success'=>'false','message'=>'There was an error: '.$err));
    exit();
}
    


//for each user get quotes
//with response of quotes get each createdAt 
//with each quote check for corrosponding sent
//if sent date exists calc difference with that date
// else calc difference between createdAt and Today
// array_merge($user['email]=>$difference,$timeDifferences);

//arsort the array
//who ever is on top is the fastest


?>
