<?php 
//WST Quoting Module - reporting - fastest users to send quotes (from time of initial request)

error_reporting(E_ALL);
ini_set('display_errors','on');
require_once('../../../../autoload.php');
include('../../../../../dbConnection.php');
include('../../../../../functions.php');
// include('../../../../../security.php');
include('../../soQuoteTicketing.php');



$sentTimingOrders = [];

    // $sql = "SELECT activity, who, order_activity.order_id, conversation_id FROM order_activity
    // LEFT JOIN quotes_have_requests on order_activity.order_id = quotes_have_requests.order_id WHERE
    // order_activity.activity = 'SENT' AND conversation_id IS NOT NULL";

    // for more accuracy over time we need to keep the date that the sales order was approved - right now when a sales 
    // order moves from status to status in the order_status_update table we are only tracking it while it is in that new status
    // adding a date_approved field that would be static once an order wend from quote to whatever status means approved would make this metric more accurate.
    $sql = "SELECT old_status, new_status, date_changed, conversation_id FROM order_status_update
    LEFT JOIN quotes_have_requests on order_status_update.order_id = quotes_have_requests.order_id 
    WHERE new_status = 1 AND conversation_id IS NOT NULL";
    list($rs,$err)=runIQuery($db,$sql);
    if(!$err){
        foreach ($rs as $resultKey =>$resultItem){
            //each item that has been sent that is attached to an rfq
            //get each of the conversations
                $currentQuote = readQuotes($resultItem['conversation_id']);
            // var_dump($currentQuote->customerWaitingSince->time);
            
                // var_dump($convoItem);
                $thisTime=$currentQuote->createdAt;
                $now = date("Y-m-d H:i:s");
                $date1 = strtotime($thisTime);
                $date2 = strtotime($resultItem['date_changed']);
             
              // Formulate the Difference between two dates
                $diff = abs($date2 - $date1);
                array_push($sentTimingOrders,$diff);  
                
        }
        if(count($sentTimingOrders)>0){
            getAverage($sentTimingOrders,$db);
        }
        else 
        {
            // incase there have not been any orders opened yet.
            echo json_encode(array('success'=>'true','result'=>array('average'=>0,'total'=>0,'count'=>0,'months'=>0,'days'=>0,'minutes'=>0,'hours'=>0,'seconds'=>0,'quotes_have_requests_total'=>0)));
            exit();
        }
        

    }
    else {
        echo json_encode(array('success'=>'false','result'=>array('error'=>$err)));
        exit();
    }

    function getAverage($sentTimingOrders,$db){
        $total = 0;
        for ($i=0;$i<count($sentTimingOrders);$i++){
            $total+=$sentTimingOrders[$i];
        }
        $count = count($sentTimingOrders);
        $average = $total/$count; 
        $years = floor($years = floor($average / (365*60*60*24)));
     
      // To get the month, subtract it with years and
      // divide the resultant date into
      // total seconds in a month (30*60*60*24)
      $months = floor(($average - $years * 365*60*60*24)
                                     / (30*60*60*24));
     
      // To get the day, subtract it with years and
      // months and divide the resultant date into
      // total seconds in a days (60*60*24)
      $days = floor(($average - $years * 365*60*60*24 -
                   $months*30*60*60*24)/ (60*60*24));
     
      // To get the hour, subtract it with years,
      // months & seconds and divide the resultant
      // date into total seconds in a hours (60*60)
      $hours = floor(($average - $years * 365*60*60*24
             - $months*30*60*60*24 - $days*60*60*24)
                                         / (60*60));
     
      // To get the minutes, subtract it with years,
      // months, seconds and hours and divide the
      // resultant date into total seconds i.e. 60
      $minutes = floor(($average - $years * 365*60*60*24
               - $months*30*60*60*24 - $days*60*60*24
                                - $hours*60*60)/ 60);
     
      // To get the minutes, subtract it with years,
      // months, seconds, hours and minutes
      $seconds = floor(($average - $years * 365*60*60*24
               - $months*30*60*60*24 - $days*60*60*24
                      - $hours*60*60 - $minutes*60));

       $sql = "SELECT * FROM quotes_have_requests";
       list($rs,$err)=runIQuery($db,$sql);
       if(!$err){  

        $total = count($rs);
        
        }
        else{
        
            echo json_encode(array('success'=>'false','message'=>'error around line 99 averageTimeToApproval.php'));
            exit();
        }    
    
        echo json_encode(array('success'=>'true','result'=>array('average'=>$average,'total'=>$total,'count'=>$count,'months'=>$months,'days'=>$days,'minutes'=>$minutes,'hours'=>$hours,'seconds'=>$seconds,'quotes_have_requests_total'=>$total)));
        exit();
    }

?>