<?php
#error_reporting(E_ALL);
#ini_set('display errors','on');
include('dbConnection.php');
include('functions.php');
include('security.php');
include('header.php');
$ip="";
if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	$ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
}
if (! $ip)  {	 
	$ip=$_SERVER['REMOTE_ADDR'];
}

$postvariables=json_encode($_POST);
$getvariables=json_encode($_GET);
$orderID=$_POST['id'];
$orderType=1;

function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}
date_default_timezone_set('America/Detroit');
if (isset($_POST['id'])) {
	$fileType="tab";
	$fname=$_FILES['quoteinfo']['tmp_name'];
	if (! $fname){
		print "<h3>File Name not detected</h3>";
		include('footer.php');
		exit;
	}
	if (! file_exists($fname)) {
		print "<h3>File $fname not found</h3>";
		include('footer.php');
		exit;
	}
	if (! file_exists($fname)) {
		print "No File";
		exit;
	}
	$pmOrder=$_FILES['quoteinfo']['file_name'];
	$contents=file_get_contents($fname);
	## Adding preliminary quote bdoss
	$sql = "SELECT `status` FROM orders WHERE order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
	$status=$rs[0][0];
	if ($status==19) {
		$sql="SELECT DATE_SUB(date_due, INTERVAL 30 DAY) FROM orders WHERE order_id=?";
		list($rs,$err)=runIQuery($db,$sql,array('i',$orderID));
		$canUpdate = $rs[0][0];
		$sql="UPDATE orders SET date_order=now() ";
		$sql.=" WHERE order_id=?";
		list($rs,$err)=runIQuery($db,$sql,array('i',$orderID));
		if (date("Y-m-d") > $canUpdate) {
			## if within 30 days, set status to quote instead of prelim
			updateOrderStatus($db,$orderID,1);
		}
	}
	## End preliminary Quote changes
	
	if (strstr(strtolower($contents),"error")) {
		print "<h3>You have an ERROR in your quote</h3>";	
		include('footer.php');
		exit;
	} else {
		$fp=fopen($fname,"r");
		//$header=fgets($fp);
		if (! $fp) {
			print "Empty file";
			include('footer.php');
			exit;
		}

		$fields=array();
		$cntr=0;
		$lc=0;
		$qpid="";
		$sql="delete from upload_order_lines where order_id=? and processed=0 ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
		$sql="delete from upload_lines_text where order_id=? and processed=0 ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
		while (!feof($fp)) {
			set_time_limit(100);
			$cntr++;
			$line=trim(fgets($fp));

			$fields=parseRecord($line,$fileType);
			if (strtoupper($fields[0]) == "LINE") {
				$lc++;
				$qpid=$fields[1];
				$sql="delete from upload_order_lines where order_line_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$qpid));
				$sql="delete from upload_lines_text where order_line_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$qpid));
				$sql="insert into upload_order_lines (order_id, order_line_id, processed, date_uploaded) values (?, ?, 0, now())  ";
				list($rs,$err)=runIQuery($db,$sql,array("is",$orderID,$qpid));
			}
			$sql="insert into upload_lines_text (order_id, order_line_id, line_text, who_uploaded, date_uploaded, processed) ";
			$sql.=" values (?, ?, ?, ?, now(), 0) ";
			list($rs,$err)=runIQuery($db,$sql,array("issi",$orderID,$qpid,$line,$userID));

		}
	}
}
print "<h4>Lines in FILE processed: $cntr</h4>";
print "<h3>Part Numbers Processed: $lc</h3>";
print "<a href='processUploadedQuote.php?id=$orderID&count=$cntr&lines=$lc' target='_self' class='btn btn-success'>Click Here to Process the Uploaded Lines</a>";
$sql="insert into order_activity (order_id, status, activity_date, ip_address, who, email_address, activity) values (?, ?, now(), ?, ?, ?, 'UPLOADED')";
list($rs,$err)=runIQuery($db,$sql,array("iisss",$orderID,$status,$ip,$userEmail,"n/a"));
include('footer.php');
