<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');
if (! $isAdmin) {
	include('footer.php');
	exit;
}
function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}

date_default_timezone_set('America/Detroit');
if (isset($_POST['uploaded'])) {
	$replace=$_POST['replace'];

	$fileType="tab";

	$hasheader=$_POST['hasheader'];

	if (! $hasheader) {

		$hasheader=0;

	}

	$fname=$_FILES['leads']['tmp_name'];

	print "fname is $fname<br>";

	$fp=fopen($fname,"r");
	if (! $fp) {
		print "no file.";
		include('footer.php');
		exit;
	}

	if ($hasheader) {

		$header=fgets($fp);		

	}

	while (!feof($fp)) {

		set_time_limit(100);

		$cntr++;

		$line=trim(fgets($fp));

		$fields=array();

		$fields=parseRecord($line,$fileType);

		$idx=0;
		if (count($fields) > 7) {
			$item=$fields[0];
			$description=$fields[1];
			$qty=$fields[5];
			$cost=$fields[7];
			if (!  $cost) {
				$cost=0;
			}
			$sql="select item_id from items where item_name=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$item));
			$data=$rs[0];
			$itemID=$data[0];
			if (! $itemID) {	
				print "item $item not found<BR>";
			}	 else {
				$sql="update items set quantity_on_hand = ? where item_id=? ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$qty,$itemID));
				if ($cost > 0) {
					$sql="update items set cost=? where item_id=?";
					list($rs,$err)=runIQuery($db,$sql,array("di",$cost,$qty));
				}
				$sql="delete from item_locations where item_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
				$sql="insert into item_locations (item_id, location_id, quantity, available) values (?, 1, ?, 1) ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$qty));
				print "$item updated<BR>";
			}
		}
	}
	print "<center><h3>$cntr Record(s) Processed</h3></center>";
	fclose($fp);
	include('footer.php');
	exit;
} 

if (! $uploaded) {
?>

<center><h3>Upload Items</h3></center>
<p>Format is item_name, item_description, quantity in field 6, cost in field 8.  Text tab delimited.</p>
<br>
<center>
<form name='updform' action='uploadInventory.php' method='POST' enctype="multipart/form-data">
<input type='hidden' name='uploaded' value='1'>
<input type='checkbox' name='hasheader' value='1' checked> &rarr; My file has headers
<BR>
<input type='file' name='leads'>
<br>
<input type='submit' class='btn blue' value='Upload'>
</form>
</center>

<?php

} ## if not uploaded yet uploaded

include('footer.php');

?>