<?php
#error_reporting(E_ALL);
#ini_set('display errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');
function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='pipe') {
		$fields=explode("|",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}
date_default_timezone_set('America/Detroit');
$customer=693;
if (isset($_POST['uploaded'])) {
	$fileType="tab";
	$fname=$_FILES['leads']['tmp_name'];
	$fp=fopen($fname,"r");
	$header=fgets($fp); // actual header
	$nextPart=0;
	$soNumber = 0;
	$weldments=array();
	$cntr=0;
	while (!feof($fp)) {
		set_time_limit(100);
		$cntr++;
		$line=trim(fgets($fp));
		$fields=array();
		$fields=parseRecord($line,$fileType);
		$part=trim($fields[1]);
		$vendor=trim($fields[3]);
		$description=trim($fields[4]);
		$category=19; // component
		$status=4; //active
		$uom=7; // ea
		if ($vendor) {
			$vendor=2127;
		} else {
			$vendor=0;
		}

		if (strstr($description,"WELD")) {
			$category=15; // weldment
		}
		$qoh=0;
		$price=0;
		$cost=0;

		// add default cycle count if exists -Josh 02-16-2023
		$sql = "select default_cycle_count from item_categories where category_id=? and default_cycle_count<>0 and not default_cycle_count is null";
		list($crs,$err)=runIQuery($db,$sql,["i",$category]);
		$defaultCCount=0;
		if (count($crs)) {
			$defaultCCount=$crs[0]["default_cycle_count"];
		}

		$sql="insert into items (item_name, item_category, item_description, unit_of_measure, price, cost, status, quantity_on_hand, vendor_id" . ($defaultCCount ? ", cycle_count" : "") . ") values (?, ?, ?, ?, ?, ?, ?, ?, ?" . ($defaultCCount ? ", ?" : "") . ") ";

		$vars=["sisiiiiii",$part,$category,$description,$uom, $price, $cost, $status, $qoh, $vendor];
		if ($defaultCCount) {
			$vars[0].="i";
			$vars[]=$defaultCCount;
		}
		list($rs,$err)=runIQuery($db,$sql,$vars);
	}
	print "<center><h3>$cntr Record(s) Processed</h3></center>";
	fclose($fp);
	include('footer.php');
	exit;
}
if (! $uploaded) {
?>
<center>
<form name='updform' action='uploadIMSBOM.php' method='POST' enctype="multipart/form-data">
<input type='hidden' name='uploaded' value='1'>
<h3>Upload Text Tab File for IMS BOM</h3>
<input type='file' name='leads'>
<br>
<input type='submit' class='btn blue' value='Upload'>
</form>
</center>
<?php
} ## if not uploaded yet uploaded
include('footer.php');
?>