<?php
$table="employee_hours";
$activePanel=$table;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');

function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}

date_default_timezone_set('America/Detroit');
if (isset($_POST['uploaded'])) {
	$fname=$_FILES['file']['tmp_name'];
	$fp=fopen($fname,"r");
	$header=fgets($fp);
	$lc=1;
	$records=0;
	while (!feof($fp)) {
		$line=trim(fgets($fp));			
		$lc++;
		$fields=parseRecord($line,"csv");
		if (trim($fields[0]) <> "" ) {
			$records++;
			$qbid=$fields[1];
			$dt=formatDateWebToDB($fields[2]);
			$punch=$fields[12];
			list($hours,$minutes)=explode(":",$punch);
			$minutes += ($hours*60);	
			$sql="select employee_id from employees where quickbooks_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$qbid));
			$data=$rs[0];
			$employeeID = $data[0];
			if (! $employeeID) {
				$employeeID=0;
				print "$qbid not found in Employee table.  Please Add, then edit the hours.<br>";
			}
			$sql="insert into employee_hours (employee_id, date_clocked, minutes_clocked) values (?, ?, ?) ";
			list($rs,$err)=runIQuery($db,$sql,array("isi",$employeeID,$dt,$minutes));
			print ($err);
		}
	}
	fclose($fp);
	print "<h3>$records Records processed ($lc total lines)</h3>";
	include('footer.php');
	exit;
} else {
	print renderPanel("Upload Hours","","blue");
	print "<form name='updform' action='uploadHours.php' method='POST' enctype='multipart/form-data'>";
	print "<input type='hidden' name='uploaded' value='1'>";
	print "<h4>Upload CSV file for hours from Quickbooks</h4>";
	print renderFile(TRUE,"file","","Select File");
	print renderButton("Upload","blue","document.updform.submit();","btnSubmit");
	print "</form>";
	print renderClosePanel();
	include('footer.php');
} 


?>