<?php
include('dbConnection.php');
include('functions.php');
include('security.php');
require_once('s3.php');
if (! isset($_POST['data'])) {
	$_POST=$_GET;
}
function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='pipe') {
		$fields=explode("|",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}
date_default_timezone_set('America/Detroit');
$customer=693;
$html="";
if (isset($_POST['html'])) {
	$html=$_POST['html'];
}
if (isset($_POST['data'])) {
	$docType=$_POST['type'];
	$data=$_POST['data'];
	foreach (explode("\n",$data) as $record) {
		$fields=parseRecord($record,"pipe");
		if ($docType == "BUYER") {
			if ($fields[0] == "HDR") {
				$type=$fields[1];
				$poNumber=$fields[2];
				$buyer=$fields[6];
				$sql="update edi_orders set ship_attention=? where po_number=? and document_type='850' ";
				list($rs,$err)=runIQuery($db,$sql,array("ss",$buyer,$poNumber));
			}
		} else {
			if ($fields[0] == "HDR") {
				$type=$fields[1];
				$poNumber=$fields[2];
				$due=$fields[3];
				$dueDate=substr($due,0,4) . "-" . substr($due,4,2) . "-" . substr($due,6,2);
				$poDate=$fields[4];
				$customerOrder=$fields[5];
				$buyer=$fields[6];
				$shipName=$fields[7];
				$shipCode=$fields[8];
				$shipAddress=$fields[9];
				$shipCity=$fields[10];
				$shipState=$fields[11];
				$shipZip=$fields[12];
				$sql="insert into edi_orders (customer_id, date_order, date_due, document_type, ship_name, ship_address, ship_city, ship_state, ship_zip, po_number, ship_attention) values (693, now(), ?, ?, ?, ?, ?, ?, ?, ?,? ) ";
				list($rs,$err)=runIQuery($db,$sql,array("sisssssss",$dueDate,$docType,$shipName,$shipAddress,$shipCity,$shipState,$shipZip,$poNumber,$buyer));
				$soNumber=$rs[0]['id'];
				if ($html) {
					$fname="EDI$poNumber-$docType-" . Date("YmdHis") . ".html";
					uploadFile($html, $fname, true);
				}
			}
			if ($fields[0] == "LIN") {
				$poLine=$fields[1];
				$part=$fields[2];
				$description=$fields[3];
				$qty=$fields[4];
				$price=$fields[5];
				$due=$fields[6];
				$dueDate=substr($due,0,4) . "-" . substr($due,4,2) . "-" . substr($due,6,2);
				$notes=$fields[7];
				$revision=$fields[8];
				$colorCode=substr($part,-2);
				$color=0;
				$sql="select vc_id from dematic_colors where color_code=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$colorCode));
				if (count($rs)>0) {
					$data=$rs[0];
					$color=$data[0];
				}
				$sql="insert into edi_order_lines (order_id, original_item, original_revision, item_description, original_quantity, original_due_date, original_price, po_line, original_color, notes) values (?, ?, ?, ?, ?, ?, ?, ?,?,?)";
				list($rs,$err)=runIQuery($db,$sql,array("isssisdsis",$soNumber, $part,$revision,$description,$qty,$dueDate,$price,$poLine,$color,$notes));
			}
			if ($fields[0] == "SCH") {
				## sch will send as LIN so this segment no longer exists
			}
		}
	}
	print "EDI Processed";
}
