<?php
#error_reporting(E_ALL);
#ini_set('display errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');

if (! $isAdmin) {
	include('footer.php');
	exit;
}

function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}

	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}

date_default_timezone_set('America/Detroit');

if (isset($_POST['uploaded'])) {
	$sql="select color_code, color_name from dematic_colors "	;
	list($rs,$err)=runIQuery($db,$sql);
	$colors=array();
	foreach ($rs as $data) {
		$ck=$data['color_code'];
		$name=$data['color_name'];
		$colors[$ck]=$name;
	}
	$fileType="tab";
	$hasheader=$_POST['hasheader'];
	if (! $hasheader) {
		$hasheader=0;
	}
	$fname=$_FILES['leads']['tmp_name'];
	$fp=fopen($fname,"r");
	$cntr=0;
	if ($fp) {
		if ($hasheader) {
			$header=fgets($fp);		
		}
		while (!feof($fp)) {
			set_time_limit(100);
			$cntr++;
			$line=trim(fgets($fp));
			$fields=array();
			$fields=parseRecord($line,$fileType);
			$idx=0;
			$item=trim($fields[0]);
			if ($item) {
				$newDescription=$fields[1];
				$newDescription=str_replace("'","",$newDescription);
				$sql="update items set item_description=? where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("ss",$newDescription,$item));
				print "updated $item to $newDescription<br>";
				$search=$item . "%";
				$sql="select item_name from items where item_name like ? and item_name <> ?";
				list($rs,$err)=runIQuery($db,$sql,array("ss",$search,$item));
				foreach ($rs as $data) {
					$itemName=$data['item_name'];	
					$color=substr($itemName,-2);
					if ($colors[$color]) {
						$colorDescription=$newDescription . " " . $colors[$color];
						$sql="update items set item_description=? where item_name=?";					
						list($updrs,$err)=runIQuery($db,$sql,array("ss",$colorDescription,$itemName));
						print "updated $itemName to $colorDescription<br>";
					}
			}		
			}
		}
		print "<center><h3>$cntr Record(s) Processed</h3></center>";
		fclose($fp);	
	} else {
		print "no file.";
	}
	include('footer.php');
	exit;
} 

if (! $uploaded) {

?>

<form name='updform' action='uploadDescriptions.php' method='POST' enctype="multipart/form-data">
<input type='hidden' name='uploaded' value='1'>

<center><h3>Upload Description Updates</h3></center>
<p>The file just needs part number in first column, description in second column.  Check below if your file has a header.  Format must be text tab delimited</p>
<center>
<input type='checkbox' name='hasheader' value='1' checked> &rarr; My file has headers
<BR>
<input type='file' name='leads'>
<br>
<input type='submit' class='btn blue' value='Upload'>

</form>

</center>

<?php

} ## if not uploaded yet uploaded

include('footer.php');

?>