<?php
#error_reporting(E_ALL);
#ini_set('display errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
include('header.php');
function parseRecord($line,$filetype) {
	if ($filetype=='tab') {
		$fields=explode("\t",$line);
		return $fields;
	}
	if ($filetype=='pipe') {
		$fields=explode("|",$line);
		return $fields;
	}
	if ($filetype=='csv') {
		$fields=str_getcsv($line);
		return $fields;
	}
}
date_default_timezone_set('America/Detroit');
$customer=693;
if (isset($_POST['uploaded'])) {
	$fileType="tab";
    $fname=$_FILES['leads']['tmp_name'];
	$fp=fopen($fname,"r");
	$header=fgets($fp); // actual header		
	$nextPart=0;
	$soNumber = 0;
    $weldments=array();
    $sql="delete from dematic_ar_upload";
    list($rs,$err)=runIQuery($db,$sql);
    $fields=array();
    if ($fname) {
        while (!feof($fp)) {
            set_time_limit(100);     
            $line=trim(fgets($fp));
            if ($line) {
                $fields=parseRecord($line,$fileType);
                if ($fields[0]=="Invoice") {
                    $cntr++;
                    $invoiceDate=formatDateWebToDB(trim($fields[2]));
                    $dueDate=formatDateWebToDB($fields[8]);
                    $invoiceNumber=trim($fields[4]);
                    $poNumber=trim($fields[6]);
                    $balance=trim($fields[10]);
                    $balance=str_replace("\"","",$balance);
                    $balance=str_replace("\$","",$balance);
                    $balance=str_replace(",","",$balance);
                    $balance=str_replace(")","",$balance);
                    $balance=str_replace("(","-",$balance);
                    $sql="select  p.ship_name, pl.order_id, pl.po_line, pl.part_number, pl.description, coalesce(o.attention,'') as attention, p.packing_slip_id  from packing_slip  p left outer join packing_slip_lines pl ";
                    $sql.=" on packing_slip_id=packing_list_id left outer join orders o on pl.order_id=o.order_id and o.po_number=? where p.invoice_number=?  ";
                    list($rs,$err)=runIQuery($db,$sql,array("si",$poNumber,$invoiceNumber));
                    if (count($rs)>0) {
                        $data=$rs[0];
                        $buyer=trim($data['attention']);
                        $sql="select ship_attention from edi_orders where document_type='850' and po_number=?";
                        list($ers,$err)=runIQuery($db,$sql,array("s",$poNumber));
                        if (count($ers)>0) {
                            $edata=$ers[0];
                            $tb=$edata['ship_attention'];
                            if ($tb) {
                                $buyer=$tb;
                            }
                        }
                        if (! $buyer) {
                            $buyer=$data['ship_name'];
                        }
                        $order=$data['order_id'];
                        $poLine=$data['po_line'];
                        $part=$data['part_number'];
                        $packingSlip=$data['packing_slip_id'];
                        $description=$data['description'];
                        $sql="select distinct b.bol_id, b.date_created from bol_skids bs inner join bol b on bs.bol_id=b.bol_id where packing_slip=? ";
                        list($brs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
                        $bdata=$brs[0];
                        $bol=$bdata['bol_id'];
                        $dt=$bdata['date_created'];
                        if (! $bol) {
                            $bol=0;
                            $dt="0000-00-00";
                        }
                        $sql="insert into dematic_ar_upload(uploaded_by, upload_date, invoice_date, invoice_number, po_number, po_line, bol_id, bol_date, order_id, part_number, buyer_name, open_balance, due_date) ";
                        $sql.=" values (?, now(), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?) ";
                        list($updrs,$err)=runIQuery($db,$sql,array("isisiisissds",$userID,$invoiceDate,$invoiceNumber,$poNumber,$poLine,$bol,$dt,$order,$part,$buyer,$balance,$dueDate));
                    } else {
                        $sql="insert into dematic_ar_upload(uploaded_by, upload_date, invoice_date, invoice_number, po_number, po_line, bol_id, bol_date, order_id, part_number, buyer_name, open_balance) ";
                        $sql.=" values (?, now(), ?, ?, ?, 0,0,'',0,'','',?,?) ";
                        list($updrs,$err)=runIQuery($db,$sql,array("isisds",$userID,$invoiceDate,$invoiceNumber,$poNumber,$balance,$dueDate));
                    }
                }
            }
        }
        print "<center><h3>$cntr Record(s) Processed</h3></center>";
        fclose($fp);
        print "<a href='exportDematicAR.php'>Download The Results</a>";
    } else {
        print "<h3>No File Browsed</h3>";
    }
	include('footer.php');
	exit;
} 
if (! $uploaded) {
?>
<center>
<form name='updform' action='uploadDematicAR.php' method='POST' enctype="multipart/form-data">
<input type='hidden' name='uploaded' value='1'>
<h3>Upload Text Tab File for Dematic AR Aging</h3>
<p>Program expects Invoice Date in Column G, Invoice Number in Column I, PO Number in Column K, and Open Balance in Column O.<p>
<p>This should be the exact format exported from QB, without modifications other than swaving as text tab delimited.</p>
<p>Upon upload it will return a tab delimited file with BOL, BOL Date, SO#, PO Line, Part Number and Buyer Name (or ship name if buyer not entered in attention field)</p>
<input type='file' name='leads'>
<br>
<input type='submit' class='btn blue' value='Upload'>
</form>
</center>
<?php
} ## if not uploaded yet uploaded
include('footer.php');
?>