<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
if ($viewOnly) {
	exit;
}
if (! isset($_POST['location'])) {
	$_POST=$_GET;
}
$id=mysqli_real_escape_string($db,$_POST['id']);
$shipping=$_POST['shipping_info'];
$info=explode("\n",$shipping);
$i=0;
$location=$_POST['location'];
$name=$_POST['ship_name'];
$address=$_POST['ship_address'];
$city=$_POST['ship_city'];
$state=$_POST['ship_state'];
$zip=$_POST['ship_zip'];
$vendor=$_POST['vendor'];
if (! $vendor) {
	$vendor=0;
}
$td=formatDateWebToDB($_POST['transfer_date']);
if ($id > 0) {
	$sql="update transfers set   location=?, ship_name=?,  ship_address=?, ship_city=?, ship_state=?, ship_zip=?, transfer_date=?, vendor_id=? where packing_slip=? ";
	$stmt=$db->prepare($sql);
	$stmt->bind_param("sssssssii",$location,$name,$address,$city,$state,$zip,$td,$vendor,$id);
	$stmt->execute();
	if ($stmt->error) {
		print "<h4 class='alert_error'>There was an error updating the system. $sql<BR>" . mysqli_error($db) . "</h4>";
	} else {
		print "<h4 class='alert_success'>Record Updated</h4>";
	}
} else {
	$values="";
	$sql="insert into transfers (location, ship_name, ship_address, ship_city, ship_state, ship_zip, transfer_date) ";
	$sql.=" values (?,?,?,?,?,?,?) ";
	$stmt=$db->prepare($sql);
	$stmt->bind_param("sssssss",$location,$name,$address,$city,$state,$zip,$td);
	$stmt->execute();
	if ($stmt->error) {
		print "<h4 class='alert_error'>There was an Error Adding the record the system. " . mysqli_error($db) . "<BR>" . $sql . "</h4>";
	} else {
		$id=$stmt->insert_id;
		print "$id";
	}
}
if ($id > 0) {
	$i=0;
	$olist=array();
	while ($i < 40)	{
		if ($_POST['qty'.$i]) {
			$olist[]=$_POST['ol'.$i];
		}
		$i++;
	}
	$i=0;
	$toggle=1;
	while ($i < 999) {
		$ol=$_POST['ol'.$i];
		$key='item'.$i;
		$item=trim($_POST[$key]);
		$desc=$_POST['desc'.$i];
		if ($item or $desc) {
			$qty=$_POST['qty'.$i];
			$po=$_POST['po'.$i];
			$pkg=$_POST['packaging'.$i];
			$customer=$_POST['customer'.$i];
			if ($ol){
				$sql="update transfer_lines set part_number=?, description=?, quantity=?,   po_number=?, packaging=?, customer_id=? where txid=?";
				list($rs,$err)=runIQuery($db,$sql,array("ssissii",$item,$desc,$qty,$po,$pkg,$customer,$ol));
			} else {
				$sql="insert into transfer_lines (packing_slip, part_number, description, quantity,  po_number, packaging, customer_id) ";
				$sql.=" values (?, ?, ?, ?, ?, ?, ?) ";
				list($rs,$err)=runIQuery($db,$sql,array("issdssi",$id,$item,$desc,$qty,$po,$pkg,$customer));
			}
			$sql="select vendor_id from purchase_orders where po_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$po));
			if (count($rs)>0) {
				$data=$rs[0];
				$oldVendor=$$data[0];
				if ($oldVendor != $vendor) {
					$nm=trim($location . " " . $name);
					$sql="update purchase_orders set vendor_id=?, ship_name=?, ship_address=?, ship_city=?, ship_state=?, ship_zip=? where po_id=?";
					list($rs,$err)=runIQuery($db,$sql,array("issssii",$vendor,$nm,$address,$city,$state,$zip,$po));

					// PO ACTIVITY updated location
					$sql = "select po.status, ps.status_name from purchase_orders po, po_status ps where po.status=ps.status_id and po_id=?";
					list($srs,$err) = runIQuery($db,$sql,["i",$po]);
					$stat = $srs[0]["status"];
					$statName = $srs[0]["status_name"];

					updatePOActivity($db,$po,$stat,"Set location to $nm - $statName");
				}
			}
		}
		$i++;
	}
	// 6/22 change mysqli_query to runIQuery Brittany
	$sql="delete from transfer_lines where packing_slip=? and quantity = 0 ";
	list($rs,$err)=runIQuery($db,$sql,array('i', $id));


}
?>