<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
if (! $_POST) {
	$_POST=$_GET;
}
$id=mysqli_real_escape_string($db,$_POST['id']);
$customer_id=$_POST['customer_id'];
$attention=$_POST['attention'];
$name=$_POST['ship_name'];
$address=$_POST['ship_address'];
$address2=$_POST['ship_address2'];
$city=$_POST['ship_city'];
$state=$_POST['ship_state'];
$zip=$_POST['ship_zip'];
$phone=$_POST['ship_phone'];
$email=$_POST['ship_email'];
$date_shipped=formatDateWebToDB($_POST['date_shipped']);
$quickbooks_packing_slip="";
if (isset($_POST['shipping_id'])) {
	$shippingID=$_POST['shipping_id'];
} else {
	$shippingID = 6;
}
if (! $quickbooks_packing_slip) {
	$quickbooks_packing_slip=0;
}
$notes_to_customer=$_POST['notes_to_customer'];
if (! $notes_to_customer) {
	$notes_to_customer="";
}
$notes_to_self=$_POST['notes_to_self'];
if (! $notes_to_self) {
	$notes_to_self="";
}
$tracking_number=$_POST['tracking_number'];
$invoice_number="";
if (isset($_POST['invoice_number'])) {
	$invoice_number=$_POST['invoice_number'];
}
if ($id > 0) {
	$before = [];
	$after = [];

	$sql = "SELECT line_id, part_number, quantity, order_id FROM packing_slip_lines WHERE packing_list_id=?;";
	list($brs,$err)=runIQuery($db,$sql,["i",$id]);
	foreach ($brs as $line) {
		$before[$line["line_id"]] = $line;
	}

	if ($invoice_number) {
		$sql="update packing_slip set invoice_number=? where packing_slip_id=? and invoice_number='0'";
		$stmt=$db->prepare($sql);
		$stmt->bind_param("si",$invoice_number,$id);
		$stmt->execute();
		$stmt->close();
	}
	$sql="update packing_slip set shipping_id=?, customer_id=?,  attention=?, ship_name=?, ship_email=?, notes_to_customer=?, notes_to_self=?,  ship_address=?, ship_address2=?, ship_city=?, ship_state=?, ship_zip=?, tracking_number=?, ship_phone=?, date_shipped=? where packing_slip_id=? ";
	$stmt=$db->prepare($sql);
	$stmt->bind_param("iisssssssssssssi",$shippingID,$customer_id,$attention,$name, $email,$notes_to_customer,$notes_to_self,$address,$address2,$city,$state,$zip,$tracking_number,$phone,$date_shipped,$id);
	$stmt->execute();
	if ($stmt->error) {
		print "<h4 class='alert_error'>There was an error updating the system. $sql<BR>" . $stmt->error . "</h4>";
	} else {
		logTransaction($db,renderQuery($sql,array("iisssssssssssssi",$quickbooks_packing_slip,$customer_id,$attention,$name, $email,$notes_to_customer,$notes_to_self,$address,$address2,$city,$state,$zip,$tracking_number,$phone,$date_shipped,$id)));
		print "<h4 class='alert_success'>Record Updated</h4>";
	}
} else {
	$values="";
	$sql="insert into packing_slip (shipping_id, customer_id,  ship_name, attention, ship_email,  notes_to_customer, notes_to_self, ship_address, ship_address2, ship_city, ship_state, ship_zip, tracking_number, ship_phone, date_shipped, invoice_number) ";
	$sql.=" values (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?,0) ";
	if ($quickbooks_packing_slip == NULL) {
		$quickbooks_packing_slip=0;
	}
	list($rs,$err)=runIQuery($db,$sql,array("iisssssssssssss",$shippingID,$customer_id,$name,$attention,$email,$notes_to_customer,$notes_to_self,$address,$address2,$city,$state,$zip,$tracking_number,$phone,$date_shipped));
	if ($err) {
		print "<h4 class='alert_error'>There was an Error Adding the record the system. " .  $err . "<BR>" . $sql . "</h4>";
	} else {
		$id=$rs[0]['id'];
		print "$id";
	}
	$before=[];
}
if ($id > 0) {
	$i=0;
	$olist=array();
	while ($i < 999)	{
		if (isset($_POST['ol'.$i])) {
			if ($_POST['ol'.$i]) {
				$olist[]=$_POST['ol'.$i];
			}
		} else {
			$i=999;
		}
		$i++;
	}
	## remove any deleted lines
	if (count($olist)) {
		$sql="delete from packing_slip_lines where packing_list_id=? and line_id not in (" . implode(",",$olist) . ")";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	}
	$i=0;
	$toggle=1;
	while ($i < 999) {
		if (isset($_POST['ol'.$i])) {
			$ol=$_POST['ol'.$i];
			$item=strtoupper(trim($_POST['item'.$i]));
			$desc=$_POST['desc'.$i];
			if ($item or $desc) {
				$sql="select item_id from items where item_name=?";
				list($irs,$err)=runIQuery($db,$sql,array("s",$item));
				if (count($irs)>0) {
					$idata=$irs[0];
					$itemID=$idata[0];
				} else {
					$itemID=0;
				}
				$qty=$_POST['qty'.$i];
				$po=$_POST['po'.$i];
				$pol=$_POST['pol'.$i];
				if (! $pol) {
					$pol=0;
				}
				if (! $po) {
					$pol=0;
				}
				$so=$_POST['so'.$i];
				$sol=$_POST['sol'.$i];
				if (! $so) {
					$so=0;
				}
				if (! $sol) {
					$sol=0;
				}
				if ($po == null ) {
					$po=0;
				}
				if ($pol == null) {
					$pol=0;
				}
				if ($so == null) {
					$so=0;
				}
				if ($sol==null) {
					$sol=0;
				}
				if ($ol){
					$sql="select quantity, shipped from packing_slip_lines where line_id=?";
					list($prs,$err)=runIQuery($db,$sql,array("i",$ol));
					$diff=0;
					if (count($prs) > 0) {
						$pdata=$prs[0];
						$alreadyShipped=$pdata['shipped'];
						$diff=$pdata['quantity'] - $qty;
						if ($alreadyShipped ) {
							if ($diff > 0) {
							## we are unshipping some items
								$sql="update order_lines set shipped_quantity = shipped_quantity - $diff where line_id=$sol ";
								$rs=mysqli_query($db,$sql);
								logTransaction($db,$sql);
								inventoryUpdate($db,$itemID,$diff,$scriptid,"Unship Packing Slip $id",$userID);
							} else {
								if ($diff < 0) {
									# we are increasing how much we shipped
									$diff=$diff*-1;
									$sql="update order_lines set shipped_quantity = shipped_quantity + $diff where line_id=$sol ";
									$rs=mysqli_query($db,$sql);
									logTransaction($db,$sql);
									$diff=$diff*-1;
									inventoryUpdate($db,$itemID,$diff,$scriptid,"More Ship Packing Slip $id",$userID);
								}
							}
						}
					}
					$sql="update packing_slip_lines set part_number=?, description=?, quantity=?,  po_line=?, po_number=?, order_id=?, order_line=? where line_id=?";
					list($rs,$err)=runIQuery($db,$sql,array("ssdssiii",$item,$desc,$qty,$pol,$po,$so,$sol,$ol));
				} else {
					if ($qty<> 0 ) {
						$sql="insert into packing_slip_lines (packing_list_id, part_number, description, quantity, po_line, po_number, order_id, order_line) ";
						$sql.=" values (?, ?, ?, ?, ?, ?, ?, ?) ";
						list($rs,$err)=runIQuery($db,$sql,array("issdssii",$id,$item,$desc,$qty,$pol,$po,$so,$sol));
					}
				}
			}
		} else {
			$i=999;
		}
		$i++;
	}
	$sql="delete from packing_slip_lines where quantity = 0 ";
	$rs=mysqli_query($db,$sql);

	// START order activity
	$sql = "SELECT line_id, part_number, quantity, order_id FROM packing_slip_lines WHERE packing_list_id=?;";
	list($ars,$err)=runIQuery($db,$sql,["i",$id]);
	foreach ($ars as $line) {
		$after[$line["line_id"]] = $line;
	}
	$changes = [];
	$added_lines = [];
	$removed_lines = [];

	foreach ($before as $bid => $bline) {
		$boid  = $bline["order_id"];
		$bpart = $bline["part_number"];
		$bqty  = $bline["quantity"];

		if (!isset($changes[$boid])) {
			$changes[$boid] = [];
		}

		if (!in_array($bline["line_id"], array_keys($after))) {
			$changes[$boid][] = "Removed part $bpart with a quantity of $bqty";
		} else {

			$aline = $after[$bid];

			$aid   = $aline["line_id"];
			$apart = $aline["part_number"];
			$aqty  = $aline["quantity"];

			if ($bpart != $apart) {
				$changes[$boid][] = "Changed part $bpart to $apart";
			}

			if ($bqty != $aqty) {
				$changes[$boid][] = "Set quantity for part $apart from $bqty to $aqty";
			}

		}
	}
	foreach ($after as $aid => $aline) {
		$aoid  = $aline["order_id"];
		$apart = $aline["part_number"];
		$aqty  = $aline["quantity"];

		if (!in_array($aid, array_keys($before))) {
			$changes[$aoid][] = "Added part $apart with a quantity of $aqty";
		}
	}
	foreach ($changes as $order_id => $changelist) {
		if (!isset($forwarded)) {
			$forwarded = 0;
		}
		if (count($changelist) == 0) {
			continue;
		}
		$sql = "select status from orders where order_id=?";
		list($rs) = runIQuery($db,$sql,["i",$order_id]);
		$status=0;
		if (count($rs)) {
			$status=$rs[0]["status"];
		}
		$sql = "INSERT INTO order_activity (order_id, `status`, activity_date, ip_address, who, email_address, activity) VALUES (?, ?, ?, ?, ?, '', ?);";
		list($rs,$err)=runIQuery($db,$sql,["iissss",$order_id,$status,date("Y-m-d H:i:s"),$forwarded,$userEmail,"PSACT:" . implode('<br>', $changelist)]);

	}
	// END order activity

}
?>