<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$action="";
$repeatID=0;
$reminderID=0;
$customer=0;
$reminderRecipients=[];
$reminderMessage="";
$reminderStatus=1;
$customerClass="showCustomer";
$customerName="";
$isEdit=0;
$requiresMessage=0;
$requiresRecipients=0;


if (isset($_GET['action'])) { // setting the action goes outside of get id because if action is create, it won't have an id yet
    $action=$_GET['action'];
} elseif(isset($_POST['action'])) {
    $action=$_POST['action'];
}

if (isset($_GET['id'])) {  // first get repeat id if it's an existing repeat reminder, then get what we're supposed to do with it: delete or edit
    $repeatID=$_GET['id']; //$repeatID will come from GET Request if it's coming from automatedReminders.php, so edits or deletes

    if ($action == "delete") { // if deleting the repeat reminder
        $sql = "DELETE FROM repeat_reminders WHERE repeat_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$repeatID));
    } elseif ($action == "edit") { // if editing an existing repeat reminder
        $sql="SELECT repeat_reminders.*, order_status.status_name, customers.name FROM repeat_reminders
            INNER JOIN order_status ON repeat_reminders.order_status=order_status.status_id 
            INNER JOIN customers ON customers.customer_id=repeat_reminders.customer
            WHERE repeat_id=?";
        list($rs,$err)=runIQuery($db,$sql,array('i',$repeatID));
        foreach($rs as $data) {
            $customerClass="hideCustomer";
            $statusName=$data['status_name'];
            $reminderStatus=$data['order_status'];
            $customerName=$data['name'];
            $customer=$data['customer'];
            $reminderMessage=$data['reminder_message'];
        }
 
        ## get reminderID of last order to use the repeat reminder
        $sql="SELECT reminder_id FROM order_reminders WHERE order_status=? AND customer=? AND reminder_message=? ORDER BY reminder_id DESC LIMIT 1";
        list($rs,$err)=runIQuery($db,$sql,array('iis',$reminderStatus,$customer,$reminderMessage));
        if ($rs) {
            $reminderID=$rs[0][0];
            //$reminderRecipients=[];
            $sql="SELECT employee_id FROM employee_reminders WHERE reminder_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));
            foreach($rs as $data) {
                $employee=$data['employee_id'];
                array_push($reminderRecipients,$employee); 
            }
        }
    }

} elseif ((empty($_POST['reminder_message']) || (!isset($_POST['employees']))) && $action != "create") { // if the form isn't filled out completely, save what they did fill out and tell them what fields they're missing
    $action = "tryagain"; // just have to get rid of the confirmation action so the form will appear
    if (empty($_POST['reminder_message'])) {
        $requiresMessage = 1;
    }
    if (empty($_POST['employees'])) {
        $requiresRecipients = 1;
    }
    if (isset($_POST['customer'])) {
        $customer=$_POST['customer'];  
    }
    if (isset($_POST['reminder_status'])) {
        $reminderStatus=$_POST['reminder_status'];
    }
    if (isset($_POST['reminder_message'])) {
        $reminderMessage=$_POST['reminder_message'];
    }
    if (isset($_POST['employees'])) {
        $reminderRecipients = $_POST['employees'];
    }
} elseif (isset($_POST['reminder_message'])) { // if there is no get, then look for post variables after the form submits, this block of code runs if this page posted to itself
    $repeatID=$_POST['repeat_id'];
    $reminderMessage=$_POST['reminder_message'];
    $customer=$_POST['customer'];
    $reminderStatus=$_POST['reminder_status'];
    $reminderRecipients=$_POST['employees'];

    if ($repeatID) { // if updating an existing reminder
        $isEdit=1;
        $sql="UPDATE repeat_reminders SET order_status=?, reminder_message=? WHERE repeat_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("isi",$reminderStatus,$reminderMessage,$repeatID));
    } else { // creating a new repeat reminder
        $sql="INSERT INTO repeat_reminders (customer,order_status,reminder_message)
            VALUES (?,?,?)";
        list($rs,$err)=runIQuery($db,$sql,array("iis",$customer,$reminderStatus,$reminderMessage));
    }

    ## create a dummy order so the employee emails are saved
    $sql="INSERT INTO order_reminders (order_id,order_status,customer,repeat_reminder,reminder_message,created_on,sent_on)
            VALUES (0,?,?,1,?,now(),now())";
    list($rs,$err)=runIQuery($db,$sql,array("iis",$reminderStatus,$customer,$reminderMessage));
    
    ## get the id of last query
    //$sql="SELECT LAST_INSERT_ID()"; //bdoss this was returning a bogus value for some reason
    $sql="SELECT MAX(reminder_id) FROM order_reminders WHERE order_status=? AND customer=? AND reminder_message=?";
    list($rs,$err)=runIQuery($db,$sql,array("iis",$reminderStatus,$customer,$reminderMessage));
    $reminderID=$rs[0][0];
    ## insert employees into employee_reminders table
    foreach($reminderRecipients as $recipient) {
       $sql="INSERT INTO employee_reminders (reminder_id, employee_id)
                VALUES (?,?)";
        list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
    }

    ## Getting info to display in the confirmation that appears after the form is submitted
    $customerName="";
    $sql="SELECT `name` FROM customers WHERE customer_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
    if ($rs) {
        $customerName=$rs[0][0];
    }
    $statusName="";
    $sql="SELECT status_name FROM order_status WHERE status_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$reminderStatus));
    if ($rs) {
        $statusName=$rs[0][0];
    }
    ## get email recipient names for displaying confirmation after form submit
    $employeeNames="";
    $sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
    list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
    foreach($employee_rs as $employee_data) {
        $employeeNames.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
    }
}


print renderPanel("Repeat Reminder");
if ($action == "confirmation") {
    if ($isEdit) {
        print "<h3>Repeat Reminder Updated</h3>";
    } else {
        print "<h3>Repeat Reminder Created</h3>";
    }
    print "<br /><p>Customer: $customerName</p>";
    print "<br /><p>Message: $reminderMessage</p>";
    print "<br /><p>Order Status that will trigger email: $statusName</p>";
    print "<br /><p>Email Recipients: $employeeNames</p>";
    if ($isEdit) {
        print "<br /><p>Please close this tab and refresh the order to see the updated repeat reminder.</p>";
    } else {
        print "<br /><p>Please close this tab and refresh the order to see the new repeat reminder or to create another repeat reminder.</p>";
    }
} elseif ($action != "delete") {
    if ($action=="create") {
        print "<h3>Creating a New Repeat Reminder</h3>";
    } elseif ($action=="edit") {
        print "<h3>Updating repeat reminder for Customer $customerName</h3>";
    } else {
        print "<h3>Repeat Reminder</h3>";
    }
    if ($requiresMessage) {
        print "<p style='color:red'>Message Required</p>";
    }
    if ($requiresRecipients) {
        print "<p style='color:red'>Email Recipients Required</p>";
    }
    print "<form name='repeat_reminder' action='updateRepeatReminders.php' method='POST'>"; ## Beginning of Form
    print "<input type='hidden' id='action' name='action' value='confirmation'>"; // this sets the action so that the page will display a confirmation after form submit rather than showing the form again
    print "<input type='hidden' id='repeat_id' name='repeat_id' value=$repeatID>";
    print renderTextArea(TRUE, "reminder_message", $reminderMessage, "Reminder Message");
    $sql="SELECT customer_id, `name` FROM customers ORDER BY `name`";
    $rs=mysqli_query($db,$sql);
    print "<div class='$customerClass'>";
    print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs);
    print "</div>";
    ## bdoss I only want statuses that appear in the order_status_update table as a new_status, otherwise the message may never be sent if it's not a status the updateOrderStatus() touches
    $sql="SELECT DISTINCT status_id, status_name FROM order_status ORDER BY status_name";
    $rs=mysqli_query($db,$sql);
    print renderSelect(TRUE,"reminder_status",$reminderStatus,"Reminder Status","N",$rs);
    ## CHECKBOXES
    print "<div id='name_container'><p style='color: #4a535e'>Select who should receive the reminder</p>";
    print "<input type='text' class='name_search' id='name_search' name='name_search'><div id='checkbox_container' placeholder='Search by name'>";
    $sql="SELECT employee_id, CONCAT(first_name, ' ', last_name) AS employee_name FROM employees WHERE coalesce(inactive,0) = 0 AND employee_email IS NOT NULL ORDER BY employee_name";
    list($rs,$err)=runIQuery($db,$sql);
    foreach($rs as $data) {
        $employeeID=$data['employee_id'];
        $employeeName=$data['employee_name'];
        in_array($employeeID,$reminderRecipients) ? $employeeChecked = "checked" : $employeeChecked = "";
        print "<div class='names' data-name='$employeeName'><input type='checkbox' value='$employeeID' data-name='$employeeName' name='employees[]' id='$employeeID' $employeeChecked>$employeeName <br /></div>";
    }
    print "</div><p id='selected'>Selected Employees:</p></div>";
    print renderButton("Submit","green","document.repeat_reminder.submit();");
    print "</form>"; # #End of Form

}
print renderClosePanel();
include('footer.php');
?>


<style>
    #checkbox_container {
        border:2px solid #ccc; 
        width:300px; 
        height: 150px; 
        overflow-y: scroll; 
    }

    .showCustomer {
		display: block;
	}

	.hideCustomer {
		display: none;
	}

    #name_search {
        width: 300px;
        border: solid 2px #ccc;
        padding: 0px;
        margin: 0px;
    }

    #name_container {
        display: flex;
        flex-direction: column;
    }
    
</style>

<script>
    // basic client-side form validation that will hide submit button on page load until text is entered 
    const textBox = document.getElementById('reminder_message');
    const submitButton = document.getElementsByClassName('btn');
    const names = document.getElementsByClassName('names');
    const search = document.getElementById('name_search');
    const selected = document.getElementById('selected');

    // when the page loads, display the selected employees
    $("input[type='checkbox']").each(function() {
        if (this.checked) {
            $(selected).append(`<p id="name${this.value}">${this.dataset.name}</p>`);
        } 
    });

    // bdoss 10/10/22 this updates checkboxes displayed depending on what is typed in the searchbox
    $("input[type='text']").on('input', function() {
        console.log(search.value);
        let searchValue = search.value;
        Array.from(names).forEach((name) => {
            let string = name.dataset.name;
            if (!(string.toLowerCase().includes(searchValue.toLowerCase()))) {
                $(name).addClass("hide");
            } else {
                $(name).removeClass("hide");
            }
        })
    });

    // bdoss display selected people 
    $("input[type='checkbox']").change(function() {
        if (this.checked) {
            $(selected).append(`<p id="name${this.value}">${this.dataset.name}</p>`);
        } else {
            $(`#name${this.value}`).remove();
        }
    });

    //bdoss added search to selects
    //jQuery(".chosen-select").chosen({'width':'100%','white-space':'nowrap'}); // weld's chosen library doesn't work

    // bdoss hide submit button until something is typed into message text box
    if (!textBox.value) {
        $('.btn.green').addClass("hide");
    }

    function disableButton() {
        if (textBox.value.length > 0) {
            $(submitButton).removeClass("hide");
            textBox.removeEventListener("input", disableButton);
        }
    }

    textBox.addEventListener("input", disableButton);
    
</script>
