<?php

include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$reminderMessage="";
$reminderStatus=1;
$reminderRecipients=[];
$reminderID=0;
$action="";
$customer=0;
$order=0;
$repeat=0;
$customerName="";
$disableRepeat=0;
$isEdit = 0;
$canSubmit=0;
$requiresMessage=0;
$requiresRecipients=0;


if (isset($_GET['action'])) { // setting the action goes outside of get id because if action is create, it won't have an id yet
    $action=$_GET['action'];
} elseif (isset($_POST['action'])) {
    $action=$_POST['action'];
}

if (isset($_GET['id'])) {
    $reminderID = $_GET['id'];

    if ($action == "delete") {  ## When "deleting" a reminder, the sent_on column is given a datetime
        $sql="UPDATE order_reminders SET sent_on=now() WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));
    } elseif ($action == "edit") {
        $disableRepeat=1;
        $sql="SELECT order_id, order_status, repeat_reminder, reminder_message, customer FROM order_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));
        foreach($rs as $data) {
            $reminderMessage=$data['reminder_message'];
            $reminderStatus=$data['order_status'];
            $repeat=$data['repeat_reminder'];
            $order=$data['order_id'];
            $customer=$data['customer'];
        }
        $sql="SELECT employee_id FROM employee_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));
        foreach($rs as $data) {
            $employee=$data['employee_id'];
            array_push($reminderRecipients,$employee); 
        }
    } 
       
} elseif ($action == "repeat") { // for order reminders that are created based off an existing repeat reminder when a new order is created
    $customer=$_GET['customer'];
    $order=$_GET['order'];
    $reminderStatus=$_GET['status'];
    $repeatID=$_GET['message']; // we'll use the repeatID that's being copied to get the message
    $employeesReference=$_GET['employees']; // this is the reminderID of the last order to use this repeat message, we'll use it to see whom the email was sent to

    $sql="SELECT reminder_message FROM repeat_reminders WHERE repeat_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$repeatID));
    $reminderMessage=$rs[0][0];

    $sql="INSERT INTO order_reminders (order_id,order_status,customer,repeat_reminder,reminder_message,created_on)
        VALUES (?,?,?,1,?,now())";
    list($rs,$err)=runIQuery($db,$sql,array("iiis",$order,$reminderStatus,$customer,$reminderMessage));

    ## get the id of last query
    //$sql="SELECT LAST_INSERT_ID()"; //bdoss this was returning a bogus value for some reason
    $sql="SELECT MAX(reminder_id) FROM order_reminders WHERE order_id=? AND order_status=? AND customer=? AND reminder_message=?";
    list($rs,$err)=runIQuery($db,$sql,array("iiis",$order,$reminderStatus,$customer,$reminderMessage));
    $reminderID=$rs[0][0];

    ##bdoss select employees to send the reminder to
    $sql="SELECT employee_id FROM employee_reminders WHERE reminder_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$employeesReference));
    foreach ($rs as $data) {
        $employeeID=$data['employee_id'];
        $sql="INSERT INTO employee_reminders (reminder_id, employee_id) 
            VALUES (?,?)";
        list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$employeeID));
    }

} elseif ($action == "create") {
    $customer=$_GET['customer'];
    $order=$_GET['order'];

    $sql="SELECT `name` FROM customers WHERE customer_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
    $customerName=$rs[0][0];
} elseif (empty($_POST['reminder_message']) || (!isset($_POST['employees']))) { // if the form isn't filled out completely, save what they did fill out and tell them what fields they're missing
    $action = "tryagain"; // just have to get rid of the confirmation action so the form will appear
    if (empty($_POST['reminder_message'])) {
        $requiresMessage = 1;
    }
    if (empty($_POST['employees'])) {
        $requiresRecipients = 1;
    }
    $order=$_POST['order'];
    $customer=$_POST['customer'];
    if (isset($_POST['reminder_status'])) {
      $reminderStatus=$_POST['reminder_status'];  
    }
    if (isset($_POST['backup_repeat']) && $_POST['backup_repeat'] == 1) {
        $repeat = 1;
        $isEdit = 1;
    } elseif (isset($_POST['repeat_reminder']) && $_POST['repeat_reminder'] == 1) {
        $repeat = 1;
    }
    if (isset($_POST['reminder_message'])) {
        $reminderMessage=$_POST['reminder_message'];
    }
    if (isset($_POST['employees'])) {
        $reminderRecipients = $_POST['employees'];
    }
    if (isset($_POST['disable_status']) && $_POST['disable_status'] == 1) {
        $disableRepeat = 1;
    }
} elseif (isset($_POST['reminder_message'])) {
    ## this prepares the sql statements after the form has been filled out
    $reminderMessage=$_POST['reminder_message'];
    $reminderStatus=$_POST['reminder_status'];
    $reminderRecipients=$_POST['employees'];
    $reminderID=$_POST['reminder_id'];
    $order=$_POST['order'];
    $customer=$_POST['customer']; // storing the customer to display their name in the confirmation
    if (isset($_POST['repeat_reminder'])) {
        $repeat = 1;
    } else {
        $repeat = 0;
    }
    if (isset($_POST['backup_repeat'])) {
        $repeat = $_POST['backup_repeat'];
    }

    if ($reminderID) { // if updating an existing reminder
        $isEdit=1; // this will trigger the confirmation saying it's an update rather than new reminder
        $sql = "UPDATE order_reminders SET order_status=?, repeat_reminder=?, reminder_message=?, created_on=now() WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("iisi",$reminderStatus,$repeat,$reminderMessage,$reminderID));
        
        ## rather than adding or subtracting employees, this deletes all employees for that reminder id and adds selected employees back in
        $sql="DELETE FROM employee_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i", $reminderID));
        foreach($reminderRecipients as $recipient) {
        $sql="INSERT INTO employee_reminders (reminder_id, employee_id)
                    VALUES (?,?)";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
        }

    } elseif ($order) { // if creating a new reminder from an order
        
        if ($repeat) { // if creating a new repeat reminder from editOrders, create a dummy order so that if the individual reminder for the order is edited, the repeat reminder data will still be preserved
            $sql="INSERT INTO order_reminders (order_id,order_status,customer,repeat_reminder,reminder_message,created_on,sent_on)
            VALUES (0,?,?,?,?,now(),now())";
            list($rs,$err)=runIQuery($db,$sql,array("iiis",$reminderStatus,$customer,$repeat,$reminderMessage));

            ## get the id of last query
            //$sql="SELECT LAST_INSERT_ID()"; //bdoss this was returning a bogus value for some reason
            $sql="SELECT MAX(reminder_id) FROM order_reminders WHERE order_status=? AND customer=? AND reminder_message=?";
            list($rs,$err)=runIQuery($db,$sql,array("iis",$reminderStatus,$customer,$reminderMessage));
            $reminderID=$rs[0][0];
            ## insert employees into employee_reminders table
            foreach($reminderRecipients as $recipient) {
                $sql="INSERT INTO employee_reminders (reminder_id, employee_id)
                    VALUES (?,?)";
                list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
            }
        }
        
        $sql="INSERT INTO order_reminders (order_id,order_status,customer,repeat_reminder,reminder_message,created_on)
        VALUES (?,?,?,?,?,now())";
        list($rs,$err)=runIQuery($db,$sql,array("iiiis",$order,$reminderStatus,$customer,$repeat,$reminderMessage));

        ## get the id of last query
        //$sql="SELECT LAST_INSERT_ID()"; //bdoss this was returning a bogus value for some reason
        $sql="SELECT MAX(reminder_id) FROM order_reminders WHERE order_id=? AND order_status=? AND customer=? AND reminder_message=?";
        list($rs,$err)=runIQuery($db,$sql,array("iiis",$order,$reminderStatus,$customer,$reminderMessage));
        $reminderID=$rs[0][0];
        ## insert employees into employee_reminders table
        foreach($reminderRecipients as $recipient) {
            $sql="INSERT INTO employee_reminders (reminder_id, employee_id)
                VALUES (?,?)";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
        }

        ## if it's being added as repeat reminder, add it to the repeat_reminders table too
        if ($repeat) {
            $sql="INSERT INTO repeat_reminders (customer,order_status,reminder_message)
                VALUES (?,?,?)";
            list($rs,$err)=runIQuery($db,$sql,array("iis",$customer,$reminderStatus,$reminderMessage));
        }
    }
    ## Getting info to display in the confirmation that appears after the form is submitted
    $customerName="";
    $sql="SELECT `name` FROM customers WHERE customer_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
    if ($rs) {
        $customerName=$rs[0][0];
    }
    $statusName="";
    $sql="SELECT status_name FROM order_status WHERE status_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$reminderStatus));
    if ($rs) {
        $statusName=$rs[0][0];
    }
    ## get email recipient names for displaying confirmation after form submit
    $employeeNames="";
    $sql="SELECT first_name, last_name from employees INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id WHERE employee_reminders.reminder_id=?";
    list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
    foreach($employee_rs as $employee_data) {
        $employeeNames.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
    }
} 

print renderPanel("Order Reminder");

if ($action == "confirmation") { //either display a confirmation message or a form (or nothing if it's deleting or creating a copied reminder)
    if ($isEdit) {
        print "<h3>Reminder Updated</h3>";
    } else {
        print "<h3>Reminder Created</h3>";
    }
    print "<br /><p>Order: $order</p>";
    print "<br /><p>Customer: $customerName</p>";
    print "<br /><p>Message: $reminderMessage</p>";
    print "<br /><p>Order Status that will trigger email: $statusName</p>";
    print "<br /><p>Email Recipients: $employeeNames</p>";
    if ($isEdit) {
        print "<br /><p>Please close this tab and refresh the order to see the updated reminder.</p>";
    } else {
        print "<br /><p>Please close this tab and refresh the order to see the new reminder or to create another reminder.</p>";
    }
    
} elseif ($action != "delete" || $action != "repeat") { // no need to put the form together for delete and copying repeat reminders as the user will not see it anyway
    if ($action=="create") {
        print "<h3>Creating a new reminder for Order $order and Customer $customerName</h3>";
    } elseif ($action=="edit") {
        print "<h3>Updating the reminder for Order $order</h3>";
    } else {
        print "<h3>Order Reminder</h3>";
    }
    
    if ($requiresMessage) {
        print "<p style='color:red'>Message Required</p>";
    }
    if ($requiresRecipients) {
        print "<p style='color:red'>Email Recipients Required</p>";
    }
    print "<form name='order_reminder_update' action='updateOrderReminders.php' method='POST'>"; ## Beginning of Form
    print "<input type='hidden' id='action' name='action' value='confirmation'>"; // this sets the action so that the page will display a confirmation after form submit rather than showing the form again
    print "<input type='hidden' id='reminder_id' name='reminder_id' value=$reminderID>";
    print "<input type='hidden' id='order' name='order' value=$order>";
    print "<input type='hidden' id='customer' name='customer' value=$customer>";
    print "<input type='hidden' id='disable_status' name='disable_status' value='$disableRepeat'>"; //exists to save whether or not the order was edited or new, and if they don't fill out the form properly, the repeat checkbox will still display properly
    print renderTextArea(TRUE, "reminder_message", $reminderMessage, "Reminder Message");
    $sql="SELECT DISTINCT status_id, status_name FROM order_status ORDER BY status_name";
    $rs=mysqli_query($db,$sql);
    print renderSelect(TRUE,"reminder_status",$reminderStatus,"Reminder Status","N",$rs);
    ## CHECKBOXES
    print "<div id='name_container'><p style='color: #4a535e'>Select who should receive the reminder</p>";
    print "<input type='text' class='name_search' id='name_search' name='name_search'><div id='checkbox_container' placeholder='Search by name'>";
    $sql="SELECT employee_id, CONCAT(first_name, ' ', last_name) AS employee_name FROM employees WHERE coalesce(inactive,0) = 0 AND employee_email IS NOT NULL ORDER BY employee_name";
    $rs=mysqli_query($db,$sql);
    foreach($rs as $data) {
        $employeeID=$data['employee_id'];
        $employeeName=$data['employee_name'];
        in_array($employeeID,$reminderRecipients) ? $employeeChecked = "checked" : $employeeChecked = "";
        print "<div class='names' data-name='$employeeName'><input type='checkbox' value='$employeeID' data-name='$employeeName' name='employees[]' id='$employeeID' class='employees' $employeeChecked >$employeeName <br /></div>";
    }
    print "</div><p id='selected'>Selected Employees:</p></div>";
    $repeat == 1 ? $repeatChecked = "checked" : $repeatChecked = "";
    $disableRepeat ? $disable = "disabled" : $disable = "";
    print "<input type='checkbox' name='repeat_reminder' id='repeat_reminder' value='$repeat' $repeatChecked $disable> Check for repeat reminders <br />";
    if ($disableRepeat) {
        print "<p style='color:red' >*Changes to the repeat reminder can't be made once a reminder is created.  Any changes made here will only affect this order. <br />To make changes to repeat reminders for future orders, <a href='automatedReminders.php' target='_blank'> please follow this link.</a></p> <br />";
        print "<input type='hidden' id='backup_repeat' name='backup_repeat' value='$repeat'>"; // disabled checkboxes will uncheck themselves; this will save the value of $repeat as backup
    }
    print renderButton("Submit","green","document.order_reminder_update.submit();");
    print "</form>"; ## End of Form
}

print renderClosePanel();
include('footer.php');
?>

<style>
    #checkbox_container {
        border:2px solid #ccc; 
        width:300px; 
        height: 150px; 
        overflow-y: scroll; 
        background-color: white;
    }

    .hide {
        display: none;
    }

    #name_search {
        width: 300px;
        border: solid 2px #ccc;
        padding: 0px;
        margin: 0px;
    }

    #name_container {
        display: flex;
        flex-direction: column;
    }
</style>

<script>
    // basic client-side form validation that will hide submit button on page load until text is entered 
    const textBox = document.getElementById('reminder_message');
    const submitButton = document.getElementsByClassName('btn');
    const names = document.getElementsByClassName('names');
    const search = document.getElementById('name_search');
    const selected = document.getElementById('selected');

    function page_init() {
                // when the page loads, display the selected employees
        $(".employees").each(function() {
        if (this.checked) {
            $(selected).append(`<p id="name${this.value}">${this.dataset.name}</p>`);
        } 
        });
    }



    // bdoss 10/10/22 this updates checkboxes displayed depending on what is typed in the searchbox
    $("input[type='text']").on('input', function() {
        console.log(search.value);
        let searchValue = search.value;
        Array.from(names).forEach((name) => {
            let string = name.dataset.name;
            if (!(string.toLowerCase().includes(searchValue.toLowerCase()))) {
                $(name).addClass("hide");
            } else {
                $(name).removeClass("hide");
            }
        })
    });

    // bdoss display selected people 
    $(".employees").change(function() {
        if (this.checked) {
            console.log(this.parentElement.dataset.name);
            $(selected).append(`<p id="name${this.value}">${this.dataset.name}</p>`);
        } else {
            $(`#name${this.value}`).remove();
        }
    });

    //bdoss added search to selects
    //jQuery(".chosen-select").chosen({'width':'100%','white-space':'nowrap'});

    if (!textBox.value) {
        $('.btn.green').addClass("hide");
    }

    function disableButton() {
        if (textBox.value.length > 0) {
            $(submitButton).removeClass("hide");
            textBox.removeEventListener("input", disableButton);
        }
    }

    textBox.addEventListener("input", disableButton);

</script>
