<?php
## updateOrderFinalAPI.php
## finish up the order after all of the lines have been updated
include('dbConnection.php');
include('functions.php');
include('security.php');
$orderID=$_POST['id'];
$sql="update customers set quote_markup=1 where quote_markup=0";
list($rs,$err)=runIQuery($db,$sql);
$sql="select coalesce(separate_shipping,0) as shipping, o.status, mileage, folder_number, po_number from orders o, customers c where order_id=? and  o.customer_id=c.customer_id ";
list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
$data=$rs[0];
$separateShipping=$data[0];
$status=$data[1];
$mileage=$data[2];
$folder=$data['folder_number'];
$poNumber=$data['po_number'];
 $sql="select hourly_rate from operations o where operation_name='Shipping' ";
 list($rs,$err)=runIQuery($db,$sql);
 $data=$rs[0];
 $mileage=$mileage*$data['hourly_rate'];
#if ($status != 10) {
#	$separateShipping=0;
#}
$sql="select quote_markup from orders o, customers c where o.customer_id=c.customer_id and order_id=? ";
list($ors,$err)=runIQuery($db,$sql,array("s",$orderID));
$odata=$ors[0];
$markup=$odata[0];
if (! $markup) {
	$markup=1;
}
## if no manual shipping, then get mileage from customer
$sql="select mileage from orders, customer_shiptos where order_id=? and orders.ship_name=customer_shiptos.ship_name and orders.customer_id=customer_shiptos.customer_id ";
list($ors,$err)=runIQuery($db,$sql,array("s",$orderID));
if (count($ors)) {
	$odata=$ors[0];
	$mileage=$odata['mileage'];
}
date_default_timezone_set('America/Detroit');
if (isset($_POST['id'])) {
    ## End preliminary Quote changes
    $experimental=0;	
    $vendor=0;
    $outsourceWeldmentVendor=0;
    $outsourceWeldmentOrder =0;
		if ($markup <> 1 and $markup > 0) {
			$sql="update order_lines set price= price * $markup where order_id=? and item_id not in  ('PPF','DELIVERY CHARGE') ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
		}
		if (! $separateShipping) {
			$sql="select count(*) from order_lines where order_id=? and price > 0";
			list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
			if (count($rs)>0) {
				$sql="select sum(quantity) from order_lines where order_id=? and item_id not in  ('PPF','DELIVERY CHARGE') ";
				list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
				$data=$rs[0];
				$totq=$data[0];
				if ($totq > 0 and $mileage > 0 ) {
					$addship=$mileage / $totq;
					if ($experimental) {
						$sql="update order_lines set experimental_price = CEILING((experimental_price + $addship)*4)/4 where order_id=? and experimental_price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') ";
						list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
					} else {
						if (! $inItems) {
							$sql="update order_lines set price = CEILING((price + $addship)*4)/4 where order_id=? and price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') ";			
							list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
						} else {
							$priceitems="";
							$comma="";
							foreach ($itemList as $itm) {
								$priceitems.=$comma;
								$priceitems.="'";
								$priceitems.=$itm;
								$priceitems.="'";
								$comma=",";
							}
							$sql="update order_lines set price = CEILING((price + $addship)*4)/4 where order_id=? and price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') and item_id not in ($priceitems) ";			
							list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
						}
					}
				}
			}
		} else {
			$sql="select line_id from order_lines where item_id='DELIVERY CHARGE' and order_id=?";
			list($drs,$err)=runIQuery($db,$sql,array("i",$orderID));
			if (count($drs)>0) {
				$deliveryLine=$drs[0][0];
				$sql="update order_lines set quantity=1, price=? where line_id=?";
				list($updrs,$err)=runIQuery($db,$sql,array("di",$mileage,$deliveryLine));
			} else {
				## 119 is non-laser
				$sql="insert into order_lines (order_id, item_id, item_description, quantity, price, cost, due_date, material) values (?, 'DELIVERY CHARGE', '', 1, ?, 0, ?, 119) ";
				list($updrs,$err)=runIQuery($db,$sql,array("ids",$orderID,$mileage,$dt));
			}
		}
		## packaging
		$sql="select hourly_rate from operations where operation_name='Packaging' ";
		list($rs,$err)=runIQuery($db,$sql);
		if (count($rs)>0) {
			$data=$rs[0];
			$packaging=$data['hourly_rate'];
			$sql="select count(*) from order_lines where order_id=? and price > 0";
			list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
			if (count($rs)>0) {
				if ($markup != 1) {
					$sql="update order_lines set price=price * $markup where order_id=? and item_id not in  ('PPF','DELIVERY CHARGE') ";
				}
				$sql="select sum(quantity) from order_lines where order_id=? and item_id not in  ('PPF','DELIVERY CHARGE')";
				list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
				$data=$rs[0];
				$totq=$data[0];
				if ($totq > 0 and $packaging > 0 ) {
					$addship=$packaging / $totq;
					if ($experimental) {
						$sql="update order_lines set experimental_price = CEILING((experimental_price + $addship)*4)/4 where order_id=? and experimental_price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') ";
						list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
					} else {
						if (! $inItems) {
							$sql="update order_lines set price = CEILING((price + $addship)*4)/4 where order_id=? and price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') ";			
							list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
						} else {
							$priceitems="";
							$comma="";
							foreach ($itemList as $itm) {
								$priceitems.=$comma;
								$priceitems.="'";
								$priceitems.=$itm;
								$priceitems.="'";
								$comma=",";
							}
							$sql="update order_lines set price = CEILING((price + $addship)*4)/4 where order_id=? and price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') and item_id not in ($priceitems) ";			
							list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
						}
					}
				}
			}
			$sql="select * from production_results where job_id=? and operation_id=93";
			list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
			if (count($rs)==0) {
				## 102 is Nate Ludtke hard coded
				## 93 is Packaging operation
				$sql="insert into production_results (job_id, item_name, employee_id, result_date, quantity_good, shift_id, step_complete, operation_id, setup_time, scrap, defect_code, minutes) ";
				$sql.=" values (?, 'ALL','102', now(), 0, 1, 1, 93, 0, 0, 0, 1) ";
				list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
			}
		}
		if ($experimental) {
			$sql="update order_lines set experimental_price = CEILING((experimental_price)*4)/4 where order_id=? and experimental_price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
		} else {
			if (! $inItems) {
				$sql="update order_lines set price = CEILING((price)*4)/4 where order_id=? and price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') ";			
				list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
			} else {
				$priceitems="";
				$comma="";
				foreach ($itemList as $itm) {
					$priceitems.=$comma;
					$priceitems.="'";
					$priceitems.=$itm;
					$priceitems.="'";
					$comma=",";
				}
				$sql="update order_lines set price = CEILING((price + $addship)*4)/4 where order_id=? and price > 0 and item_id not in  ('PPF','DELIVERY CHARGE') and item_id not in ($priceitems) ";			
				list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
			}
		}
		$sql="select salesperson_id from site_admins a, salespeople s where a.user_id=? and a.full_name = s.full_name ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
		if (count($rs)>0) {
			$salesperson_id=$rs[0][0];
			$sql="update orders set salesperson_id=? where order_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$salesperson_id,$orderID));
		}
		if ($vendor == 36) {
			$id=$orderID;
			$plugs=0;
			include('paintCalculationSub.php');			
		}
		if ($outsourceWeldmentVendor > 0) {
			## build the osw_bom
			## get all lines that are outsource weldment material 192
			## find all lines that have that item name in the description and have weldment op 62 checked
			$sql="select line_id, item_id, quantity from order_lines where order_id=? and  material=192 ";
			list($wrs,$err)=runIQuery($db,$sql,array("i",$orderID));
			foreach ($wrs as $wdata) {
				$parentLine=$wdata['line_id'];
				$parentPart=$wdata['item_id'];
				$parentQuantity=$wdata['quantity'];
				$lp="%".$parentPart."%";
				$sql="select distinct l.line_id, item_id, quantity from order_lines l, order_line_operations olo where order_id=? and l.line_id=olo.line_id and operation_id in(62,71) and item_description like ? order by l.line_id";
				list($crs,$err)=runIQuery($db,$sql,array("is",$orderID,$lp));
				foreach ($crs as $cdata) {
					$childLine=$cdata['line_id'];
					$childPart=$cdata['item_id'];
					$childQuantity=$cdata['quantity'];
					$sql="insert into osw_bom (parent_order, parent_line, parent_part, parent_quantity, child_line, child_part, child_quantity) values (?, ?, ?, ?, ?, ?, ?) ";
					list($updrs,$err)=runIQuery($db,$sql,array("iisiisi",$orderID,$parentLine,$parentPart,$parentQuantity,$childLine,$childPart,$childQuantity));
					$oswBOM=$updrs[0]['id'];
					## if no oswSO made, need to make it  - set the customer to Preferred Machine (562) and the vendor to oswvendor, and the status is pending review
					$sql="select salesperson_id from site_admins a, salespeople s where a.user_id=? and a.full_name = s.full_name ";
					$salesperson_id=0;
					list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
					if (count($rs)>0) {
						$salesperson_id=$rs[0][0];
					}
					if (! $outsourceWeldmentOrder) {
						$sql="insert into orders (customer_id, date_order, date_due, status, ship_name, ship_address, ship_city, ship_state, ship_zip, po_number, salesperson_id, notes_to_self, email, phone, folder_number, order_type, order_vendor, consuela, date_uploaded) ";
						$sql.=" values (562, now(), $dt, $orderStatus, 'Preferred Machine-OSW', '6673 Pine Ridge CT', 'Jenison', 'MI', '49428', '$poNumber', $salesperson_id, 'From SO $orderID', 'ap@preferredmachinellc.com', '', '$orderID', $orderType, $outsourceWeldmentVendor, 1, now()) ";
						list($irs,$err)=runIQuery($db,$sql);
						$outsourceWeldmentOrder=$irs[0]['id'];
						$sql="update orders set notes_to_self=concat(notes_to_self,' ','Related OSW SO $outsourceWeldmentOrder') where order_id=?";
						list($updrs,$err)=runIQuery($db,$sql,array("i",$orderID));
					} else {
						$sql="update osw_bom set child_order=? where osw_bom_id=?";
						list($updrs,$err)=runIQuery($db,$sql,array("ii",$outsourceWeldmentOrder,$oswBOM));
					}
					## update the line on the initial SO to move them to the oswSO
					$sql="update order_lines set order_id=? where line_id=?";
					list($updrs,$err)=runIQuery($db,$sql,array("ii",$outsourceWeldmentOrder,$childLine));
					$sql="delete from order_line_operations where line_id=? and operation_id=62";
					list($updrs,$err)=runIQuery($db,$sql,array("i",$childLine));	
				}
			}
		}
	}
} 
$sql="insert into order_activity (order_id, status, activity_date, ip_address, who, email_address, activity) values (?, ?, now(), ?, ?, ?, 'FINAL API')";
list($rs,$err)=runIQuery($db,$sql,array("iisss",$orderID,$status,$ip,$userEmail,"n/a"));
print "PROCESSED";