<?php
include('dbConnection.php');
include('security.php');
include('functions.php');

$employee=$_POST['id'];
$adjustment=$_POST['adjustment'];
$reason=$_POST['text'];
$date=$_POST['date']; 
$date=formatDateWebtoDB($date);

## Get manager info
$sql="SELECT `lead`, lead_email, `user_id` FROM site_admins 
INNER JOIN departments ON site_admins.email=departments.lead_email
INNER JOIN employees ON departments.department_id=employees.department_id 
WHERE employee_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$employee));
if (count($rs)>0) {
	$data=$rs[0];
	$managerName=$data["lead"];
	$managerEmail=$data["lead_email"];
	$managerAdminId=$data["user_id"];
}

## Get employee info for rendering pdf and update points in employee table/ insert point adjustment into point log
## Remember that manager id comes from the site_admins table and not the employees table, like it does in machine's system
$sql="select points, last_name, first_name, employee_email from employees where employee_id = ?";
list($rs, $err)=runIQuery($db,$sql,array("i", $employee));
if (count($rs)>0) {
	$data=$rs[0];
	$points=$data["points"];
	$employeeName = $data['first_name'] . " " . $data['last_name'];
	$employeeEmail=$data['employee_email'];

	// Update manager info if manager is employee
	if (strtolower($managerEmail)==strtolower($employeeEmail)) {
		$managerAdminId=102;
		$managerName="Cory Wind";
	}

	if($adjustment>0) {
		$points+=$adjustment;
	} else {
		$points-=abs($adjustment);
	}
	$sql="update employees set points=? where employee_id=?";
	list($rs, $err)=runIQuery($db,$sql,array("di", $points, $employee));
	$sql="insert into point_log (employee_id, reason, points_adjusted, points_remaining, user_id, manager_id, reason_date, activity_date) ";
	$sql.="values (?, ?, ?, ?, ?, ?, ?, now())";
	list($rs, $err)=runIQuery($db,$sql,array("isddiis",$employee,$reason,$adjustment,$points,$userID,$managerAdminId,$date));
	$id=$rs[0]['id'];
}

include('sendPointsEmail.php');

print "UPDATED\n";
print "Email sent to $employeeName and $managerName";

?>