<?php

include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$reminderMessage="";
$reminderID=0;
$reminderRecipients=[];
$reminderID=0;
$action="";
$isEdit=0;
$requiresMessage=0;
$requiresRecipients=0;
$date = date("m/d/Y");

print renderPanel("Date Reminder");

if (isset($_GET['action'])) { // setting the action goes outside of get id because if action is create, it won't have an id yet
    $action=$_GET['action'];
} elseif (isset($_POST['action'])) {
    $action=$_POST['action'];
}

if (isset($_GET['id'])) {  // first get id if it's an existing reminder, then get what we're supposed to do with it: delete or edit
    $reminderID=$_GET['id']; //ID will come from GET Request if it's coming from automatedReminders.php, so edits or deletes

    if ($action == "delete") { // if deleting the repeat reminder
        $sql = "DELETE FROM date_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));
    } elseif ($action == "edit") { // if editing an existing repeat reminder
        $sql="SELECT * FROM date_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array('i',$reminderID));
        foreach($rs as $data) {
            $reminderMessage=$data['reminder_message'];
            $date=formatDateDBToWeb($data['send_on']);
        }

        $sql="SELECT employee_id FROM employee_date_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));
        foreach($rs as $data) {
            $employee=$data['employee_id'];
            array_push($reminderRecipients,$employee); 
        }
    }
}
if ($action=="confirmation" && (empty($_POST['reminder_message']) || (!isset($_POST['employees'])))) { ## form was not filled out properly
    $action = "tryagain"; 
    if (empty($_POST['reminder_message'])) {
        $requiresMessage = 1;
    }
    if (empty($_POST['employees'])) {
        $requiresRecipients = 1;
    }
    if (isset($_POST['reminder_message'])) {
        $reminderMessage=$_POST['reminder_message'];
    }
    if (isset($_POST['employees'])) {
        $reminderRecipients = $_POST['employees'];
    }
    if (isset($_POST['date'])) {
        $date=$_POST['date'];
    }
    if (isset($_POST['reminder_id'])) {
        $reminderID=$_POST['reminder_id'];
    }
} elseif ($action == "confirmation") {
    if (isset($_POST['date'])) {
        $date=formatDateWebtoDB($_POST['date']);
    }
    if (isset($_POST['reminder_message'])) {
        $reminderMessage=$_POST['reminder_message'];
    }
    $reminderRecipients=$_POST['employees'];

    ##TODO use above info to put together the insert
    if (isset($_POST['reminder_id'])) {
        $reminderID=$_POST['reminder_id'];
    }
 
    if ($reminderID > 0) { ## it's an update
        $isEdit=1;
        $sql="UPDATE date_reminders SET reminder_message=?, send_on=?, created_on=now() WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("ssi",$reminderMessage,$date,$reminderID));

        ## rather than adding or subtracting employees, this deletes all employees for that reminder id and adds selected employees back in
        $sql="DELETE FROM employee_date_reminders WHERE reminder_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i", $reminderID));
        foreach($reminderRecipients as $recipient) {
        $sql="INSERT INTO employee_date_reminders (reminder_id, employee_id)
                    VALUES (?,?)";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
        }

        ## get email recipient names for displaying confirmation after form submit
       $employeeNames="";
       $sql="SELECT first_name, last_name from employees INNER JOIN employee_date_reminders ON employees.employee_id=employee_date_reminders.employee_id WHERE employee_date_reminders.reminder_id=?";
       list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
       foreach($employee_rs as $employee_data) {
           $employeeNames.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
       }

    } else { ## new insert
        $sql="INSERT INTO date_reminders (reminder_message,send_on,created_on)
        VALUES (?,?,now())";
       list($rs,$err)=runIQuery($db,$sql,array("ss",$reminderMessage,$date));
   
       ## get the id of last query
       $sql="SELECT MAX(reminder_id) FROM date_reminders WHERE reminder_message=?";
       list($rs,$err)=runIQuery($db,$sql,array("s",$reminderMessage));
       $reminderID=$rs[0][0];
       ## insert employees into employee_date_reminders table
       foreach($reminderRecipients as $recipient) {
       $sql="INSERT INTO employee_date_reminders (reminder_id, employee_id)
               VALUES (?,?)";
       list($rs,$err)=runIQuery($db,$sql,array("ii",$reminderID,$recipient));
       }
         
       ## get email recipient names for displaying confirmation after form submit
       $employeeNames="";
       $sql="SELECT first_name, last_name from employees INNER JOIN employee_date_reminders ON employees.employee_id=employee_date_reminders.employee_id WHERE employee_date_reminders.reminder_id=?";
       list($employee_rs, $err)=runIQuery($db,$sql,array("i",$reminderID));
       foreach($employee_rs as $employee_data) {
           $employeeNames.=" " . $employee_data['first_name'] . " " . $employee_data['last_name'];
       }
    }
}
## above is functionality that deals with the submitted forms
## below here is the visual html seen by the user
if ($action == "confirmation") {
    $date=formatDateDBToWeb($date);
    if ($isEdit) {
        print "<h3>Date Reminder Updated</h3>";
    } else {
       print "<h3>Date Reminder Created</h3>"; 
    }
    print "<br /><p>Date When the Reminder Will Be Sent: $date</p>";
    print "<br /><p>Message: $reminderMessage</p>";
    print "<br /><p>Email Recipients: $employeeNames</p>";
    if ($isEdit) {
        print "<br /><p>Please close this tab and refresh the Automated Reminders page to see the updated reminder.</p>";
    } else {
        print "<br /><p>Please close this tab and refresh the Automated Reminders page to see the new reminder or to create another reminder.</p>";
    }
} elseif ($action == "create" || $action == "edit" || $action == "tryagain") {
    if ($action=="create") {
        print "<h3>Creating a New Date Reminder</h3>";
    } elseif ($action == "edit") {
        print "<h3>Updating Date Reminder</h3>";
    } elseif ($action == "tryagain") {
        print "<h3>Missing Fields - Please fill out all Date Reminder Fields</h3>";
        if ($requiresMessage) {
            print "<p style='color:red'>Message Required</p>";
        }
        if ($requiresRecipients) {
            print "<p style='color:red'>Email Recipients Required</p>";
        }
    }
    
    print "<form name='date_reminder' action='updateDateReminders.php' method='POST'>"; ## Beginning of Form
    print "<input type='hidden' id='action' name='action' value='confirmation'>"; // this sets the action so that the page will display a confirmation after form submit rather than showing the form again
    print "<input type='hidden' id='reminder_id' name='reminder_id' value=$reminderID>";
    print renderDateBox(TRUE,"date",$date,"Date to Send the Message");
    print renderTextArea(TRUE, "reminder_message", $reminderMessage, "Reminder Message");
    ## CHECKBOXES
    print "<div id='name_container'><p style='color: #4a535e'>Select who should receive the reminder</p>";
    print "<input type='text' class='name_search' id='name_search' name='name_search'><div id='checkbox_container' placeholder='Search by name'>";
    $sql="SELECT employee_id, CONCAT(first_name, ' ', last_name) AS employee_name FROM employees WHERE coalesce(inactive,0) = 0 AND employee_email IS NOT NULL ORDER BY employee_name";
    $rs=mysqli_query($db,$sql);
    foreach($rs as $data) {
        $employeeID=$data['employee_id'];
        $employeeName=$data['employee_name'];
        in_array($employeeID,$reminderRecipients) ? $employeeChecked = "checked" : $employeeChecked = "";
        print "<div class='names' data-name='$employeeName'><input type='checkbox' value='$employeeID' name='employees[]' data-name='$employeeName' id='$employeeID' class='employees' $employeeChecked>$employeeName <br /></div>";
    }
    print "</div><p id='selected'>Selected Employees:</p></div>";
    print renderButton("Submit","green","document.date_reminder.submit();");
    print "</form>"; # #End of Form
}
print renderClosePanel();
include('footer.php');
?>
<style>
    #checkbox_container {
        border:2px solid #ccc; 
        width:300px; 
        height: 150px; 
        overflow-y: scroll; 
        background-color: white;
    }

    .hide {
        display: none;
    }

    #name_search {
        width: 300px;
        border: solid 2px #ccc;
        padding: 0px;
        margin: 0px;
    }

    #name_container {
        display: flex;
        flex-direction: column;
    }
    
</style>
<script>
    // basic client-side form validation that will hide submit button on page load until text is entered 
    const textBox = document.getElementById('reminder_message');
    const submitButton = document.getElementsByClassName('btn');
    const names = document.getElementsByClassName('names');
    const search = document.getElementById('name_search');
    const selected = document.getElementById('selected');

    function page_init() {
        $('#date').datepicker();
                // when the page loads, display the selected employees
        $(".employees").each(function() {
        if (this.checked) {
            $(selected).append(`<p id="name${this.value}">${this.dataset.name}</p>`);
        } 
        });
    }

    // bdoss 10/10/22 this updates checkboxes displayed depending on what is typed in the searchbox
    $("input[type='text']").on('input', function() {
        let searchValue = search.value;
        Array.from(names).forEach((name) => {
            let string = name.dataset.name;
            if (!(string.toLowerCase().includes(searchValue.toLowerCase()))) {
                $(name).addClass("hide");
            } else {
                $(name).removeClass("hide");
            }
        })
    });

    // bdoss display selected people 
    $(".employees").change(function() {
        if (this.checked) {
            console.log(this.parentElement.dataset.name);
            $(selected).append(`<p id="name${this.value}">${this.dataset.name}</p>`);
        } else {
            $(`#name${this.value}`).remove();
        }
    });

    // bdoss hide submit button until something is typed into message text box
    if (!textBox.value) {
        $('.btn.green').addClass("hide");
    }

    function disableButton() {
        if (textBox.value.length > 0) {
            $(submitButton).removeClass("hide");
            textBox.removeEventListener("input", disableButton);
        }
    }

    textBox.addEventListener("input", disableButton);
    
</script>