<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Unload";
include('header.php');
print "<form autocomplete='off' name='editForm' id='editForm' action='unload.php' method='POST'>";
print "<table><tr><td valign='top'>";
print "Scan Here: <input type='text' name='scan' id='scan' onchange='scanLabel(this.value)'>";
print "&nbsp;";
print renderButton("GO","success");
print "&nbsp;";

$isTransfer=0;
$scan="";
## maybe check if the BOL has been signed or has left the dock.
if (isset($_GET['scan'])) {
	$scan=$_GET['scan'];
	$isTransfer=0;
	$isWeld=0;
	if (substr($scan,0,1) == "T") {
		$isTransfer=1;
		$scan=substr($scan,1);
	}
	if (substr($scan,0,1) == "W") {
		$isWeld=1;
		$scan=substr($scan,1);
	}
	$scan=preg_replace("/[^0-9]/","-",$scan);	
	list($slip,$skid)=explode("-",$scan);
	if ($isWeld) {
		$rs=array();
		## TODO get info from welds system
		## build $rs of $data be sure to spec weld = 1
		$sql="select bs.bol_id from bol_skids bs, skids s, bol where packing_slip_id=? and s.skid_id=bs.skid_id and bs.bol_id=bol.bol_id and weld=1 and assigned_to=? ";
		list($brs,$err)=runIQuery($db,$sql,array("ii",$slip,$userID));
		foreach ($brs as $bdata) {
			$bol=$bdata['bol_id'];
			$url="https://preferredwelderp1.com/getShipName.php?code=8383&pack=$slip&user=$userID&transfer=$isTransfer&bol=$bol";
			$resullts=file_get_contents($url);
			foreach (explode("\n",$results) as $result) {
				list($name,$address,$address2)=explode(",",$result);
				$data=array();
				$data['ship_name']=$name;
				$data['ship_address']=$address;
				$data['ship_address2']=$address2;
				$data['weld']=1;
				$rs[]=$data;
			}				
		}
	} else {
		if ($isTransfer) {
			$sql="select distinct t.ship_name, t.ship_address, '' as ship_address2, weld from transfers t, skids, bol_skids, bol where t.packing_slip_id=? 
			and t.packing_slip_id=skids.packing_slip_id  and skids.skid_id=bol_skids.skid_id and bol_skids.bol_id=bol.bol_id  and assigned_to = ?  
			and skid_type='TRANSFER' and weld=0";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$slip,$userID));
		}	else {
			$sql="select distinct ship_name, ship_address, ship_address2, 0 as weld from packing_slip where packing_slip.packing_slip_id=?  ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$slip));	
		}
	}
} else {
	$sql="select distinct t.ship_name, t.ship_address, '', weld as ship_address2, bol_skids.weld from transfers t, skids, bol_skids, bol where t.packing_slip_id=skids.packing_slip_id and coalesce(unload,'0000-00-00 00:00:00') >= curdate() and skids.skid_id=bol_skids.skid_id and bol_skids.bol_id=bol.bol_id  and assigned_to = ?  and skid_type='TRANSFER' ";
	$sql.=" and bol_skids.weld = 0 ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
	if (count($rs)>0) {		
		$sql="select distinct t.ship_name, t.ship_address, '' as ship_address2, bol_skids.weld from transfers t, skids, bol_skids, bol 
		where t.packing_slip_id=skids.packing_slip_id and coalesce(unload,'0000-00-00 00:00:00') = '0000-00-00 00:00:00' 
		and skids.skid_id=bol_skids.skid_id and bol_skids.bol_id=bol.bol_id  and assigned_to = ?  and skid_type='TRANSFER' ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
		if (count($rs)>0) {
			$isTransfer=1;
		} else {
			$sql="select distinct packing_slip.ship_name, packing_slip.ship_address, packing_slip.ship_address2, bol_skids.weld  from packing_slip, skids, bol_skids, bol where packing_slip.packing_slip_id=skids.packing_slip_id and coalesce(unload,'0000-00-00 00:00:00') = '0000-00-00 00:00:00' and skids.skid_id=bol_skids.skid_id and bol_skids.bol_id=bol.bol_id  and assigned_to = ?  ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
		}
	}
	## also need to get anything from the bol from weld's computer
	$sql="select bs.bol_id from bol_skids bs, skids s, bol where s.skid_id=bs.skid_id and weld=1 and bs.bol_id=bol.bol_id and assigned_to=? ";
	list($brs,$err)=runIQuery($db,$sql,array("i",$userID));
	foreach ($brs as $bdata) {
		$bol=$bdata['bol_id'];
		$url="https://preferredwelderp1.com/getShipName.php?code=8383&pack=$slip&user=$userID&transfer=$isTransfer&bol=$bol";
		$results=file_get_contents($url);
		foreach (explode("\n",$results) as $result) {
			if (trim($result)) {
				list($name,$address,$address2)=explode(",",$result);
				$data=array();
				$data['ship_name']=$name;
				$data['ship_address']=$address;
				$data['ship_address2']=$address2;
				$data['weld']=1;
				$rs[]=$data;
			}
		}				
	}
}
print "</td><td valign='top'>";
print "<div id='working'></div>";
if ($isTransfer) {
	print "<b>Still to Transfer</b>";
} else {
	print "<b>All Remaining Locations</b>";
}
if (count($rs) > 0) {
	print "<table><tr><th>Location</th><th>Address</th><th>Packing Slip</th><th>Skid Number</th></tr>\n";
}
foreach ($rs as $data) {
	$shipName=$data['ship_name'];
	if (! $shipName) {
		$shipName="";
	}
	$shipAddress=$data['ship_address'];
	if (! $shipAddress) {
		$shipAddress="";
	}
	$shipAddress2=$data['ship_address2'];
	if (! $shipAddress2) {
		$shipAddress2="";
	}
	$isWeld=$data['weld'];
	if ($isWeld) {
		## TODO need to get from transfer or packing slip at weld's system
		$sql="select bs.bol_id from bol_skids bs, skids s, bol where packing_slip_id=? and s.skid_id=bs.skid_id bs.bol_id=bol.bol_id and weld=1 and assigned_to=? ";
		list($brs,$err)=runIQuery($db,$sql,array("ii",$slip,$userID));
		$srs=array();
		foreach ($brs as $bdata) {
			$bol=$bdata['bol_id'];
			$url="getSkidInfo.php?code=8383&type=unload&name=$shipName&address=$shipAddress&bol=$bol";
			$results=file_get_contents($url);
			foreach (explode("\n",$results) as $result) {
				list($skid_id, $packing_slip_id, $skid_number, $weight, $scanned, $skid_type)=explode(",",$result);
				$data=array();
				$data['skid_id']=$skid_id;
				$data['packing_slip_id']=$packing_slip_id;
				$data['skid_number']=$skid_number;
				$data['weight']=$weight;
				$data['scanned']=$scanned;
				$data['skid_type']=$skid_type;
				$data['weld']=1;
				$srs[]=$data;
			}
		}
	} else {
		if ($isTransfer) {
			$sql="select s.* from transfers p, skids s, bol_skids bs, bol b where ship_name=? and coalesce(ship_address,'')=? and 
			p.packing_slip_id=s.packing_slip_id  and coalesce(unload,'0000-00-00 00:00:00') = '0000-00-00 00:00:00' 
			and s.skid_id=bs.skid_id and bs.bol_id=b.bol_id and assigned_to=? and skid_type='TRANSFER' order by packing_slip_id, skid_number";
		} else {
			$sql="select s.* from packing_slip p, skids s, bol_skids bs, bol b where ship_name=? and coalesce(ship_address,'')=? and p.packing_slip_id=s.packing_slip_id and  coalesce(unload,'0000-00-00 00:00:00') = '0000-00-00 00:00:00' and s.skid_id=bs.skid_id and bs.bol_id=b.bol_id and assigned_to=? and skid_type='PACK' order by packing_slip_id, skid_number";
		}
		list($srs,$err)=runIQuery($db,$sql,array("ssi",$shipName,$shipAddress,$userID));
	}
	if (count($srs) > 0) {
		print "<tr><td><b>$shipName</b></td><td><b>$shipAddress</b></td></tr>\n";
		foreach ($srs as $sdata) {
			print "<tr><td colspan='2'></td><Td>";
			print $sdata['packing_slip_id'];
			print "</td><td>";
			print $sdata['skid_number'];
			print "</td></tr>\n";
		}
	} else {
		print "<h4>Done scanning location $shipName $shipAddress - unsigned packing slips below</h4>";
		$sql="select p.packing_slip_id, bs.weld from packing_slip p, skids s, bol_skids bs, bol b where ship_name=? and coalesce(ship_address,'')=? 
		and coalesce(ship_address2,'')= ? and p.packing_slip_id=s.packing_slip_id and s.skid_id=bs.skid_id and bs.bol_id=b.bol_id and assigned_to=? 
		and coalesce(p.signed_by,'')='' and skid_type='PACK' order by p.packing_slip_id";
		list($srs,$err)=runIQuery($db,$sql,array("sssi",$shipName,$shipAddress,$shipAddress2,$userID));
		if ($isTransfer) {
			$sql="select p.packing_slip_id, bs.weld from transfers p, skids s, bol_skids bs, bol b where ship_name=? and coalesce(ship_address,'')=?  
			and p.packing_slip_id=s.packing_slip_id and s.skid_id=bs.skid_id and bs.bol_id=b.bol_id and assigned_to=? and coalesce(p.signed_by,'')='' 
			and skid_type='TRANSFER' order by p.packing_slip_id";
			list($srs,$err)=runIQuery($db,$sql,array("ssi",$shipName,$shipAddress,$userID));
		}
		// TODO get any/all from weld marking weld = 1 - put them in $srs				
		// NEED TO FIND open BOLs for this location assigned to this user.  do not know how to figure that out.
		// MAYBE DATE(scanned) needs to be now

		$sql="select bs.bol_id from bol_skids bs, skids s, bol b where  s.skid_id=bs.skid_id and weld=1 and bs.bol_id=b.bol_id and assigned_to=? 
		and DATE(unload) = curdate() ";
		list($brs,$err)=runIQuery($db,$sql,array("i",$userID));
		foreach ($brs as $bdata) {
			$bol=$bdata['bol_id'];
			$packlist=array();
			$url="https://preferredwelderp1.com/getSkidInfo.php?code=8383&type=unload&name=$shipName&address=$shipAddress&bol=$bol";
			$results=file_get_contents($url);
			foreach (explode("\n",$results) as $result) {
				if (trim($result)) {
					list($skid_id, $packing_slip_id, $skid_number, $weight, $scanned, $skid_type)=explode(",",$result);
					if (! in_array($packing_slip_id,$packlist)) {
						$data=array();
						$data['skid_id']=$skid_id;
						$data['packing_slip_id']=$packing_slip_id;
						$data['skid_number']=$skid_number;
						$data['weight']=$weight;
						$data['scanned']=$scanned;
						$data['skid_type']=$skid_type;
						$data['weld']=1;
						$srs[]=$data;
						$packlist[]=$packing_slip_id;
					}
				}
			}
		}

		$all="";
		foreach ($srs as $sdata) {
			print "<tr><td>$shipName</td><Td>$shipAddress</td><td>";
			$pack=$sdata['packing_slip_id'];
			$isWeld=$sdata['weld'];
			if ($isWeld) {
				print "<a href='viewWeldPackingSlip.php?pack=$pack&transfer=$isTransfer&weld=$isWeld' target='_blank' style='font-size: 20px' rel='opener'>";
			} else {
				print "<a href='viewPackingSlip.php?pack=$pack&transfer=$isTransfer&weld=$isWeld' target='_blank' style='font-size: 20px' rel='opener'>";
			}
			print renderButton($sdata['packing_slip_id'],"green");
			print "</a>";
			print "</td></tr>\n";
			$all="<tr><td>SIGN FOR</td><td>SHIP ADDRESS</td><td>";
			if ($isWeld) {
				$all.="<a href='viewWeldPackingSlip.php?pack=$pack&transfer=$isTransfer&all=1' target='_blank' style='font-size: 20px;' rel='opener'>";
			} else {
				$all.="<a href='viewPackingSlip.php?pack=$pack&transfer=$isTransfer&all=1' target='_blank' style='font-size: 20px;' rel='opener'>";
			}
			$all.="SIGN FOR ALL";
			$all.="</a><td></tr>\n";
			// TODO if isTransfer, update order status to 11
			// TODO update order lines with shipped quantity if not isTransfer			
		}
		print $all;
	}
}
if (count($rs) > 0) {
	print "</table>\n";
} else {
	if (isset($_GET['scan'])) {
		$scan=$_GET['scan'];
		$isTransfer=0;
		$isWeld=0;
		if (substr($scan,0,1) == "T") {
			$isTransfer=1;
			$scan=substr($scan,1);
		}
		if (substr($scan,0,1) == "W") {
			$isWeld=1;
			$scan=substr($scan,1);
		}
		$scan=preg_replace("/[^0-9]/","-",$scan);	
		list($slip,$skid)=explode("-",$scan);
		if ($isWeld) {
			$srs=array();
			$url="https://preferredwelderp1.com/getUnsignedPackingSlips.php?type=$isTransfer&pack=$slip&unload=1&code=8383";
			$results=file_get_contents($url);
			foreach (explode(",",$results) as $result) {
				$data=array();
				$data['packing_slip_id']=$result;
				$srs[]=$data;
			}

		} else {
			$sql="select distinct packing_slip_id from packing_slip where packing_slip.packing_slip_id=? and signed_by is null ";
			if ($isTransfer) {
				$sql="select distinct t.packing_slip_id from transfers t  where packing_slip_id=?   and signed_by is null   ";
			}
			list($srs,$err)=runIQuery($db,$sql,array("i",$slip));	
		}
		
		if (count($srs)>0) {
			print "<table><tr><td>Packing Slips to Sign</td></tr>";
		}
		foreach ($srs as $sdata) {
			print "<tr><Td>";
			$pack=$sdata['packing_slip_id'];
			if ($isWeld) {
				print "<a href='viewWeldPackingSlip.php?pack=$pack&transfer=$isTransfer&weld=$isWeld' target='_blank' style='font-size: 20px' rel='opener'>";
			} else {
				print "<a href='viewPackingSlip.php?pack=$pack&transfer=$isTransfer&weld=$isWeld' target='_blank' style='font-size: 20px' rel='opener'>";
			}
			print $sdata['packing_slip_id'];
			print "</a>";
			print "</td></tr>\n";
		}
		if (count($srs)>0) {
			print "</table>";
		}
	}
}

print "</td></tr></table>\n";
print "</form>";
?>
<script>

function reloadPage(scan) {
	document.location.href='unload.php?scan='+scan;
}	
function page_init() {
	jQuery('.datepicker').datepicker();
	try {
		setTimeout(function() {$('#scan').focus(); }, 1);
	}
	catch (err) {		
	}
}

var masterscan='';
function scanLabel(scan) {
	masterscan=scan;
	url='unloadLabel.php?scan=' + scan;
	$.ajax({url: url, success: function(data) {
		reloadPage(masterscan);
	}});
}

</script>
<?php
include('footer.php');
?>