<?php
include('dbConnection.php');
include('security.php');
include('functions.php');

function clockFormat($timeInHours) {
	$hours=floor($timeInHours);
	$minutes=round(($timeInHours-$hours)*60);
	if ($minutes > 59) {
		$hours++;
		$minutes=0;
	}
	$minutes=round($minutes,2);
	if (strlen($minutes)<2) {
		$minutes="0".$minutes;
	}
	if (strlen($hours)<2) {
		$hours="0".$hours;
	}
	return "$hours:$minutes";
}

if (empty($_POST)) {
	$_POST=$_GET;
}
$export=0;
if (isset($_GET["export"])) {
	$export = $_GET["export"];
}
if (!$export) {
include('header.php');
}

if ($userEmail=="ap@preferredmachinellc.com") {
	$isAdmin=1;
}
$sql="select * from departments where `lead_email`=?";
list($rs,$err)=runIQuery($db,$sql,array("s",$userEmail));
if (count($rs)>0) {
	$isAdmin=1;
}

if (! $isAdmin) {
	include('footer.php');
	exit;
}
$start=SubtractBusinessDays(Date("Y-m-d"),7,$db);
$end=Date("Y-m-d");
$detail=0;
$department=0;
if (isset($_POST['start_date'])) {
	$start=formatDateWebtoDB($_POST['start_date']);
}
if (isset($_POST['end_date'])) {
	$end=formatDateWebtoDB($_POST['end_date']);
}
if (isset($_POST['detail'])) {
	$detail=$_POST['detail'];
}
if (isset($_POST['department'])) {
	$department=$_POST['department'];
}
if (!$export) {
print renderPanel("Time Clock Report","","blue");
print "<form name='findform' action='timeclock.php' method=POST>";
print renderDateBox(TRUE,"start_date",formatDateDBToWeb($start),"Start");
print renderDateBox(TRUE,"end_date",formatDateDBToWeb($end),"End");
print "<div style='clear: both;'></div>";
$sql="select department_id, department_name from departments order by department_name";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"department",$department,"Department","N",$rs,1);
print renderCheckBox(TRUE,"detail",$detail,"Show Detail");
print "<div style='clear: both;'></div>";
print renderButton("Find","success","document.findform.submit();");
print "</form>";
print "<table class='table table-striped table-bordered table=hover col-md-12'>";
print "<thead><tr><th>Department</th><th>Lead</th><Th>Employee</th><th>Date</th><th>Time In</th><th>Time Out</th><th>Regular</td><th>Overtime</th><th>Total</td></tr></thead>\n";
print "<tbody>";
} else {
	header("Content-type: application/octet-stream");
    header("Content-Disposition: attachment; filename=TimeclockReportWELD.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
	print "Department\tLead\tEmployee\tDate\tTime In\tTime Out\tRegular\tOvertime\tTotal\n";
}
$sql = "select t.department_name, sa.full_name, e.last_name, e.first_name, e.employee_id, in_date, in_time, out_date, out_time, day_of_week, 
	regular_minutes, ot_minutes, notes, e.points from employees e 
	left outer join clock_punches p on e.employee_id=p.employee_id 
	left outer join departments t on e.department_id=t.department_id 
	left outer join site_admins sa on t.supervisor=sa.user_id where in_date>=? and out_date <=? ";
if ($department) {
	$sql.=" and e.department_id=? ";
	$sql.=" order by department_name, e.last_name, e.first_name, punch_id ";
	list($rs,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$department));
} else {
	$sql.=" order by department_name, e.last_name, e.first_name, punch_id ";
	list($rs,$err)=runIQuery($db,$sql,array("ss",$start,$end));
}
$holdEmployee="";
$holdDate="";
$regEmployee=0;
$otEmployee=0;
$otDay=0;
$regDay=0;
$dayRecords=0;
foreach ($rs as $data) {
	$employee=$data['last_name'] . "," . $data['first_name'];
	if ($employee != $holdEmployee) {
		if ($holdEmployee) {
			$totEmployee=$regEmployee+$otEmployee;
			$totDay = $regDay  + $otDay;
			if ($export) {
				if ($detail) {
					print "\t\t$holdEmployee\t$holdDate\t";
					print clockFormat($regDay);
					print "\t";
					print clockFormat($otDay);
					print "\t";
					print clockFormat($totDay);
					print "\t";
					print "\n";
				}
				print "$departmentName\t$lead\t$holdEmployee\t\tTotal\t";
				print clockFormat($regEmployee);
				print "\t";
				print clockFormat($otEmployee);
				print "\t";
				print clockFormat($totEmployee);
				print "\t";
				print "\n";
			} else {
				if ($detail) {
					print "<tr><td></td><td></td><td>$holdEmployee</td><td>$holdDate</td><td colspan='2'></td>";
					print "<td align='right'>";
					print clockFormat($regDay);
					print "</td>";
					print "<td align='right'>";
					print clockFormat($otDay);
					print "</td>";
					print "<td align='right'>";
					print clockFormat($totDay);
					print "</td>";
					print "</tr>\n";
				}
				print "<tr><td>$departmentName</td><td>$lead</td><td>$holdEmployee</td><td>&nbsp;</td><td>&nbsp;</td><td>Total</td>";
				print "<td align='right'>";
				print "<b>";
				print clockFormat($regEmployee);
				print "</b>";
				print "</td>";
				print "<td align='right'>";
				print "<b>";
				print clockFormat($otEmployee);
				print "</b>";
				print "</td>";
				print "<td align='right'>";
				print "<b>";
				print clockFormat($totEmployee);
				print "</b>";
				print "</td>";
				print "</tr>\n";
			}
		}
		$holdEmployee=$employee;
		$holdDate="";
		$regEmployee=0;
		$otEmployee=0;
		$otDay=0;
		$regDay=0;
		$dayRecords=0;
	}
	$lead=$data['full_name'];
	$departmentName=$data['department_name'];
	$dt=$data['in_date'];
	$employeeID=$data['employee_id'];
	if ($dt != $holdDate) {
		if ($holdDate) {
			if ($detail) {
				if ($export) {
					print "\t\t$holdEmployee\t$holdDate\t\t";
					print clockFormat($regDay);
					print "\t";
					print clockFormat($otDay);
					print "\t";
					print clockFormat($regDay+$otDay);
					print "\t";
					print "\n";
				} else {
					print "<tr><td></td><td></td><td>$holdEmployee</td><td>$holdDate</td><td colspan='2'></td>";
					print "<td align='right'>";
					print clockFormat($regDay);
					print "</td>";
					print "<td align='right'>";
					print clockFormat($otDay);
					print "</td>";
					print "<td align='right'>";
					print clockFormat($regDay+$otDay);
					print "</td>";
					print "</tr>\n";
				}
			}
		}
		$holdDate=$dt;
		$otDay=0;
		$regDay=0;
		$in=$data['in_time'];
	}
	$out=$data['out_time'];
	$reg=$data['regular_minutes']/60;
	$ot=$data['ot_minutes']/60;
	$dayRecords++;
	$thisin=$data['in_time'];
	if ($detail) {
		if ($export) {
			print "\t\t$employee\t";
			$points=$data['points'];
			//$punchID=$data['punch_id'];
			print "$holdDate\t";
			print "$thisin";
			print "";
			print "\t$out\t";
			print "";
			print clockFormat($reg);
			print "\t";
			print "";
			print clockFormat($ot);
			print "\t";
			print "";
			print clockFormat($reg+$ot);
			print "\t";
			print "\n";
			$notes=$data['notes'];
		} else {
			print "<tr><td colspan='2'></td><td>$employee</td>";
			$points=$data['points'];
			//$punchID=$data['punch_id'];
			print "<td>$holdDate</td><td>";
			print "$thisin";
			print "</a>";
			print "</td><td>$out</td>";
			print "<td align='right'>";
			print clockFormat($reg);
			print "</td>";
			print "<td align='right'>";
			print clockFormat($ot);
			print "</td>";
			print "<td align='right'>";
			print clockFormat($reg+$ot);
			print "</td>";
			print "</tr>\n";
			$notes=$data['notes'];
		}
	}
	$regDay+=$reg;
	$otDay+=$ot;
	$regEmployee+=$reg;
	$otEmployee+=$ot;
}
if ($holdEmployee) {
	$totDay=$regDay + $otDay;

	if ($export) {
		if ($detail) {
			print "\t\t$holdEmployee\t\t\tTotal\t";
			print "";
			print clockFormat($regDay);
			print "\t";
			print "";
			print clockFormat($otDay);
			print "\t";
			print "";
			print clockFormat($totDay);
			print "\t";
			print "\n";
		}
		print "$departmentName\t$lead\t$employee\t\t\tTotal\t";
		print "";
		print "";
		print clockFormat($regEmployee);
		print "";
		print "\t";
		print "";
		print "";
		print clockFormat($otEmployee);
		print "";
		print "\t";
		print "";
		print "";
		print clockFormat($regEmployee+$otEmployee);
		print "";
		print "\t";
		print "\n";
	} else {
		if ($detail) {
			print "<tr><td></td><td></td><td>$holdEmployee</td><td>&nbsp;</td><td>&nbsp;</td><td>Total</td>";
			print "<td align='right'>";
			print clockFormat($regDay);
			print "</td>";
			print "<td align='right'>";
			print clockFormat($otDay);
			print "</td>";
			print "<td align='right'>";
			print clockFormat($totDay);
			print "</td>";
			print "</tr>\n";
		}
		print "<tr><td>$departmentName</td><td>$lead</td><td>$employee</td><td>&nbsp;</td><td>&nbsp;</td><td>Total</td>";
		print "<td align='right'>";
		print "<b>";
		print clockFormat($regEmployee);
		print "</b>";
		print "</td>";
		print "<td align='right'>";
		print "<b>";
		print clockFormat($otEmployee);
		print "</b>";
		print "</td>";
		print "<td align='right'>";
		print "<b>";
		print clockFormat($regEmployee+$otEmployee);
		print "</b>";
		print "</td>";
		print "</tr>\n";
	}
}

if (!$export) {
print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>

function page_init() {
	$('.datepicker').datepicker();
}


function printPage() {
	window.open('renderTCPDFReport.php?type=TIMECLOCK&start_date=<?=$start?>&end_date=<?=$end?>','tcreport');
}
</script>
<?php
include('footer.php');
}
?>