<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
if (! $_POST) {
	$_POST=$_GET;
}
$noGo=0;
$bottomscript="";

$empsql = "select first_name, last_name, card_number from employees where card_number in (";
$vars = [""];

$employees=[];

$employee1=0;
if (!empty($_POST["employee1"])) {
    $employee1=$_POST["employee1"];
    $employees[$employee1] = 1;
    $empsql .= "?";
    $vars[] = $employee1;
    $vars[0] .= "i";
}

$employee2=0;
if (!empty($_POST["employee2"])) {
    $employee2=$_POST["employee2"];
    $employees[$employee2] = 2;
    $empsql .= ($employee1 ? ", " : "") . "?";
    $vars[] = $employee2;
    $vars[0] .= "i";
}

$employee3=0;
if (!empty($_POST["employee3"])) {
    $employee3=$_POST["employee3"];
    $employees[$employee3] = 3;
    $empsql .= ($employee1 || $employee2 ? ", " : "") . "?";
    $vars[] = $employee3;
    $vars[0] .= "i";
}

$hasEmployees = count($vars) > 1;
$showScan=1;
$message="";
$scan=0;
if (isset($_POST["scan"])) {
    $scan=$_POST["scan"];
}

$submitit=0;
if (isset($_POST["submitit"])) {
    $submitit=$_POST["submitit"];
}

$empsql .= ")";






print "<div id='confModal' class='modal fade' role='dialog'>
	<div class='modal-dialog'>
		<div class='modal-content'>
			<div class='modal-header'><h4 class='modal-title confTitle'></h4></div>
			<div class='modal-body'>
				<span class='confBody'></span>
			</div>
			<div class='modal-footer'>
				<button class='btn green' data-dismiss='modal' onclick='confInput(true)'>Yes</button>
				<button class='btn red' data-dismiss='modal' onclick='confInput(false)'>No</button>
			</div>
		</div>
	</div>
</div>";








function createResults($db,$card,$job,$routing,$hours,$minutes,$qtygood,$notes,$lastPunch,$newPunch) {
	$complete=0;
	$sql="select employee_id from employees where card_number=? and coalesce(inactive,0) = 0 ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$card));
	$data=$rs[0];
	if ($data[0]) {
		$employee=$data[0];
	}
	if (! $employee)  {
		$employee=$card;
	}
	if (! $employee) {
		$employee=0;
	}
	date_default_timezone_set('America/Detroit');
	$sql="SET time_zone = '" .date('P') . "'";
	list($rs,$err)=runIQuery($db,$sql);
	include('overProduction.php');
	$sql="select * from production_results where job_id=? and routing_id=? and employee_id=? and result_date=now()  and start_time=? and end_time=? ";
	list($rs,$err)=runIQuery($db,$sql,array("iiiss",$job,$routing,$employee,$lastPunch,$newPunch));
	if (count($rs)==0) {
		$sql="insert into production_results (job_id, routing_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete) values (?, ?, ?, now(), ?, ?, ?, 1, ?, ?, ?, ?) ";
		list($rs,$err)=runIQuery($db,$sql,array("iiiiiisssi",$job,$routing,$employee,$hours,$minutes,$qtygood,$notes,$lastPunch,$newPunch,$complete));
		$rid=$rs[0][0];
	}
    $sql = "update employees set current_job=0 where card_number=?";
    list($rs,$err)=runIQuery($db,$sql,["i",$card]);

}

if ($submitit) {
	$employee=$_POST['employee1'];
	if (isset($_POST['fromjob'])) {
		$job=$_POST['job'];
		$step=$_POST['step'];
	} else {
		$scan=$_POST['scan'];
		list($job,$step)=explode("-",$scan);
	}
	$sql="select * from routing where display_sequence=? and parent_part in (select item_id from jobs where job_id=?)  ";
	list($rs,$err)=runIQuery($db,$sql,array("is",$step,$job));
	$data=$rs[0];
	$routing=$data['routing_id'];
	$sql="select * from routing r, jobs j where parent_part = item_id and job_id = ? and operation_id=3100";
	## 3090 is Material Handling apparently never scanned into when there is Assembly (3100)
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	if (count($rs)>0) {
		$sql="select max(r.display_sequence) from routing r, jobs j where parent_part = item_id and job_id=? and operation_id <> 3090 ";
	} else {
		$sql="select max(r.display_sequence) from routing r, jobs j where parent_part = item_id and job_id=?  ";
	}
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	if (count($rs)==0) {
		$sql="select max(r.display_sequence) from routing r, jobs j where parent_part = item_id and job_id=?  ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	}
	$max=$rs[0][0];
	if (! $employee) {
		print "<h3>You must enter Employee Number</h3>";
		$showScan=0;
	} else {
		$lastPunch=$_POST['start'];
#		if (! $lastPunch or $lastPunch < Date("Y-m-d 05:00:00")) {
#			$lastPunch=Date("Y-m-d 06:00:00");
#		}
		$notes=$_POST['notes'];
		$newPunch=Date("Y-m-d H:i:s");

		//Switch over to new time calculation -Josh 04-25-2022
		$diff = strtotime($newPunch) - strtotime($lastPunch); //total seconds taken

		$minutes = round($diff/60)%60;
		$hours = floor($diff/60/60);

		$qtygood=$_POST['good'];
		//$qtylost=$_POST['lost'];
		$shift=$_POST['shift'];
		if (! $shift) {
			$shift=1;
		}
		// $defect=$_POST['defect'];
		// if (! $defect) {
		// 	$defect=1;
		// }
		if ($_POST['result_date']) {
			$jobDate=formatDateWebToDB($_POST['result_date']);
		}
		if (! $jobDate) {
			$jobDate=Date("Y-m-d");
		}
		// get true employee based on card
		$employee2=trim($_POST['employee2']);
		$employee3=trim($_POST['employee3']);
		$complete=$_POST['complete'];
		if (! $complete) {
			$complete=0;
		}
		$newid=0;
		if (! $routing) {
			$routing=0;
		}
		$sql="select line_id, item_id, customer_id, quantity_scheduled, quantity_good from jobs where job_id=?  ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		$data=$rs[0];
		$oqty=$data['quantity_scheduled'];
		$customer=$data['customer_id'];
		$part=$data['item_id'];
		$line=$data['line_id'];
		$made=$data['quantity_good'];
		$canmake=$oqty - $made;
		if ($canmake < 0) {
			$canmake=0;
		}
		if ($canmake < $qtygood) {
			print "<center>You entered that you made $qtygood, but you can only make $canmake more for this job.  Your time will be recorded, but the quantity good will be $canmake.</center>";
			$qtygood=$canmake;
		}
		$sql="select po_number from order_lines, orders where line_id=? and order_lines.order_id=orders.order_id ";
		$revision="";
		list($rs,$err)=runIQuery($db,$sql,array("i",$line));
		$data=$rs[0];
		$poNumber=$data['po_number'];
		$factor=1;
		if ($employee2) {
			$factor++;
		}
		if ($employee3) {
			$factor++;
		}
		$qtyinsert=floor($qtygood/$factor);
		$leftover=$qtygood - ($qtyinsert * $factor);
		createResults($db,$employee,$job,$routing,$hours,$minutes,$qtyinsert+$leftover,$notes,$lastPunch,$newPunch);

		if ($employee2) {
			createResults($db,$employee2,$job,$routing,$hours,$minutes,$qtyinsert,$notes,$lastPunch,$newPunch);
		}
		if ($employee3) {
			createResults($db,$employee3,$job,$routing,$hours,$minutes,$qtyinsert,$notes,$lastPunch,$newPunch);
		}
		// newly inserted ID
		$newid=$rs[0][0];
		// if ( $qtylost) {
		// 	$sql="insert into job_defects (job_id, defect_id, date_reported, quantity, routing_id) values (?, ?, ?, ?, ?) ";
		// 	list($rs,$err)=runIQuery($db,$sql,array("iisii",$job,$defect,$jobDate,$qtylost,$routing));
		// }
		if ($qtygood) {
			consumeComponents($db,$routing,$qtygood,$job,"timeEntry.php",1,$step);
		}
		// if ($qtylost) {
		// 	consumeComponents($db,$routing,$qtylost,$job,"timeEntry.php",0,$step);
		// }

		$sql="select coalesce(quantity_scheduled - sum(coalesce(p.quantity_good,0)),0) as tomake, item_id from jobs j left outer join production_results p on j.job_id=p.job_id left outer join routing r on p.routing_id=r.routing_id and r.display_sequence=?  where j.job_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$step,$job));
		$data=$rs[0];
		if ($data['tomake'] > $qtygood) {
			$message="$job Step $step only made $qtygood when you need " . $data['tomake'] . "<BR>";
			if ($complete) {
				#mail("jespinoza@preferredmachinellc.com","Job $job Step $step Short",$message);
				mail("jsheridan@preferredmachinellc.com","Job $job Step $step Short",$message);
			}
		} else {
			$sql="update production_results set complete=1 where results_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$newid));
		}
		$message.="Job $job Step $step has been updated.";
		if ($step == $max) {
			makeQuantityFromJob($db,$job,$qtygood,"timeEntry.php");
		} else {
		}
    }
    $hasEmployees=0;
}













print renderPanel("<i class='icon-star'></i>Time Entry");
if ($hasEmployees) { // Has at least one employee
    print "<table class='table table-bordered'>
    <tr><th>Employees</th></tr><tr>";


    list($rs,$err) = runIQuery($db, $empsql, $vars);
    $emps = [];
    foreach ($rs as $employee) {
        $name = $employee["first_name"] . " " . $employee["last_name"];
        $emps["employee" . $employees[$employee["card_number"]]] = $name;
        //print "<td style='width: 33.33%;'><b>$name</b></td>";
    }

    print "<td style='width: 33.33%;'>" . $emps["employee1"] . "</td>";
    print "<td style='width: 33.33%;'>" . $emps["employee2"] . "</td>";
    print "<td style='width: 33.33%;'>" . $emps["employee3"] . "</td>";

    print "</tr></table>";


















    if ($scan) { // Has scanned page
        print "<input type='hidden' name='scan_sent' id='scan_sent' value='$scan'>";
		list($job,$step)=explode("-",$_POST['scan']);
		if (! $step) {
			print "<h3>You must scan Job - Step barcode, or else enter Job-Step</h3>";
			$showScan=1;
		} else {
			$sql="select * from jobs j, routing r where job_id=? and j.item_id=r.parent_part  and display_sequence=? ";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$job,$step));
			if (count($rs)==0) {
				print "<h3>You must scan Job-Step barcode or else enter a VALID Job-Step</h3>";
				$showScan=1;
			} else {
				$sql="select item_id,customer_id, line_id, quantity_scheduled from jobs where job_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$job));
				$data=$rs[0];
				$part=$data['item_id'];
				if (strtolower($part) == "customcrating") {
					print "\n<script>\n";
					print "document.location.href='timeEntryCrating.php?scan=$scan&rand='+Math.random();\n";
					print "\n</script>\n";
					exit;
				}
				$customer=$data['customer_id'];
				$lineID=$data['line_id'];
				$oqty=$data['quantity_scheduled'];
				$sql="select label_printed from jobs where job_id=?  ";
				list($rs,$err)=runIQuery($db,$sql,array("i",$job));
				$data=$rs[0];
				$qtyposted=$data[0];
				$sql="select item_category from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$part));
				$data=$rs[0];
				$itemCategory=$data[0];
				## dematic
				if ($customer == 693) {
					if ($qtyposted == 0 ) {
						$sql="select workcenter_name from routing r, workcenters w where parent_part=? and display_sequence=? and r.workcenter_id=w.workcenter_id";
						list($rs,$err)=runIQuery($db,$sql,array("si",$part,$step));
						$data=$rs[0];
						$wcname=$data['workcenter_name'];
						if (strtolower($wcname)=="material handling") {
							$sql="select workcenter_name from routing r, workcenters w where parent_part=? and r.workcenter_id=w.workcenter_id and workcenter_name='Assembly'";
							list($rs,$err)=runIQuery($db,$sql,array("s",$part));
							if (count($rs)==0) {
								// if no assembly then trigger for material handling
								$wcname="assembly";
							}
						}
						if (strtolower($wcname)=="assembly") {
							$smallfile="labels/small";
							$smallfile.="$packslip-$line-".Date("Ymdhhss").".txt";
							$si=0;
							$smallstring="";
							while ($si < $oqty) {
								$smallstring.="$part,$poNumber,$revision\n";
								$si++;
							}
							file_put_contents($smallfile,$smallstring);
							$sql="update jobs set label_printed=1 where job_id=?";
							list($rs,$err)=runIQuery($db,$sql,array("i",$job));
						}
					}
				}

				$sql="select name from customers where customer_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
				$customer=$rs[0][0];
				$sql="select notes, workcenter_id from routing where parent_part=? and display_sequence=?";
				list($rs,$err)=runIQuery($db,$sql,array("si",$part,$step));
				$data=$rs[0];
				$notes=$data[0];
				$workcenterID=$data[1];
				## Status 7 is At Weld
				if (in_array($workcenterID,array(157,158,159,161,162,168))) {
					$sql="update orders set status=7 where order_id in (select order_id from order_lines where line_id=?) and status not in (3,4,5,6,7,8,9,10,12,13,15)";
					list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
					$sql="update order_lines set line_status=7 where line_id=? and line_status not in (3,4,5,6,7,8,9,10,12,13,15)";
					list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
				}
				## 169 assembly
				## status 10 is At Assembly
				if ($workcenterID == 169) {
					$sql="update orders set status=10 where order_id in (select order_id from order_lines where line_id=?) and status not in (3,4,5,6) ";
					list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
					$sql="update order_lines set line_status=10 where line_id=? and line_status not in (3,4,5.6) ";
					list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
				}
				## 180 Bend
				## this can have jobs for multiple sales orders
				## 15 is At Bend
				if ($workcenterID == 180) {
					$sql="select distinct order_id from order_lines where line_id=?";
					list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));
					foreach ($rs as $odata) {
						$so=$odata['order_id'];
						$sql="update orders set status=15 where order_id =$so  and status not in (3,4,5,6,7,8,9,10,12,13,15)";
						list($updrs,$err)=runIQuery($db,$sql);
					}
					$sql="update order_lines set line_status=15 where line_id=? and line_status not in (3,4,5,6,7,8,9,10,12,13,15)";
					list($rs,$err)=runIQuery($db,$sql,array("i",$lineID));

					$sql="select distinct order_id from jobs_orders j, order_lines l where job_id=? and j.order_line=l.line_id ";
					list($rs,$err)=runIQuery($db,$sql,array("i",$job));
					foreach ($rs as $odata) {
						$so=$odata['order_id'];
						$sql="update orders set status=15 where order_id =$so  and status not in (3,4,5,6,7,8,9,10,12,13,15)";
						list($updrs,$err)=runIQuery($db,$sql);
					}
					$sql="select distinct line_id from jobs_orders j, order_lines l where job_id=? and j.order_line=l.line_id ";
					list($rs,$err)=runIQuery($db,$sql,array("i",$job));
					foreach ($rs as $odata) {
						$soline=$odata['line_id'];
						$sql="update order_lines set  line_status=15 where line_id=$soline  and line_status not in (3,4,5,6,7,8,9,10,12,13,15)";
						list($updrs,$err)=runIQuery($db,$sql);
					}

				}
				## 164 Quality Inspection
				if ($workcenterID == 164 and $isEmployee and $itemCategory==20)  {
					$noGo=1;
				}
				$message="WO: $job Part: "  . $part . " ";
                $sql="select c.name from jobs j, customers c where j.job_id=? and j.customer_id=c.customer_id ";
                list($crs,$err)=runIQuery($db,$sql,array("i",$job));
                $cdata=$crs[0];
                $message.= "Customer: " . $cdata[0] . " ";
                $message.= renderPartLink($cdata[0],$part);
                $message.= renderPartLinkOpen($cdata[0],$part);
                print "<BR>";
                $vars = ["si","$job-$step",$employee1];
                $sql = "update employees set current_job=? where card_number in (?";
                if ($employee2) {
                    $sql .= ", ?";
                    $vars[0] .= "i";
                    $vars[] = $employee2;
                }
                if ($employee3) {
                    $sql .= ", ?";
                    $vars[0] .= "i";
                    $vars[] = $employee3;
                }
                $sql .= ")";
                list($rs)=runIQuery($db,$sql,$vars);

				$sql="select coalesce(sum(r.quantity_good),0) from production_results r, jobs j, routing t where j.item_id = t.parent_part and t.display_sequence=? and j.job_id=? and t.routing_id=r.routing_id and j.job_id=r.job_id ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$step,$job));
				$data=$rs[0];
				$qty=$data[0];
				$sql="select quantity_scheduled from jobs where job_id=?  ";
				list($rs,$err)=runIQuery($db,$sql,array("i",$job));
				$data=$rs[0];
				$oqty=$data[0];
				$needed=$oqty-$qty;
				$bottomscript.="url='listComponents.php?id=$part&qty=$needed&rand='+Math.random();";
				$bottomscript.="	\$.ajax({url: url, success: function(data){ ";
				$bottomscript.="		$('#components').html(data); }});\n";

				$sql="select workcenter_name from jobs j, routing r, workcenters w where job_id=? and j.item_id=r.parent_part and r.workcenter_id=w.workcenter_id ";
				$sql.=" and r.display_sequence > ? order by display_sequence LIMIT 1 ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$job,$step));
				if (count($rs)==0) {
					$sql="select workcenter_name from jobs j, routing r, billofmaterial b, workcenters w where j.line_id=? ";
					$sql.=" and j.item_id=r.parent_part and r.routing_id=b.routing_id and r.workcenter_id=w.workcenter_id  and r.parent_part=b.parent_item and b.child_item=?";
					list($rs,$err)=runIQuery($db,$sql,array("is",$lineID,$part));
				}
				$data=$rs[0];
				$nextOperation=$data['workcenter_name'];
				if ($nextOperation) {
					$message.="<h3>Next Operation: <b>$nextOperation</b></h3>";
				}
				$message.= "Needed: $oqty, done so far: $qty<br>";
				$message.=nl2br($notes);
				$showScan=0;
				print "<script>\nvar maxqty=$oqty;\n</script>\n";
			}
		}
    }
}
















?>
<form name='editForm' id='editForm' method='POST'>
    <h4><?=$message?></h4>
    <style>
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            appearance: none;
        }

        input[type=number] {
            -moz-appearance: textfield;
        }

        .invalid {
            background: #ff9a9a !important;
        }

        .valid {
            background: #88f188 !important;
        }
    </style>

<?php if (!$hasEmployees) { ?>
    <!-- Adding the inputs manually as I needed to have a shared class between the inputs -->
    <div class="span3">
        <div class="control-group span5">
            <label class="control-label" for="employee1">Employee #1</label>
            <div class="controls">
                <input class="employee-input" type="number" name="employee1" id="employee1" class="form-control" value="">
            </div>
        </div>
    </div>

    <div class="span3">
        <div class="control-group span5">
            <label class="control-label" for="employee2">Employee #2</label>
            <div class="controls">
                <input class="employee-input" type="number" name="employee2" id="employee2" class="form-control" value="">
            </div>
        </div>
    </div>

    <div class="span3">
        <div class="control-group span5">
            <label class="control-label" for="employee3">Employee #3</label>
            <div class="controls">
                <input class="employee-input" type="number" name="employee3" id="employee3" class="form-control" value="">
            </div>
        </div>
    </div>

    <div class='control-group span1'>
        <label class='control-label' for=''>‎</label>
        <div class='controls'>
        <?php
            print renderButton("Submit","blue","submitEmployees(); return false;","empsub"); //return false to stop default behavior of the button
        ?>
        </div>
    </div>

    <?php } else {
        print "<input type='hidden' name='employee1' id='employee1' value='$employee1'>";
        print "<input type='hidden' name='employee2' id='employee2' value='$employee2'>";
        print "<input type='hidden' name='employee3' id='employee3' value='$employee3'>";
        print "<div class='progress progress-striped active'>
            <div class='bar'></div>
        </div>";



















        if ($showScan) {
            //scan input page
            print renderTextBox(TRUE,"scan","","Scan Work Order Sheet");

            print "<div class='control-group span1'>
                <label class='control-label' for=''>‎</label>
                <div class='controls'>
                    <button type='button' class='btn blue' onclick=\"saveTheForm('1');\"><i class='icon-star'></i> Start</button>
                </div>
            </div>";
        } else {

            print "<input type='hidden' name='submitit' value='1'>";
            print "<input type='hidden' name='scan' value='" . $_POST['scan'] . "'>\n";
            list($job,$step)=explode("-",$_POST['scan']);
            $newPunch=Date("Y-m-d H:i:s");
            print "<input type='hidden' name='start' id='start' value='$newPunch'>";
            $sql="select item_id, description, line_id, quantity_scheduled, quantity_good from jobs where job_id = ?";
            list($rs,$err)=runIQuery($db,$sql,array("i",$job));
            $data=$rs[0];
            $itemName=$data[0];
            $description=$data[1];
            $ol=$data[2];
            $scheduled=$data['quantity_scheduled'];
            $good=$data['quantity_good'];
            if (! isset($needed)) {
                $needed=$scheduled - $good;
            }
		$qtylost=0;
		$sql="SELECT quantity FROM job_defects WHERE job_id=?";
		list($lrs,$err)=runIQuery($db,$sql,array("i",$job));
		if (count($lrs)) {
			foreach ($lrs as $ldata) {
				$lost=$ldata['quantity'];
				$qtylost+=$lost;
			}
		}
            $sql="select order_id from order_lines where line_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
            $order=$rs[0][0];
            $itemPart=substr($itemName,0,-2);
            $sql="select pph, operation_id from routing where parent_part=? and display_sequence=? ";
            list($rs,$err)=runIQuery($db,$sql,array("si",$itemName,$step));
            $data=$rs[0];
            $pph=$data[0];
            $op=$data[1];
            $budget="";
            if ($pph>0) {
                $minutesPerPart=60 / $pph;
                $totalMinutes=$minutesPerPart * $needed;
                $budgetHours=floor($totalMinutes/60);
                $budgetMinutes=$totalMinutes - (60 * $budgetHours);
                if ($budgetHours) {
                    $budget="$budgetHours hours, $budgetMinutes minutes";
                    $budget=str_replace(", 0 minutes","",$budget);
                } else {
                    $budget="$budgetMinutes minutes";
                }
            }
		$sql="select operation_name, routing_id from jobs, routing, operations where jobs.item_id=routing.parent_part and routing.operation_id=operations.operation_id and job_id=? ";
            $sql.=" and routing.display_sequence = ? ";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$job,$step));
            $data=$rs[0];
            $opName=$data[0];
		$routing=$data[1];
            if (in_array(strtolower($opName),array("assembly","material handling"))) {
                print "<div style='clear: both;'></div>\n";
                $labelCount=25;
                if ($labelCount > $needed) {
                    $labelCount=$needed;
                }
                print renderTextBox(TRUE,"label_count","$labelCount","Labels/Boot Tags to Print " . renderButton("PRINT","red","printLabels()"));

            }
            print "<div style='clear: both;'></div>\n";
            print renderTextBox(TRUE,"good","0","Quantity Good");

            print "<div class='span6'>";
            print "<h4>Expected Parts Per Hour: $pph</h4>";
            print "<h4><font size='+1'><b>Expected Time to Complete $needed: $budget</b></font></h4>";
            print "<div id='loadProgress' style='width: 1%;' class='bar'></div>";
            print "</div>";

            if ($pph > 0 && $totalMinutes > 0) {
                $bottomscript .= "var needed = $needed; var budget = $totalMinutes; var pph = $pph;";
                $bottomscript .= "var barInt = setInterval(function() {
                    var time = Date.now() - new Date($('#start').val()).getTime();
                    var minutes = time/1000/60;
                    var percent = minutes / budget * 100;

                    if (percent > 100) { // TODO: alert user?
                        $('.progress').addClass('progress-danger');
                        percent = 100;
                        clearInterval(barInt);
                    }

                    if (percent == 100) {
                        $('.progress').toggleClass('active');
                    }
                    $('.bar').css('width', percent + '%');
                }, 1000);";
            } else {
                $bottomscript .= "$('.progress').hide();";
            }


            print "<div style='clear: both;'></div>\n";
		//changed from text box with quantity lost to enter and now it links to enterJobDefects Brittany 7/6/22
		print "<button class='btn red' id='lost' value=$qtylost><a href='enterJobDefects.php?job=$job&routing=$routing&step=$step' target='_blank' style='color: white'>Enter Defects</a></button>";
		//print renderTextBox(TRUE,"lost","0","Quantity Lost");
            print renderStartItem(FALSE,"","");
            print "<h4>$description</h4>";
            print renderEndItem();
            print "<div style='clear: both;'></div>\n";
            print renderCheckBox(TRUE,"complete",0,"Complete");
            print "<div style='clear: both;'></div>\n";
            print renderTextArea(TRUE,"notes","",$notes);
            print "<div style='clear: both;'></div>\n";
            if ($noGo) {
                print "<div id='override'>";
                print "<p>You must have a supervisor perform Quality Inspections.</p>";
                print "<p>Supervisor enter over-ride code here: <input type='password' onchange='checkCode(this.value);'></p> ";
                print "</div>";
                print "<button type='button' class='btn blue' id='btnStop' style='display:none;' onclick=\"saveTheForm('0');\"><i class='icon-target'></i> Stop</button>";
            } else {
                print "<button type='button' class='btn blue' id='btnStop' onclick=\"saveTheForm('0');\"><i class='icon-target'></i> Stop</button>";
            }
            print "<div style='clear: both;'></div>\n";
            print "<div id='components' name='components'></div>\n";
            $bottomscript.="window.addEventListener('beforeunload', (event) => {if (stopclicked==0) { event.preventDefault();event.returnValue = '';}});\n";
            if ($op == 3107) {
                ## quality inspection
                //print renderStartItem(TRUE,"plantoactual","Plan To Actual");

                //// Changed this to span7 so the table is easier to read, maybe we should have a way to set the width on renderStartItem?
                print '<div class="span7">
                <div>
                <label class="control-label" for="plantoactual">Plan To Actual</label>
                <div class="controls">';
                ////

                print "<table class='table table-striped'>";
                print "<thead>";
                print "<tr>";
                print "<th>Workcenter</th>";
                print "<th>SO</th>";
                print "<th>Part</th>";
                print "<th>Planned Minutes Per Part</th>";
                print "<th>Actual Minutes Per Part</th>";
                print "</tr>";
                print "</thead>";
                print "<tbody>";

                $sql="select workcenter_name, j.item_id, order_id, r.pph, l.quantity, sum(duration_hours) as hours, sum(duration_minutes) as minutes, sum(p.quantity_good) as good from production_results p inner join routing r on p.routing_id=r.routing_id left outer join workcenters w on w.workcenter_id=r.workcenter_id inner join jobs j on j.job_id=p.job_id left outer join order_lines l on l.line_id=j.line_id ";
                $sql.=" where l.order_id=$order ";
                $sql.=" group by workcenter_name, j.item_id, order_id, r.pph, l.quantity";
                list($result,$err)=runIQuery($db,$sql);
                foreach ($result as $data) {
                    $wc=$data['workcenter_name'];
                    $part=$data['item_id'];
                    $so=$data['order_id'];
                    $hours=$data['hours'];
                    $minutes=$data['minutes'];
                    $qty=$data['good'];
                    if ($qty == 0) {
                        $qty=$data['quantity'];
                    }
                    $totalhours=$hours+($minutes/60);
                    if ($qty > 0) {
                        $actualHoursPerPart=$totalhours / $qty;
                    } else {
                        $actualHoursPerPart=$totalhours;
                    }
                    $pph=$data['pph'];
                    if ($pph > 0) {
                        $planHoursPerPart=1 / $pph;
                        $planHoursPerPart = $planHoursPerPart * 60; // Cannot do string * int in PHP 8, had to move this here
                        $planHoursPerPart=round($planHoursPerPart*10)/10;
                    } else {
                        $planHoursPerPart="Not Set";
                    }
                    $actualHoursPerPart=round($actualHoursPerPart*1000)/1000;

                    print "<tr>";
                    print "<td valign='top'>$wc</td>";
                    print "<td valign='top'>$so</td>";
                    print "<td valign='top'>$part</td>";
                    print "<td valing='top'>$planHoursPerPart</td>";
                    print "<td valign='top'>$actualHoursPerPart</td>";
                    print "</tr>\n";
                }
                print "</tbody>";
                print "</table>\n";
                print renderEndItem();
            }
            $partlink=renderPartLinkOpen($cdata[0],$part);
            $partlink=str_replace("<script>","",$partlink);
            $partlink=str_replace("</script>","",$partlink);
            $bottomscript.= $partlink;

            $sql="select item_id, item_name, customer_id from items where item_name =? ";
            list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
            $data=$rs[0];
            print "\n<script>\n";
            $itemID=$data['item_id'];
            $name=$data['item_name'];
            $customer=$data['customer_id'];

            //Removed dev folder -Josh 03-09-2022


            require_once('s3.php');

            $dir = listFiles();

            $basePrefix=-1;
            $basePart = $part;
            $writtenFile=0;
            $cntr=0;

            $showpdfs = !isset($_POST["nopdfs"]);
            foreach ($dir  as $fulldir) {
                $temp = explode('/', $fulldir);
                $fname = array_pop($temp); //only get the final file
                list($prefix,$rest)=explode("-",$fname);
                if ($prefix == $itemID) {
                    if (! in_array($fname,array(".",".."))) {
                        if (strstr(strtolower($fname),".stp")) {
                            $cntr++;
                            print "var a$cntr = document.createElement('A');\n";
                            $flink = rawurlencode($fulldir);
                            print "a$cntr.href = 'showDocument.php?id=$flink&code=8383';\n";
                            print "a$cntr.download = '$fname';\n";
                            print "document.body.appendChild(a$cntr);\n";
                            print "a$cntr.click();\n";
                            $writtenFile=1;
                        } else {
                            list($prefix,$rest)=explode("-",$fname);
                            if ($showpdfs) {
                                $flink = rawurlencode($fulldir);
                                print "window.open('showDocument.php?id=$flink&code=8383', '_blank');\n";
                            }
                            $writtenFile=1;                            
                        }
                    }
                }
            }
            reset($dir);
            foreach ($dir  as $fulldir) {
                $temp = explode('/', $fulldir);
                $fname = array_pop($temp); //only get the final file
                list($prefix,$rest)=explode("-",strtolower($fname));
                if ($prefix == strtolower($name)) {
                    if (! in_array($fname,array(".",".."))) {
                        if (strstr(strtolower($fname),".stp")) {
                            $cntr++;
                            print "var a$cntr = document.createElement('A');\n";
                            $flink = rawurlencode($fulldir);
                            print "a$cntr.href = 'showDocument.php?id=$flink&code=8383';\n";
                            print "a$cntr.download = '$fname';\n";
                            print "document.body.appendChild(a$cntr);\n";
                            print "a$cntr.click();\n";
                            $writtenFile=1;
                        } else {
                            list($prefix,$rest)=explode("-",$fname);
                            if ($showpdfs) {
                                $flink = rawurlencode($fulldir);
                                print "window.open('showDocument.php?id=$flink&code=8383', '_blank');\n";
                            }
                            $writtenFile=1;                            
                        }
                    }
                }
            }

            ## weld tig fabricate, qc inspect
            if (in_array($op,array("3081","3091","3099"))) {
                $fname="WeldQualityInspection.pdf";
                if ($showpdfs) {
#                        print "window.open('showDocument.php?id=$fname', '_blank');\n";
                }
            }
            ## qc inspect
            if ($op == "3107") {
                $fname="WeldQualityInspection.pdf";
                if ($showpdfs) {
                    print "window.open('showDocument.php?id=$fname&code=8383', '_blank');\n";
                }
            }
            $customer=str_replace(" ","",$customer);
            if (shouldIShowWeld($db,$itemID) and 1 < 0) {
                $filename="WeldDiscontinuities.pdf";
                $fid=str_replace("-","",str_replace(".","",str_replace("pdf","",$filename)));
                if ($showpdfs) {
                    print "window.open('showDocument.php?id=$filename&code=8383','_blank');\n";
                }
            }
            print "</script>\n";
        }
















    }?>
</form>
<?php
print renderClosePanel();
include("footer.php");
?>
<script>
    function page_init() {

        $('.employee-input').on("change",function(e) {
            var elm = $(this);
            var emp = elm.val();
            elm.removeClass("valid").removeClass("invalid");

            if (emp > 0) {
                $.ajax({
                    url: "validateEmployee.php?code=8383&id="+emp+"&rand="+Math.random(),
                    success: function(resp) {
                        if (resp != "OK-Employee Found") {
                            $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> Invalid Employee Number</span>");
                            elm.removeClass("valid").addClass("invalid").effect("shake").focus();
                        } else {
                            elm.removeClass("invalid").addClass("valid");
                        }
                    }
                });
            }
        }).keypress(function(e) {
            if (e.keyCode == 13) {
                var nextid = (+$(e.target).attr("id").substr(-1))+1;
                var nextelm = $("#employee"+nextid).focus();;
                if (!nextelm.length) {
                    $("#empsub").focus();
                }
                return false;
            }
        });

        $("#empsub").keypress(function(e) {
            submitEmployees();
            return e.keyCode != 13;
        });

        $("#employee1").focus();

        <?=$bottomscript?>
    }

    function submitEmployees() {
        if ($(".invalid").length) { // has one or more invalids
            $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> One or more invalid employees!</span>");
            $(".invalid").effect("shake").first().focus();
            return;
        }

        if (!$(".valid").length) { //has no valids
            $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> No employees provided!</span>");
            $("#employee1").effect("shake").focus();
            return;
        }
        if (!$("#employee1").val()) {
            $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> Please fill out employees in order</span>");
            $("#employee1").effect("shake").focus();
            return;
        }

        var valid = $(".valid");
        var noGo = 0;
        var jobs = {};
        var onjobs = [];

        function confirmModal(title,body,cb=function(){}) {
            $("#confModal .confTitle").text(title);
            $("#confModal .confBody").html(body);
            window.confInput = cb;
            $("#confModal").modal("show");
        }

        for (var i = 0; valid.length > i; i++) {
            var elm = $(valid[i]);
            var emp = elm.val();
            (function(i, emp) {
                $.ajax({
                    url: "employeeJobCheck.php?code=8585&employee=" + emp,
                    success: function(resp) {
                        if ((+resp) != 0) {
                            if (jobs[resp] == undefined) {
                                jobs[resp] = [];
                            }
                            jobs[resp].push(emp);
                            onjobs.push(emp);
                        }

                        if (i == valid.length-1) {
                            var keys = Object.keys(jobs);
                            if (keys.length > 0) {
                                confirmModal("Still On Jobs", "<h4>One or more employees are still clocked into jobs!</h4><b>(Employees: " + onjobs.join(", ") + ")</b><br>Do you want to open the jobs now to submit results? (Enter 0 on results if just closing the job)<br>You will not be able to clock into another job until clocked out of the prior job!", function(conf) {
                                    if (conf) {
                                        for (var j = 0; keys.length > j; j++) {
                                            var job = keys[j];
                                            var emps = jobs[job];
                                            var url = "timeEntry.php?nopdfs=1&scan=" + job;
                                            for (var l = 0; emps.length > l; l++) {
                                                var emp = emps[l];
                                                url += "&employee" + (l+1) + "=" + emp;
                                            }
                                            window.open(url, "_blank");
                                        }
                                    }
                                });
                            } else {
                                document.editForm.submit();
                            }
                        }

                    }
                });
            })(i, emp);
        }
    }

















    function saveTheForm(stepid) {
		$('#btnStop').hide();
		$('#working').show();
		msg='';
		if ($('#employee').val()=='') {
			msg='You must enter Employee Number\r\n';
		}
		if ($('#scan').val()=='') {
			msg+='You must scan the work order\r\n';
		}
		//not sure what to do with this part yet.  took away the scrap input and now defects are entered on another page
		// if (($('#good').val()=='0')  && ($('#lost').val()=='0')) {
		// 	msg+='You must enter at least some quantity, good or defects';
		// }
		if (stepid == '1') {
			msg='';
			$("#editForm").submit();
		} else {
	 		if (msg != ''){
				$('#btnStop').show();
				$('#working').hide();
				$.gritter.add(msg);
			} else {
				if ($('#good').val > maxqty) {
					alert('You can only make up to '+maxqty + ' parts.');
					$('#btnStop').show();
				} else {
					url='validateEmployee.php?code=8383&id='+$("#employee1").val()+'&rand='+Math.random();
					$.ajax({url: url, success:
						function(data) {
							if (data != 'OK-Employee Found') {
								alert('Invalid Employee Number');
								$('#btnStop').show();
								$('#employee').focus();
							} else {
								if ($('#employee2').val()!='' && $("#employee2").val()!=0) {
									url='validateEmployee.php?code=8383&id='+$("#employee2").val()+'&rand='+Math.random();
									$.ajax({url: url, success:
										function(data) {
											if (data != 'OK-Employee Found') {
												alert('Invalid Employee Number #2');
												$('#btnStop').show();
												$('#employee2').focus();
											} else {
												if ($('#employee3').val()!='' && $("#employee3").val()!=0) {
													url='validateEmployee.php?code=8383&id='+$("#employee3").val()+'&rand='+Math.random();
													$.ajax({url: url, success:
														function(data) {
															if (data != 'OK-Employee Found') {
																alert('Invalid Employee Number #3');
																$('#btnStop').show();
																$('#employee3').focus();
															} else {
																stopclicked=1;
																$("#editForm").submit();
															}
														}
													});
												} else {
													stopclicked=1;
													$("#editForm").submit();
												}
											}
										}
									});
								} else {
									stopclicked=1;
									$("#editForm").submit();
								}
							}
						}
					});
				}
			}
		}
	}

    var stopclicked=0;

    <?php
	if ($employee==-1) {
		print "window.opener.document.location.reload();\n";
		print "setTimeout(function() {self.close();}, 1000);\n";	}

    ?>
    <?php
        if (! $showScan) {
    ?>
    function updateLoadProgress() {
        start=document.getElementById('start').value;
        url='getProgress.php?start='+start+'&totalminutes=<?=$totalMinutes?>&rand='+Math.random();
        $.ajax({url: url, success: function(data) {
            $('#loadProgress').width(data);
            setTimeout(function() {
                                    updateLoadProgress();
                    }, 300000);
                    }
        });
    }
    setTimeout(function() {
        updateLoadProgress();
    }, 300000);

    <?php } ?>

    function checkCode(codetocheck) {
        if (codetocheck == '87921') {
            $('#btnStop').show();
            $('#override').hide();
        }
    }

    function printLabels() {
        url='renderLabelSmall.php?rand='+Math.random();
        url=url+'&scan='+$('#scan_sent').val()+'&qty='+$('#label_count').val();
        window.open(url,'_blank');
    }
</script>