<?php
    include('dbConnection.php');
    ## session start is now in dbconnection.php;
    include('security.php');
    include('functions.php');
    echo "<script>function page_init() { }</script>";
    include('header.php');

    //Josh 02-08-2022

    $type = "all";
    if ($isAdmin) $type = "admin";
    else if ($userSalesPersonID > 0) $type = "salesperson";

    echo renderPanel("System Settings", "", "red");

    $sql = "select distinct ss.name, ss.setting, ss.field_type from system_settings ss, system_settings_user ssu where (ssu.employee=? or ssu.employee=? or ssu.employee=? or ssu.employee=?) and ssu.setting_id=ss.setting_id";
    list($rs,$err) = runIQuery($db, $sql, ["ssss", $type, $userID, $userEmail, $userEmployeeID]);


    echo "<table class='table table-bordered'>
        <tr>
            <th>Setting</th>
            <th>Value</th>
        </tr>
    ";

$scripts=array();
    foreach ($rs as $data) {
        $settingName=str_replace("qr","QR",$data["name"]);
        $settingName=str_replace("_", " ", $settingName);
        $settingName=ucwords($settingName);
        echo "<tr>
            <th>" . $settingName . "</th>";
            echo "<th>";
            if ($data["field_type"] == "date") {
                echo renderDateBox(false, $data["name"], date("m/d/Y", strtotime($data["setting"])), "");
                $scripts[] = "$('#" . $data["name"] . "').datepicker();";
            } else if ($data["field_type"] == "B") {
                echo renderCheckBox(false, $data["name"], $data["setting"], "");
            } else  {
                echo renderTextArea(FALSE,$data['name'],$data['setting'],"") ;
                $scripts[] = "document.getElementById('" . $data['name'] . "').style.width='300px;';";
            }
            echo "</th>";
            echo "<th>" . renderButton("Apply", "green", "applySetting('" . $data["name"] . "')") . "</th>
        </tr>";
    }

    echo "</table>";
    echo renderEndItem();

    echo "<script>
        function applySetting(setting) {
            console.log(setting);
            console.log($('#'+setting).val());
            $.post('systemSettingsApply.php', {setting: setting, val: $('#'+setting).val(), rand: Math.random()}, function(resp) {
                if (resp == 'success') {
                    $.gritter.add({
                        title: 'Success',
                        text: 'Applied Successfully',
                        fade: true
                    });
                } else {
                    $.gritter.add({
                        title: 'Fail',
                        text: resp,
                        fade: true
                    });
                }
            });
        }
    </script>";

    echo "<script>function page_init() { \n";
        foreach ($scripts as $script) {
            echo $script;
            echo "\n";
        }
         echo "}</script>\n";
    
    include('footer.php');
?>