<?php

include('dbConnection.php');
include('functions.php');
$start = $_GET["start"];
$end = $_GET["end"];
$st = rtrim(formatDateWebtoDB($start));
$et = rtrim(formatDateWebtoDB($end));

$department = $_GET["department"];

$sql = "select customers.name as customer_name, surveys.name as survey_name, surveys.department, surveys.address, surveys.date_added, surveys.average, surveys.comments, surveys.reliability, surveys.quality, surveys.packaging, surveys.identification, surveys.friendly, surveys.pricing, surveys.satisfaction, surveys.recommends from surveys inner join customers on customers.customer_id=surveys.customer_id where surveys.date_added between '$st' and '$et'";

if ($department != "all") $sql .= "and surveys.department='$department'";
$sql .= " ORDER BY date_added DESC, department DESC";

list($rs,$err) = runIQuery($db, $sql);

$csv = "Customer\tName\tDept.\tDate\tAddress\tAvg. Rating\tComments\tSatisfaction\tRecommends\tReliability";

if ($department == "all" || $department == "builder") $csv .= "\tQuality";
if ($department == "all" || $department == "builder" || $department == "shipping") $csv .= "\tPackaging\tPart Identification";
if ($department == "all" || $department == "buyer" || $department == "shipping") $csv .= "\tFriendly";
if ($department == "all" || $department == "buyer") $csv .= "\tPricing";

$csv .= "\n";

foreach ($rs as $data) {
        $csv .= $data["customer_name"];
        $csv .= "\t" . $data["survey_name"];
        $csv .= "\t" . $data["department"];
        $csv .= "\t" . formatDateDBToWeb($data["date_added"]);
        $csv .= "\t" . $data["address"];
        $csv .= "\t" . $data["average"];
        $csv .= "\t" . $data["comments"];
        $csv .= "\t" . $data["satisfaction"];
        $csv .= "\t" . $data["recommends"];
        $csv .= "\t" . $data["reliability"];

        if ($department == "all" || $department == "builder") {
            $quality = $data["quality"];
            if (!$quality) $quality = "N/A";
            $csv .= "\t" . $quality;
        }
        if ($department == "all" || $department == "builder" || $department == "shipping") {
            $pack = $data["packaging"];
            if (!$pack) $pack = "N/A";
            $csv .= "\t" . $pack;

            $ident = $data["identification"];
            if (!$ident) $ident = "N/A";
            $csv .= "\t" . $ident;
        }

        if ($department == "all" || $department == "buyer" || $department == "shipping") {
            $friend = $data["friendly"];
            if (!$friend) $friend = "N/A";
            $csv .= "\t" . $friend;
        }
        if ($department == "all" || $department == "buyer") {
            $price = $data["pricing"];
            if (!$price) $price = "N/A";
            $csv .= "\t" . $price;
        }
    $csv .= "\n";
}

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"$department-survey-$start-$end.xls\"");

print $csv;
?>