<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');

$start = "01/01/" . Date("Y");
$end = "12/31/" . Date("Y");

$department = "all";
if (isset($_GET["department"])) $department = $_GET["department"];

if (isset($_GET["start"])) $start = $_GET["start"];
if (isset($_GET["end"])) $end = $_GET["end"];
$st = formatDateWebtoDB($start);
$et = formatDateWebtoDB($end);

print renderPanel("Survey Results", "", "green", "span11", "star");
print "<form name='findform' action='surveyResults.php' method='GET'>";
print renderDateBox(TRUE, "start", $start, "Start Search");
print renderDateBox(TRUE, "end", $end, "End Search");
print "<div class='span3'><div class='control-group span11'><label class='control-label'>Dept. Search</label><div class='controls'><select class='form-control chosen-select' name='department' id='department' style='background-color: white;'>\
<option value='all'>All</option>\
<option value='builder'" . ($department == "builder" ? " selected" : "") .">Builder</option>\
<option value='buyer'" . ($department == "buyer" ? " selected" : "") .">Buyer</option>\
<option value='shipping'" . ($department == "shipping" ? " selected" : "") .">Shipping</option>\
</select></div></div></div>";
print "<div class='span3'><div class='control-group span11'><label class='control-label'>‎</label><div class='controls'>" . renderButton("Find", "green", "document.findform.submit();") . renderButton("Export", "blue", "exportResults();") . "</div></div></div>";
print "</form>";
$count = 16;
if ($department == "builder" || $department == "shipping") $count = 14;
if ($department == "buyer") $count = 13;
if ($count > 0) {
    print "<style>th { width: " . (100/$count) . "%; } </style>";
}
print "<table class='table table-striped'>";
print "<thead><tr>";
//columns, buyer(get name from id), name, department, address (addr, city, state, zip), average, comments, values (for department)
print "<th>buyer</th><th>Name</th><th>Dept.</th><th>Date</th><th>Address</th><th>Avg. Rating</th><th>Comments</th><th>Satisfaction</th><th>Recommends</th><th>Reliability</th>";

if ($department == "all" || $department == "builder") print "<th>Quality</th>";
if ($department == "all" || $department == "builder" || $department == "shipping") {
    print "<th>Packaging</th>";
    print "<th>Part Identification</th>";
}

if ($department == "all" || $department == "buyer" || $department == "shipping") print "<th>Friendly</th>";
if ($department == "all" || $department == "buyer") print "<th>Pricing</th>";

print "</tr></thead>";
print "<tbody>";
//rows


$sql = "select customers.name as customer_name, customers.customer_id, surveys.company, surveys.name as survey_name, surveys.department, surveys.address, surveys.date_added, surveys.average, surveys.comments, surveys.reliability, surveys.quality, surveys.packaging, surveys.identification, surveys.friendly, surveys.pricing, surveys.satisfaction, surveys.recommends from surveys inner join customers on customers.customer_id=surveys.customer_id where surveys.date_added between '$st' and '$et' and surveys.company='DEV'";
if ($department != "all") $sql .= " and surveys.department='$department'";

$sql .= " ORDER BY date_added DESC, department DESC";
list($rs,$err) = runIQuery($db, $sql);

$address = $data["address"];




foreach ($rs as $data) {
    $address = $data["address"];
    if ($address == ",  , 0") $address = "";

    print "<tr>";
        print "<td>" . $data["customer_name"] . "</td>";
        print "<td>" . $data["survey_name"] . "</td>";
        print "<td>" . $data["department"] . "</td>";
        print "<td>" . formatDateDBToWeb($data["date_added"]) . "</td>";
        print "<td>" . $address . "</td>";
        print "<td>" . $data["average"] . "</td>";
        print "<td>" . $data["comments"] . "</td>";
        print "<td>" . $data["satisfaction"] . "</td>";
        print "<td>" . $data["recommends"] . "</td>";
        print "<td>" . $data["reliability"] . "</td>";

        if ($department == "all" || $department == "builder") {
            $quality = $data["quality"];
            if (!$quality) $quality = "N/A";
            print "<td>$quality</td>";
        }
        if ($department == "all" || $department == "builder" || $department == "shipping") {
            $pack = $data["packaging"];
            if (!$pack) $pack = "N/A";
            print "<td>$pack</td>";

            $ident = $data["identification"];
            if (!$ident) $ident = "N/A";
            print "<td>$ident</td>";
        }

        if ($department == "all" || $department == "buyer" || $department == "shipping") {
            $friend = $data["friendly"];
            if (!$friend) $friend = "N/A";
            print "<td>$friend</td>";
        }
        if ($department == "all" || $department == "buyer") {
            $price = $data["pricing"];
            if (!$price) $price = "N/A";
            print "<td>$price</td>";
        }
    print "</tr>";
}

print "</tbody>";
print "</table>";
?>

<script>
    function exportResults() {
        window.open("surveyResultsExport.php?start=<?=$start?>&end=<?=$end?>&department=<?=$department?>", "exporter");
    }
</script>

<?php
include('footer.php');
?>