<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Stock Sheet Goods";
include('header.php');
$material=0;
if (isset($_POST['material'])) {
    $material=$_POST['material'];
}
$vendor=0;
if (isset($_POST['vendor'])) {
    $vendor=$_POST['vendor'];
}

print renderPanel("Stock Sheet Goods","","primary");
print "<form name='listform' method='POST' action='stockSheetGoods.php'>\n";
$sql="select distinct m.material_id, material_name from materials m, items i where m.material_name=i.item_name and item_category=1 and i.vendor_id <> 4  order by material_name";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"material",$material,"Material","N",$rs,1,"","document.listform.submit()");
## no mcmaster
$sql="select distinct v.vendor_id, vendor_name from vendors v, items i where v.vendor_id=i.vendor_id and item_category=1 and v.vendor_id <> 4 order by vendor_name ";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"vendor",$vendor,"Vendor","N",$rs,1,"","document.listform.submit()");
if ($vendor) {
    print renderButton("Create PO","primary","createPO();");
}
print "<div style='clear: both;'></div>\n";
print "<table class='table dtable'>";
print "<thead>";
print "<tr>";
print "<th>Seq</th>";
print "<th valign='top'>";
print "Item Name";
print "</th>";
print "<th valign='top'>";
print "Length";
print "</th>";
print "<th valign='top'>";
print "Width";
print "</th>";
print "<th valign='top'>";
print "Vendor";
print "</th>";
print "<th valign='top' align='right'>";
print "Safety Stock";
print "</th>";
print "<th valign='top' align='right'>";
print "Order Increment";
print "</th>";
print "<th align='right'>Material</th>";
print "<th>";
print "Quantity On Hand";
print "</th>";
print "<th>";
print "Update QOH";
print "</th>";
print "<th>";
print "Quantity On Order";
print "</th>";
if ($vendor) {
    print "<th>Add To PO</th>";
}
print "</tr>\n";
print "</thead>";
print "<tbody>";
$sql="select item_id, item_name, length, width, i.vendor_id, vendor_name, safety_stock, order_increment, material_name, quantity_on_hand, ";
$sql.=" coalesce(stock_sheet_sequence.display_sequence,9999) as display_sequence  ";
$sql.=" from items i left  outer join vendors v on i.vendor_id=v.vendor_id left outer join materials m on i.material_id=m.material_id ";
$sql.="  left outer join stock_sheet_sequence on item_name=stock_sheet ";
$sql.=" where item_category=1 and i.vendor_id <> 0 and i.vendor_id <> 4";

if ($material) {
    $sql.=" and i.material_id=? ";
    if ($vendor) {
        $sql.=" and i.vendor_id=? ";
        $sql.=" order by stock_sheet_sequence.display_sequence ";
        list($rs,$err)=runIQuery($db,$sql,array("ii",$material,$vendor));
    } else {
        $sql.=" order by stock_sheet_sequence.display_sequence ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$material));
    }
} else {
    if ($vendor) {
        $sql.=" and i.vendor_id=? ";
        $sql.=" order by stock_sheet_sequence.display_sequence ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$vendor));
    } else {
        $sql.=" order by stock_sheet_sequence.display_sequence ";
        list($rs,$err)=runIQuery($db,$sql);
    }
}
$i=0;
foreach ($rs as $data) {
    $i++;
    $seq=$data['display_sequence'];
    $itemID=$data['item_id'];
    $item=$data['item_name'];
    $length=$data['length'];
    $width=$data['width'];
    $vendorName=$data['vendor_name'];
    $vendorID=$data['vendor_id'];
    $safety=$data['safety_stock'];
    $increment=$data['order_increment'];
    $material=$data['material_name'];
    $qty=$data['quantity_on_hand'];
    $sql="select l.* from purchase_orders p, po_lines l where p.status not in (2,4) and p.po_id=l.po_id and quantity > quantity_received and item_id=? order by line_id ";
    list($lrs,$err)=runIQuery($db,$sql,array("s",$item));
    $totalExpected=0;
    $potext="";
    if (count($lrs)>0) {
        $potext="<table><tr><td>PO#</td><td>&nbsp;&nbsp;</td><td>Qty Open</td><td>Date Expected</td></tr>\n";
        foreach ($lrs as $ldata) {
            $po=$ldata['po_id'];
            $qtyExpected=$ldata['quantity'] - $ldata['quantity_received'];
            $totalExpected+=$qtyExpected;
            $dt=formatDateDBToWeb($ldata['date_expected']);
            $potext.="<tr><td><a href='editPO.php?id=$po' target='_blank' rel='opener'>$po</td><td></td><td>$qtyExpected</td><td>$dt</td></tr>\n";
        }
        $potext.="</table>";
    }
    print "<tr class='vendor$vendorID' ";
    if ($qty + $totalExpected < $safety) {
        print " style='color: red;' ";
    }

    // Start Reduce Decimal Count -Josh 03-07-2022
    $length = number_format($length, 2, '.', ',');
    $width = number_format($width, 2, '.', ',');
    $qty = number_format($qty, 0, '.', ',');
    // End Reduce Decimal Count

    print ">";
    print "<td valign='top'>$seq</td>";
    print "<td valign='top'>$item</td>";
    print "<td valign='top'>$length</td>";
    print "<td valign='top'>$width</td>";
    print "<td valign='top'>$vendorName</td>";
    print "<td valign='top'>$safety</td>";
    print "<td valign='top'>$increment</td>";
    print "<td valign='top'>$material</td>";
    //update quantity on hand so that QoH is readonly and the amount you want to add or take away is number input with submit button Brittany 6/30/22
    print "<td valign='top'>";
    print "<div type='text' id='qty$itemID' value='$qty'>$qty</div>";
    print "</td>";
    print "<td>";
    print "<form name='adjform' action='stockSheetGoods.php' method='POST'>";
    print "<input type='number' step='1' name='adj' id='adj' value='0' style='width: 60px;' title='Amount to add/subtract'>";
    print "<button class='btn btn-primary' onclick=\"updateQOH('$qty',adj.value,'$itemID');\">Update</button>";
    print "</form>";
    //end qoh changes
    print "</td>";
    print "<td valign='top'>";
    print $potext;
    print "</td>";
    if ($vendor) {
        print "<td><input type='checkbox' name='sel$i' value='$itemID'>";
        print "<input type='hidden' name='qty$i' value='" . abs($diff) . "'>";
        print "</td>";
    }
    print "</tr>\n";
}
print "</tbody>";
print "</table>";
print "<input type='hidden' name='totalrows' id='totalrows' value='$i'>";
print "</form>\n";
print renderClosePanel();

?>
<script>
    //rather than being updated onChange, this will now fire on submit
function updateQOH(qty,adj,itemid) {
    qty=parseInt(qty);
    adj=parseInt(adj);
    url=`checkForUpdates.php?qty=${qty}&item=${itemid}`;
    $.ajax({url: url, success: function(data){
                if (data=="All good") {
                    let newqty=qty+adj;
                    url='updateItemQOH.php?rand='+Math.random()+'&item='+itemid+'&qty='+newqty;
                    $.ajax({url: url, success: function(data){
                        // aurl=`acknowledgeUpdate.php?id=${data}`;
                        // $.ajax(aurl);
                    }});
                } else {
                    alert(data);
                }
                
    }}); 
}
function page_init() {
    $('.dtable').dataTable({"bPaginate" : false});
}
function createPO() {
	document.listform.action='createSheetPO.php';
	document.listform.target='_blank';
	document.listform.submit();
	document.listform.action='stockSheetGoods.php';
	document.listform.target='_self';
}
</script>
<?php
include('footer.php');
?>