<?php
include('dbConnection.php');
include('security.php');
include('functions.php');

$export=0;
if (isset($_POST["export"])) {
    $export=$_POST["export"];
}

if (!$export) {
    include('header.php');
}

if (isset($_POST['start'])) {
	$start=$_POST['start'];
	$end=$_POST['end'];
} else {
	$start=Date("m/d/Y");
	$end=Date("m/d/Y");
    if (isset($_GET['start_date'])) {
        $start=$_GET['start_date'];
    }
    if (isset($_GET['end_date'])) {
        $end=$_GET['end_date'];
    }
}

$employee=0;
if (isset($_POST['employee'])) {
    $employee=$_POST['employee'];
}
$sql="select * from departments where lead_email=?";
list($rs,$err)=runIQuery($db,$sql,array("s",$userEmail));

if (! count($rs)) {
	$canView=0;
	$employee=$userEmployeeID;
	if (! $employee) {
		include('footer.php');
		exit;
	}
} else {
	$canView=1;
}

if (!$export) {
print renderPanel("Staging Performance","Staging","primary","span11");
print "<p>This report will show order count cleared for the date/time range</p>";
print "<form name='findform' action='stagingPerformanceReport.php' method='POST'>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
if ($canView) {
    $sql="select employee_id, concat(last_name,', ',first_name) as fullname from employees where inactive=0 and department_id=4 order by last_name, first_name ";
    list($rs,$err)=runIQuery($db,$sql);
    print renderSelect(TRUE,"employee",$employee,"Employee","N",$rs,1);    
}
print renderButton("Find","primary","document.findform.submit();");
print "<div style='clear: both;'></div>";
print "</form>\n";
}
$st=formatDateWebToDB($start);
$et=formatDateWebToDB($end);

$sql="select full_name, employee_link, h.user_id, e.shift, sum(ABS(quantity)) as dailytotal from staging_bay_history h, site_admins a, employees e  ";
$sql.=" where  DATE(h.date_loaded) >= '$st' and DATE(h.date_loaded) <= '$et' and h.action ='LOAD' and h.user_id=a.user_id  ";
$sql.=" and a.employee_link=e.employee_id  ";
if ($employee) {
    $sql.=" and a.employee_link=$employee ";
}
$sql.=" group by full_name, employee_link, h.user_id, e.shift ";
$sql.=" order by full_name  ";

if (!$export) {
print "<table class='table table-striped'><thead><tr>";
print "<th>Who</th>";
print "<th>Clocked Minutes</th>";
print "<th align='right'>Loaded/Cleared Pieces</th>";
print "<th align='right'>Actual Pieces/Hour</th>";
print "<th align='right'>Planned Pieces/Hour</th>";
print "<th>% to Plan</th>";
print "</tr>";
print "</thead>";
print "<tbody>";
} else {
    print "Who\tClocked Minutes\tLoaded\Cleared Pieces\tActual Pieces/Hour\tPlanned Pieces/hour\t% to Plan\n";
}
list($rs,$err)=runIQuery($db,$sql);
$total=count($rs);
$subtotal=0;
$holdkey="";
foreach ($rs as $data) {
	$who=$data['full_name'];
	$qty=abs($data['dailytotal']);
    $employee=$data['employee_link'];
    $action=$data['action'];
    $user=$data['user_id'];
    $shift=$data['shift'];
    $qty=$data['dailytotal'];
    $sql="select sum(regular_minutes+ot_minutes) as minutes from clock_punches where employee_id=? and DATE(in_date)>=? and DATE(out_date) <= ?";
    list($mrs,$err)=runIQuery($db,$sql,array("iss",$employee,$st,$et));
    $minutes=$mrs[0][0];
    $hours=round($minutes/60,2);
    $pph=0;
    if ($hours > 0) {
        $pph=round($qty/$hours,0);
    }
    $pct=round($pph/300*100,1);
    if (!$export) {
    print "<Tr>";
    print "<td>$who</td>";
    print "<td>$minutes</td>";
    print "<td>";
    print $qty;
    print "</td>";
    print "<td>";
    print $pph;
    print "</td>";
    print "<td>";
    print "300";
    print "</td>";
    print "<td>";
    print $pct;
    print " %";
    print "</td>";
    print "</tr>\n";
    } else {
        print "$who\t";
        print "$minutes\t";
        print "";
        print $qty;
        print "\t";
        print "";
        print $pph;
        print "\t";
        print "";
        print "300";
        print "\t";
        print "";
        print $pct;
        print " %";
        print "\t";
        print "\n";
    }
}
if (!$export) {
print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>
	function page_init() {
		$('.datepicker').datepicker();
	}
</script>
<?php
include('footer.php');
}
?>
