<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');


if (isset($_POST['start'])) {
	$start=$_POST['start'];
	$startTime=$_POST['start_time'];
	list($hm,$ampm)=explode(" ",$startTime);
	list($sh,$sm)=explode(":",$hm);
	if ($ampm == "PM") {
		$sh+=12;
	} else {
		if ($sh == "12") {
			$sh="00";
		}
	}
	$end=$_POST['end'];
	$endTime=$_POST['end_time'];
	list($hm,$ampm)=explode(" ",$endTime);
	list($eh,$em)=explode(":",$hm);
	if ($ampm == "PM") {
		$eh+=12;
	} else {
		if ($eh == "12") {
			$eh="00";
		}
	}
	$sortby=$_POST['sortby'];
} else {
	$start=Date("m/d/Y");
	$end=Date("m/d/Y");
	$startTime="12:00 AM";
	$endTime="11:59 PM";
	$sh="00";
	$sm="00";
	$eh="23";
	$em="59";
	$sortby="date_loaded";
}	

print renderPanel("Staging Performance","Staging","primary","span11");
print "<p>This report will show orcer count cleared for the date/time range</p>";
print "<form name='findform' action='stagingPerformance.php' method='POST'>";
print renderButton("Find","primary","document.findform.submit();");
print "<div style='clear: both;'></div>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderTimePicker(TRUE,"start_time",$startTime,"Start Time");
print renderDateBox(TRUE,"end",$start,"End Date");
print renderTimePicker(TRUE,"end_time",$endTime,"End Time");
print renderStartItem(TRUE,"sort","Sort By");
print "<select name='sortby' id='sortby'><option value='full_name'>Who Cleared</option><option value='date_loaded'>Date Loaded</option>";
print "<option value='folder_number' ";
if ($sortby == "folder_number") {
	print " selected ";
}
print ">Folder</option>";
print "</select>";
print renderEndItem();
print "</form>\n";
$st=formatDateWebToDB($start);
$et=formatDateWebToDB($end);
$sql="select distinct folder_number, date_loaded, full_name from staging_bay_history h, site_admins a  where  bay_name not like 'W%' and h.date_loaded >= '$st $sh:$sm:00' and h.date_loaded <= '$et $eh:$em:00' and h.action = 'CLEAR' and h.user_id=a.user_id  order by $sortby ";
print "<table class='table table-striped'><thead><tr>";
print "<td>Date Cleared</td>";
print "<td>Who Cleared</td>";
print "<td>Sales Order</td>";
print "<td>Quantity</td>";
print "</tr>";
print "</thead>";
print "<tbody>";
list($rs,$err)=runIQuery($db,$sql);
$total=count($rs);
$subtotal=0;
$holdkey="";
foreach ($rs as $data) {
	$cleared=formatDateDBToWeb($data['date_loaded']);
	$order=$data['folder_number'];
	$who=$data['full_name'];
	$sql="select sum(quantity) from orders, order_lines where folder_number=? and orders.order_id=order_lines.order_id  ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$order));
	$data=$rs[0];
	$qty=$data[0];
	$subtotal+=$qty;
	print "<Tr><td>$cleared</td>";
	print "<td>$who</td>";
	print "<td>";
	print $order;
	print "</td>";
	print "<td align='right'>";
	print $qty;
	print "</td>";
	print "</tr>\n";
}
if ($holdkey) {
	print "<tr><td colspan='3'>Parts for $holdkey</td><td colspan=1 align='right'>";
	print $subtotal;
	print "</td>";
}
print "<tr><td colspan='3' align='center'>Order Count: $total</td></tr>\n";
print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>
	function page_init() {
		$('.datepicker').datepicker();
		$('.timepicker').timepicker();
	}
</script>
<?php
include('footer.php');
?>
