<?php

include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (isset($_POST['start'])) {
	$start=$_POST['start'];
	$startTime=$_POST['start_time'];
	list($hm,$ampm)=explode(" ",$startTime);
	list($sh,$sm)=explode(":",$hm);
	if ($ampm == "PM") {
		$sh+=12;
	} else {
		if ($sh == "12") {
			$sh="00";
		}
	}
	$end=$_POST['end'];
	$endTime=$_POST['end_time'];
	list($hm,$ampm)=explode(" ",$endTime);
	list($eh,$em)=explode(":",$hm);
	if ($ampm == "PM") {
		$eh+=12;
	} else {
		if ($eh == "12") {
			$eh="00";
		}
	}
	$sortby=$_POST['sortby'];
} else {
	$start=Date("m/d/Y");
	$end=Date("m/d/Y");
	$startTime="12:00 AM";
	$endTime="11:59 PM";
	$sh="00";
	$sm="00";
	$eh="23";
	$em="59";
	$sortby="date_loaded";
}	

print renderPanel("Staging Bay History","Staging","blue","span11");
print "<p>This report will show all items cleared for the date/time range and compare against what has shipped</p>";
print "<form name='findform' action='stagingHistory.php' method='POST'>";
print renderButton("Find","green","document.findform.submit();");
print "<div style='clear: both;'></div>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderTimePicker(TRUE,"start_time",$startTime,"Start Time");
print renderDateBox(TRUE,"end",$start,"End Date");
print renderTimePicker(TRUE,"end_time",$endTime,"End Time");
print renderStartItem(TRUE,"sort","Sort By");
print "<select name='sortby' id='sortby'><option value='date_history'>Date Loaded</option>";
print "<option value='order_number' ";
if ($sortby == "order_number") {
	print " selected ";
}
print ">Sales Order</option>";
print "<option value='h.item_id' ";
if ($sortby == "h.item_id") {
	print " selected ";
}
print ">Part #</option>";
print "</select>";
print renderEndItem();
print "</form>\n";
$st=formatDateWebToDB($start);
$et=formatDateWebToDB($end);

print "<table class='table table-striped'><thead><tr>";
print "<td>Bay</td>";
print "<td>Date Cleared</td>";
print "<td>Part</td>";
print "<td>Quantity Cleared</td>";
print "<td>Who Cleared</td>";
print "<td>Sales Order</td>";
print "<td>Date Due</td>";
print "<td>Packing Slip</td>";
print "<td>Loaded By</td>";
print "<td>Quantity Shipped</td>";
print "</tr>";
print "</thead>";
print "<tbody>";

$sql = "SELECT sb.bay_name, h.date_history, h.order_number, h.item_id, h.quantity AS cleared_quantity, 
ol.due_date, ps.packing_list_id, ps.quantity AS shipped_quantity, sa.full_name 
FROM staging_bay_history h
INNER JOIN staging_bays sb ON h.bay_id=sb.bay_id
INNER JOIN order_lines ol ON h.line_id=ol.line_id AND h.item_id=ol.item_id AND h.order_number=ol.order_id
INNER JOIN site_admins sa ON h.user_id=sa.user_id
LEFT JOIN packing_slip_lines ps ON ps.order_id=ol.order_id AND ps.order_line=ol.line_id AND ps.part_number=h.item_id
WHERE sb.bay_type IN (1,5) AND h.date_history >= '$st $sh:$sm:00' AND h.date_history <= '$et $eh:$em:00' AND h.action = 'CLEAR' ORDER BY $sortby ";
list($rs,$err)=runIQuery($db,$sql);
foreach($rs as $data) {
    $bay=$data['bay_name'];
    $due=formatDateDBToWeb($data['due_date']);
    $cleared=formatDateDBToWeb($data['date_history']);
    $part=$data['item_id'];
    $qty=abs($data['cleared_quantity']);
    $order=$data['order_number'];
    $packslip=$data['packing_list_id'];
    $shippedQty = 0;
    $shippedQty=$data['shipped_quantity'];
    $who=$data['full_name'];

    $sql="SELECT DISTINCT full_name FROM staging_bay_history h, site_admins sa 
    WHERE `action`='LOAD' and order_number=? and item_id=? and h.user_id=sa.user_id";
	list($wrs,$err)=runIQuery($db,$sql,array("is",$order,$part));
    $whoLoaded=$wrs[0][0];


    print "<tr>";
    print "<td>$bay</td>";
    print "<td>$cleared</td>";
    print "<td>$part</td>";
    print "<td>$qty</td>";
    print "<td>$who</td>";
    print "<td>$order</td>";
    print "<td>$due</td>";
    print "<td>$packslip</td>";
    print "<td>$whoLoaded</td>";
    print "<td>$shippedQty</td>";
    print "</tr>";

}
print "</tbody></table>";
print renderClosePanel();
?>
<script>
	function page_init() {
		$('.datepicker').datepicker();
		$('.timepicker').timepicker();
	}
</script>
<?php
include('footer.php');
?>