<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
if (isset($_POST['bay'])) {
	$bay=$_POST['bay'];
}
$bayIndex = 0;

print renderPanel("Staging Bays Manipulation","Staging","blue","span11");
if (! isset($_POST['bay'])) {
	print "<form id='bay_form' name='bay_form' action='stagingBays.php' method='POST'>";
	print "<div style=display:flex;flex-direction:row>";
	print renderTextBox(TRUE,"bay","","Enter Bay (blank for all)");	
	print "<div class='btn green' style='height: 21px; width: 30px; margin-top: 25px; margin-left: -25px;' onclick='document.bay_form.submit();'>Find</div>";
	print "</div>";
	print "</form>";
} else {	

	## tabs for filtering selection
	print "<div id='btnContainer'>";
	print "<div style='width: 60px; align-items:center;' class='btn bayFilter' onclick='filterBays(`All`)'>All</div>\n";
	//print "<div style='width: 60px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Holland`)'>Holland</div>\n";
	//print "<div style='width: 60px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Jenison`)'>Jenison</div>\n";
	print "<div style='width: 60px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Finished Goods`)'>Finished</div>\n";
	print "<div style='width: 80px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Pre-Powder`)'>Pre-Powder</div>\n";
	print "<div style='width: 80px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Post-Powder`)'>Post-Powder</div>\n";
	print "<div style='width: 60px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Weldment`)'>Weldment</div>\n";
	print "<div style='width: 60px; align-items:center;' class='btn bayFilter' onclick='filterBays(`Assembly`)'>Assembly</div>\n";
	print "</div>\n";
	print "<br><br>";

	print "<table class='table table-striped'><thead><tr>";
	print "<th>Bay</th>";
	print "<th>Order</th>";
	print "<th>Inspection (If Required)</th>";
	print "<th>Loaded</th>";
	print "<th>Ready?</th>";
	print "<th>Parts</th>";
	print "<th>Notes</th>";
	print "<th>Parts Already Shipped</th>";
	print "</tr>";
	print "</thead>";
	print "<tbody>\n";

	## get all bays and any orders associated with them
	if ($bay) {
		$sql="SELECT * FROM staging_bays WHERE bay_name=?";
		list($brs,$err)=runIQuery($db,$sql,array("s",$bay));
	} else {
		$sql="SELECT * FROM staging_bays WHERE business_unit = ? ORDER BY business_unit DESC, bay_type, bay_name ";
		list($brs,$err)=runIQuery($db,$sql,array("i",$businessUnit));
	}

	foreach ($brs as $bdata) {
		$bayID=$bdata['bay_id'];
		$bayName=$bdata['bay_name'];
		$order=$bdata['order_id'];
		$dateLoaded=formatDateDBToWeb($bdata['date_loaded']);
		$bayType=$bdata['bay_type'];
		$busUnit = $bdata['business_unit'];
		$palletUpdated = 0;
		$inspectionRequired = $bdata['inspection_required'];

		$bayReady = 1;
		$readyMessage = "";
		$readyMessageBody = "";


		print "<tr class='bay_container' data-baytype='$bayType' data-businessunit='$busUnit'>";
		print "<td id='bayName$bayName' data-baytype='$bayType'>";
		print $bayName;
		print "<div id='clearBtn$bayIndex' style=' display: none; width: 60px; align-items:center;' class='btn red clearBtn$bayID hide$bayID' onclick='clearBay($bayID,$order,$bayType,$inspectionRequired)'>CLEAR</div>";
		print "<div id='bay_dropdown$bayID' style='margin-right: 10px; display: none'>";
		print "<label for='bayOptions'>Select Which Bay You Would Like to Move to</label>";
		print "<select name='bayOptions' id='bayOptions$bayID'></select> ";
		print "</div>";
		print "<div id='moveBtn$bayIndex' style=' display: none; width: 60px; align-items:center;' class='btn blue move$bayID' onclick='moveBay($bayID,$order,$bayType)'>MOVE ALL</div>";
		$bayIndex++;
		print "</td>";
		print "<td><p class='hide$bayID'>";
		if ($order) {
			print $order;
		}
		print "</p><br>";
		## how many pallets are there in the bay?
		if ($order) {
			$sql = "SELECT * FROM pallets WHERE assigned_bay=? AND cleared_from_bay IS NULL AND order_id=? ORDER BY bay_sequence ASC";
			list($pallet_rs,$err)=runIQuery($db,$sql,array("ii",$bayID,$order));
			$palletCount = count($pallet_rs);
			print "$palletCount Pallet(s) in this Bay";
		}
		print "</td>";
		print "<td>";
		print "<div class='hide$bayID'>";
		if ($order) {
			if ($inspectionRequired) {
				print "<input class='inspection_required' type='checkbox' id='inspection$bayID' value='$bayID' onclick='inspectOrder($bayID,$order)'>";
				print "<label for='inspection$bayID'>Order has been inspected</label>";
			}
		}
		print "</div>";
		print "</td>";
		print "<td><p class='hide$bayID'>";
		if ($dateLoaded != '00/00/0000') {
			print $dateLoaded;
		}
		print "</p>";
		if ($order) {
			if ($inspectionRequired) {
				print "<p style='color:green'><b>This order must be inspected before it can be cleared.</b></p>";
			}
		}
		print "</td>";	
		print "<td class='readyBlock ready$bayID'>";
		if ($order) {
			## treating pallets like mini bays, get info for the pallets
			$palletContainer="";
			$containsColors=0;
			$isComponentBay=0;
			$containsWaitingHighlight=0;

			if (count($pallet_rs) > 0) {
				foreach($pallet_rs as $pallet_data) {
					$palletID=$pallet_data['pallet_id'];
					$palletColor=$pallet_data['color'];
					$palletWO=$pallet_data['wo_parent'];
					$palletSeq=$pallet_data['bay_sequence'];
					$palletComplete=$pallet_data['complete'];
					$orderByColor=$pallet_data['color_only'];
					if ($palletComplete != 1) {
						$palletComplete = 0;
					} ## above and below if statements matter for the containsColors bit below for getMissingColors.php
					if ($palletWO || $orderByColor) {
						$isComponentBay = 1;
					}
					$colorCode="";
					$palletCard="";
					//$palletMessage="";
					$palletWaitingRows="";
					$palletReady = 1;
					if ($palletColor) {
						$containsColors = 1;
					}

					
					include('staging/getWaitingParts.php');

					if (count($waiting_rs) > 0) {  // for each pallet
												
						foreach ($waiting_rs AS $waiting_data) {
							$prodResultsOtherLocation = 0;
							$background = "";
							$waitingPart=$waiting_data['item_id'];
							$ol=$waiting_data['line_id'];
							if ($waiting_data['child_item']) {
								$waitingPart=$waiting_data['child_item'];
							}
							$waitingQty=number_format($waiting_data['waiting_qty']);
			
							if ($waitingQty > 0) {
								## check if there are any production results for the part
								$sql = "SELECT job_id FROM jobs WHERE item_id=? AND line_id=?";
								list($rs,$err)=runIQuery($db,$sql,array("si",$waitingPart,$ol));
								if ($rs) {
									$busUnit == 1 ? $oppBusUnit = 2 : $oppBusUnit = 1;
									$wo=$rs[0][0];
									$sql = "SELECT * FROM production_results WHERE job_id=? AND business_unit=$oppBusUnit";
									list($rs,$err)=runIQuery($db,$sql,array("i",$wo));
									if (count($rs) > 0) {
										$containsWaitingHighlight = 1;
										$prodResultsOtherLocation = 1; // not really being used at the moment
										$background = "style='background-color: yellow;'";
									}
								}
								$bayReady = 0;
								$palletReady = 0;
								$palletWaitingRows.= "<tr><td $background>$waitingPart</td><td $background>$waitingQty</td></tr>";  ## put body of pallet container together here in the loop, then insert it after header, which can't go in the loop
							}
						}

						if ($palletReady) {
							if (!$palletComplete) {
								$sql="UPDATE pallets SET complete=1 WHERE pallet_id=?";
								list($rs,$err)=runIQuery($db,$sql,array("i",$palletID));
								$palletUpdated = 1;
							}
						} elseif (!$palletReady) {
							if ($palletComplete) {
								$sql="UPDATE pallets SET complete=NULL WHERE pallet_id=?";
								list($rs,$err)=runIQuery($db,$sql,array("i",$palletID));	
								$palletUpdated = 1;
							}
						}

						if (!$palletReady) {

							

							//$palletMessage.= "Waiting For Parts";
							// $palletMessage.="<table class='hide$bayID'><tr><th>Part</th><th>Quantity</th></tr>";
							// $palletMessage.=$palletMessageBody;
							// $palletMessage.="</table>";
							
						// } else {
						// 	$palletMessage="<p class='hidePallet$palletID'>Pallet $palletSeq READY</>";
						// }
						//if (!$palletReady) {
							## setting up container header
							$palletCard.= "<div class='pallet_card' data-palletready='$palletReady' data-palletcomplete='$palletComplete'>"; // pallet card
							$palletCard.= "<p style='text-align: center'><b>Pallet $palletSeq</b></p>";
							if ($palletColor) {
								$sql="SELECT color_code FROM vendor_colors WHERE vc_id=?";
								list($rs,$err)=runIQuery($db,$sql,array("i",$palletColor));
								if ($rs) {
									$colorCode = $rs[0][0];
									$palletCard.= "<p><b>Color: $colorCode</b></p>";
								}	
							}
							if ($palletWO) {
								$palletCard.= "<p><b>WO: $palletWO</b></p>";
							}
							## container header ^^
							$palletCard.="<table class='hidePallet$palletID'><tr><th>Part</th><th>Quantity</th></tr>";
							$palletCard.=$palletWaitingRows;
							$palletCard.="</table>";
							$palletCard.= "</div>";
							$palletContainer.=$palletCard;
		
						}
						// print $palletMessage;
						// if (!$palletReady) {
						// 	$palletCard.= "</div>"; // end of pallet container needs to move
						// }
						

						

					} else {  ## TODO need a way to feed individual pallet messages into the larger bay ready message to determine if it's good to go
						// if ($order && $bayReady) {
						// 	$readyMessage="<p class='hide$bayID' style='color:green'>BAY READY</>";
						// 	print $readyMessage;
						// }
					}
					## this section below will update the database if the pallet completion status is not correct
				
					
				}  ## END OF PALLET LOOP
			}
			$missingItems="";
			if ($containsColors || $orderByColor) {
				include('staging/getMissingColors.php');
				if (count($waitingColors_rs) > 0) {
					foreach($waitingColors_rs AS $waitingColors_data) {
						if ($waitingColors_data['waiting_qty'] > 0) {
							$bayReady = 0;
							$missingItem=$waitingColors_data['item_id'];
							if ($waitingColors_data['child_item'] && strlen($waitingColors_data['child_item']) > 0) {
								$missingItem=$waitingColors_data['child_item'];
							}
							$missingQty=number_format($waitingColors_data['waiting_qty']);
							$missingColor=$waitingColors_data['color_code'];
							if (!$missingColor) {
								$missingColor = "";
							}
							$missingItems.="<p>$missingItem - $missingQty - $missingColor</p>";
						}
					}
				}
			}
			print "<div class='hide$bayID'>";
			if ($order && $bayReady) {
				print "<p class='hide$bayID' style='color:green'>READY</p>";
			} elseif ($order && !$bayReady) {
				print "<p style='color:red'>WAITING FOR PARTS</p>";
				print "<div class='pallet_container'>";
				print $palletContainer;
				$palletContainer="";
				print "</div>";
				if (strlen($missingItems) > 0) {
					print "<p>The following items may be missing and will go on new pallets.</p>";
					print $missingItems;
				}
			}
			print "</div>";
			if ($containsWaitingHighlight) {
				print "<p style='background-color: yellow'>Highlighted parts in the waiting section show production results performed at another location.</p>";
			}
		}
		print "</td>"; ## END OF WAITING SECTION
		##### BAY CONTENTS DATA BELOW ##############
		
		//include('getBayContents.php');

	
		// if (count($waiting_rs) > 0) {
		
		// 	foreach ($waiting_rs AS $waiting_data) {
		// 		$waitingPart=$waiting_data['item_id'];
		// 		$waitingQty=number_format($waiting_data['waiting_qty']);

		// 		if ($waitingQty > 0) {
		// 			$ready = 0;
		// 			$readyMessageBody.= "<tr><td>$waitingPart</td><td>$waitingQty</td></tr>";
		// 		}
		// 	}
		// 	if (!$ready) {
		// 		$readyMessage.= "Waiting For Parts";
		// 		$readyMessage.="<table class='hide$bayID'><tr><th>Part</th><th>Quantity</th></tr>";
		// 		$readyMessage.=$readyMessageBody;
		// 		$readyMessage.="</table>";
		// 	} else {
		// 		$readyMessage="<p class='hide$bayID'>READY</>";
		// 	}
			
		// 	print $readyMessage;
		// } else {
		// 	if ($order) {
		// 		$readyMessage="<p class='hide$bayID'>READY</>";
		// 		print $readyMessage;
		// 	}
		// }
		//print "</td>"; ## END OF WAITING SECTION
		print "<td>"; ## staged block
		if ($order) {
			if ($palletUpdated) {  ## it will retrieve the pallet data if it had been updated in the previous section
				$sql = "SELECT * FROM pallets WHERE assigned_bay=? AND cleared_from_bay IS NULL AND order_id=? ORDER BY bay_sequence ASC";
				list($pallet_rs,$err)=runIQuery($db,$sql,array("ii",$bayID,$order));
			}
			if (count($pallet_rs) > 0) {
				print "<div class='pallet_container'>";
				foreach($pallet_rs as $pallet_data) {
					$palletID=$pallet_data['pallet_id'];
					$palletColor=$pallet_data['color'];
					$palletWO=$pallet_data['wo_parent'];
					$palletSeq=$pallet_data['bay_sequence'];
					$palletComplete=$pallet_data['complete'];
					$colorCode="";
					$palletCard="";
					$palletStagedRows="";				
					include('staging/getStagedParts.php');

					if (count($staged_rs) > 0) {
						$containsStagedHighlight = 0;
						## setting up container header
						print "<div class='pallet_card'>"; // pallet card
						print "<p style='text-align: center'><b>Pallet $palletSeq</b></p>";
						if ($palletColor) {
							$sql="SELECT color_code FROM vendor_colors WHERE vc_id=?";
							list($rs,$err)=runIQuery($db,$sql,array("i",$palletColor));
							if ($rs) {
								$colorCode = $rs[0][0];
								print "<p><b>Color: $colorCode</b></p>";
							}	
						}
						if ($palletWO) {
							print "<p><b>WO: $palletWO</b></p>";
						}
						## container header ^^
						## pallet buttons
						print "<div class='pallet_buttons'>";
						if ($palletComplete) {
							print "<div id='clearBtnPallet$palletID' style='width: 60px; align-items:center;' class='btn red clearBtn$bayID hidePallet$palletID' onclick='clearPallet($bayID,$order,$bayType,$palletID,$inspectionRequired)'>CLEAR</div>";
						}
						print "<div id='movePartBtn$palletID' style='width: 60px; align-items:center;' class='btn blue movePart$palletID' onclick='movePart($bayID,$order,$bayType,$palletID)'>MOVE PART</div>";  ## in progress, add back in when ready
						if ($bayType == 1 || $bayType == 5) {
							print "<div id='partialBtn$palletID' style='width: 60px; align-items:center;' class='btn yellow hide$palletID' onclick='partialClear($bayID,$order,$bayType,$palletID,$inspectionRequired)'>PARTIAL</div>";
						}
						print "</div>";
						## pallet buttons ^^
						print "<table class='hidePallet$palletID'><tr><th>Part</th><th>On Order</th><th>In Bay</th></tr>";

						foreach ($staged_rs AS $staged_data) {
							$stagedPart=$staged_data['item_id'];
							$stagedQty=$staged_data['staged_qty'];
							$stagedForLocation=$staged_data['staged_for_location'];
							$allowForTransfer = 0;

							$background = "";
							if ($busUnit == 1 && $stagedForLocation == 2) {
								$allowForTransfer = 1;
								$containsStagedHighlight = 1;
								$background = "class='staged_for_transfer' style='background-color: yellow;'";
							}

							if ($staged_data['order_qty'] == 0) {
								$sql = "SELECT j.quantity_scheduled AS quantity
								FROM jobs j 
								INNER JOIN order_lines ol ON ol.line_id=j.line_id 
								INNER JOIN routing r ON r.parent_part=j.item_id 
								INNER JOIN items i ON i.item_name=j.item_id 
								INNER JOIN routing rout ON rout.parent_part=j.item_id
								LEFT JOIN billofmaterial b ON b.parent_item=j.item_id AND r.parent_part=b.parent_item AND b.routing_id=rout.routing_id
								LEFT JOIN items ii ON ii.item_name=b.child_item 
								WHERE r.operation_id IN (3116,3138) 
								AND rout.operation_id=3138
								AND ol.order_id=?
								AND (i.item_name=? OR ii.item_name=?)";
								list($rs,$err)=runIQuery($db,$sql,array("iss",$order,$stagedPart,$stagedPart));
								$orderQty = $rs[0][0];
							} else {
								$orderQty=number_format($staged_data['order_qty']);
							}
														
							print "<tr><td $background>$stagedPart</td><td $background>$orderQty</td><td $background>$stagedQty</td></tr>";
						}
						print "</table>";
						print "</div>";
						include('staging/movePartModal.php');
						include('staging/partialClearModal.php');
					}
				}
				print "</div>";
			}
			if ($containsStagedHighlight) {
				print "<p style='background-color: yellow'>Highlighted parts in the staged section may require powder coat application in Holland, have routing that requires further work be done in Holland, or other parts in the order showed production results performed in Holland.</p>";
			}
		}
		print "</td>";
		## NOTES SECTION (info for other bays containing the same order)
		
		$notes="";
		$otherBays = "";
		if ($order && $order > 0) {
			if (count($pallet_rs) > 0) {
				foreach($pallet_rs as $pallet_data) {
					$palletID=$pallet_data['pallet_id'];
					$palletColor=$pallet_data['color'];
					$palletWO=$pallet_data['wo_parent'];
					$palletSeq=$pallet_data['bay_sequence'];
					$colorCode="";
					$palletCard="";
					$palletStagedRows="";				
					include('staging/getOtherBayParts.php');
					if ($order && count($other_bays_rs) > 0 ) {
						$notes.="This order is also found in bay(s): ";
			
						foreach($other_bays_rs AS $other_bays_data) {
							$otherBay=$other_bays_data['bay_name'];
							if (!strstr($otherBays,$otherBay)) {
								$otherBays.= $otherBay . " ";
								
							}	
						}
					}
				}
			}
		}
		print "<td id='notes$bayID' data-other='$otherBays'>";
		if ($order) {
			print $notes; 
			print $otherBays;
		}
		print "</td>";
		print "<td>";
		if ($order) {
			include('staging/getShippedParts.php');
			if (isset($shipped_rs)) {
				if (count($shipped_rs) > 0) {
					print "<table class='hide$bayID'><tr><th>Part</th><th>Shipped</th></tr>";
					
					foreach ($shipped_rs AS $shipped_data) {
						$shippedPart=$shipped_data['item_id'];
						$shippedQty=$shipped_data['shipped_quantity'];

						print "<tr><td>$shippedPart</td><td>$shippedQty</td></tr>";
					}
					print "</table>";
				}
			}
		}
		print "</td>";
		print "</tr>";
	}

	print "</tbody>";
	print "</table>";
	
}
include('footer.php');
?>
<style>
	.pallet_card {
		border: solid 2px;
		border-radius: 25px !important;
		margin-bottom: 10px;
		max-width: 300px;
		padding: 10px;
	}

	.pallet_buttons {
		margin-bottom: 10px;
	}
</style>
<script>

function inspectOrder(bay,order) {
	 if ($('.ready' + bay).text() != "READY") {
		alert("The entire order must be prepped for staging before the order can be inspected.");
		$("#inspection" + bay).prop('checked', false).parent().removeClass('checked');
	 } else {
		if($('#inspection' + bay).is(':checked')) {
			$.ajax({
				method: "POST",
				url: "staging/markInspected.php",
				data: {bay:bay,order:order}
				}).done(function() {
					location.reload();
				})
		}
	 }
}

function filterBays(filter) {
		let bays = document.querySelectorAll('.bay_container');
		if (filter == 'Holland') {
			bays.forEach(function(bay) {
				let busUnit = bay.dataset.businessunit;
				if (busUnit == 1) {
					bay.style.display = 'none';
				} else {
					bay.style.display = 'table-row';
				}
			})
		
		} else if (filter == 'Jenison') {
			bays.forEach(function(bay) {
				let busUnit = bay.dataset.businessunit;
				if (busUnit == 2) {
					bay.style.display = 'none';
				} else {
					bay.style.display = 'table-row';
				}
			})
		} else if (filter == 'Finished Goods') {
			bays.forEach(function(bay) {
				let type = bay.dataset.baytype;
				if (type == 1) {
					bay.style.display = 'table-row';
				} else {
					bay.style.display = 'none';
				}
			})
		} else if (filter == "All") {
			bays.forEach(function(bay) {
				bay.style.display = 'table-row';
			})
		} else if (filter == "Pre-Powder") {
			bays.forEach(function(bay) {
				let type = bay.dataset.baytype;
				if (type == 3 ) {
					bay.style.display = 'table-row';
				} else {
					bay.style.display = 'none';
				}
			})
		} else if (filter == "Post-Powder") {
			bays.forEach(function(bay) {
				let type = bay.dataset.baytype;
				if (type == 5) {
					bay.style.display = 'table-row';
				} else {
					bay.style.display = 'none';
				}
			})
		} else if (filter == "Weldment") {
			bays.forEach(function(bay) {
				let type = bay.dataset.baytype;
				if (type == 2) {
					bay.style.display = 'table-row';
				} else {
					bay.style.display = 'none';
				}
			})
		} else if (filter == "Assembly") {
			bays.forEach(function(bay) {
				let type = bay.dataset.baytype;
				if (type == 4) {
					bay.style.display = 'table-row';
				} else {
					bay.style.display = 'none';
				}
			})
		}
	}
// green light/ red light could use a little work for pallets - you can increase quantity in input for one pallet, then move to another pallet and button will be green by default
$("input[type='number']").change(function() {
	// TODO check if other values are 0 as well, not just this 
        if (this.value > 0) {
			$('.confirm_partial').removeAttr("disabled");
			$('.confirm_move_part').removeAttr("disabled");
			$('.confirm_partial').removeClass("red");
			$('.confirm_move_part').removeClass("red");
			$('.confirm_partial').addClass("green");
			$('.confirm_move_part').addClass("green");
        } else if (this.value == 0) {
			$('.confirm_partial').attr('disabled', true);
			$('.confirm_move_part').attr('disabled', true);
           console.log("0 qty given");
		   $('.confirm_partial').removeClass("green");
		   $('.confirm_move_part').removeClass("green");
			$('.confirm_partial').addClass("red");
			$('.confirm_move_part').addClass("red");
        }
    });


	function partialConfirm(palletID,bayID) {
		let partsToClear = document.querySelectorAll('.partial_ship' + palletID);
		let count = 0;
		let index = 0 ;
		partsToClear.forEach(function(partToClear) {
			let qty = partToClear.value;
			if (qty > 0) {
				count++;
			}
		})
		partsToClear.forEach(function(partToClear) {
			let part = partToClear.dataset.item;
			let qty = partToClear.value;
			let order = partToClear.dataset.order;
			if (qty > 0) {
				$.ajax({
				method: "POST",
				url: "staging/clearPart.php",
				data: {pallet:palletID,bay:bayID,order:order,part:part,qty:qty,action:"partial"}
				}).done(function() {
					index++;
					if (count == index) { // we've gone through all parts
						$.ajax({
							method: "POST",
							url: "staging/lookForLeftovers.php",
							data: {bay:bayID,order:order,pallet:palletID}
						}).done(function() {
							alert('Cleared Part(s)');
							$("#myModal" + bayID).modal('hide');
							location.reload();
						})
					}
					// TODO refresh page/ hide content/ reset form
					//$('.hide' + bayID).hide();

				})
			}
		});
	}

	function movePartConfirm(palletID,bayID) {
		let partsToClear = document.querySelectorAll('.move_part' + palletID);
		let count = 0;
		let index = 0 ;
		partsToClear.forEach(function(partToClear) {
			let qty = partToClear.value;
			if (qty > 0) {
				count++;
			}
		})
		partsToClear.forEach(function(partToClear) {
			let part = partToClear.dataset.item;
			let qty = partToClear.value;
			let order = partToClear.dataset.order;
			if (qty > 0) {
				$.ajax({
				method: "POST",
				url: "staging/clearPart.php",
				data: {pallet:palletID,order:order,part:part,qty:qty,action:"move"}
				}).done(function() {
					index++;
					if (count == index) { // we've gone through all parts
						$.ajax({
							method: "POST",
							url: "staging/lookForLeftovers.php",  // TODO modify this to 1. check if pallet was cleared, 2. check if bay was cleared
							data: {bay:bayID,order:order,pallet:palletID}
						}).done(function() {
							alert('Cleared Part(s)');
							$("#movePartModal" + bayID).modal('hide');
							location.reload();
						})
					}
				})
			}
		});
	}

	function clearBay(bayID,order,bayType,inspectionRequired) {
		if (inspectionRequired) {
			alert("These parts must be inspected for a new customer before the bay can be cleared.  Please make sure the order is checked for quality before clicking the checkbox.");
		} else {
			let continueClear = 0;
			let otherBayNotes = document.getElementById('notes' + bayID);
			let otherBays = otherBayNotes.dataset.other;
			let newBays = otherBays.split(/(\s+)/);
			newBays = newBays.filter(bay => bay.length > 1);

			if ((bayType == 1 || bayType == 5) && newBays.length > 0) {
				if (confirm("This order is also in bays: " + otherBays + ".  Please Remember to clear these bays for order " + order + " when they are ready.") == true) {
					continueClear = 1;
				} 
			} else {
				continueClear = 1;
			}

			if (continueClear) {
				if (confirm("Are you sure you want to clear this bay?") == true) {
					$.ajax({
						method: "POST",
						url: "clearBay.php",
						data: {bay:bayID,order:order,type:bayType}
					}).done(function() {
						alert('Cleared Bay');
						// TODO refresh page/ hide content/ reset form
						$('.hide' + bayID).hide();
						location.reload();
					})
				}
				
			}
		}
	}

	function clearPallet(bayID,order,bayType,palletID,inspectionRequired) {
		if (inspectionRequired) {
			alert("These parts must be inspected for a new customer before the bay can be cleared.  Please make sure the order is checked for quality before clicking the checkbox.");
		} else {
			if (confirm("Are you sure you want to clear this pallet?") == true) {
				$.ajax({
					method: "POST",
					url: "staging/clearPallet.php",
					data: {bay:bayID,order:order,type:bayType,pallet:palletID}
				}).done(function() {
					alert('Cleared Pallet');
					// TODO refresh page/ hide content/ reset form
					//$('.hide' + bayID).hide();
					location.reload();
				})
			}
		}
	}

	function partialClear(bayID,order,bayType,palletID,inspectionRequired) {
		if (inspectionRequired) {
			alert("These parts must be inspected for a new customer before the bay can be cleared.  Please make sure the order is checked for quality before clicking the checkbox.");
		} else {
			$("#myModal" + palletID).modal();
		}
	}

	function movePart(bayID,order,bayType,palletID) {
		$("#movePartModal" + palletID).modal();
	}

	function moveBay(bayID,order,bayType) {
		// TODO disable the button momentarily to prevent double click
		let selectedBay = $('#bayOptions' + bayID).val();
		if (!selectedBay) {
		
		$('#bay_dropdown' + bayID).css("display", "block");
			$.ajax({
			method: "POST",
			url: "staging/getMoveBayOptions.php",
			data: {bay:bayID, order:order, bayType:bayType}
			}).done(function(moveBayResults) {
				let selectParent = document.getElementById('bayOptions' + bayID);
				let moveOutOption = document.createElement("option");
				moveOutOption.value = "Move Out of Staging";
				moveOutOption.text = "Move Out of Staging";
				selectParent.appendChild(moveOutOption);

				if (moveBayResults) {
					let decodedResults = JSON.parse(moveBayResults);
					if (decodedResults.success == "true") { 
						let options = decodedResults.options;
						options.forEach(function(option) {
							let bayOption = document.createElement("option");
							bayOption.value = option;
							bayOption.text = option;
							selectParent.appendChild(bayOption);
						});

						$('.move' + bayID).removeClass("blue");
						$('.move' + bayID).addClass("green");
						$('.move' + bayID).text("CONFIRM");

					} else {
						alert("No Open Bays Found");
					}
				} else {
					alert("No Open Bays Found");
				}
			})

		} else {

			console.log(selectedBay);
			$.ajax({
			method: "POST",
			url: "staging/moveBay.php",
			data: {fromBay:bayID, order:order, toBay:selectedBay}
			}).done(function(moveBayResults) {
				alert('Moved Bay Contents');
				// TODO refresh page/ hide content/ reset form
				$('.hide' + bayID).hide();
				$('#bay_dropdown' + bayID).hide();
				$('.move' + bayID).hide();
				location.reload();
							
			})

		} 
	}

	function displayButtons() {
		$('.readyBlock').each(function(index,item){
			if ($(item).text() == "READY") {
				$('#clearBtn' + index).css("display", "block");
				$('#moveBtn' + index).css("display", "block");
				//$('#movePartBtn' + index).css("display", "block");
				//$('#partialBtn' + index).css("display", "block");
			} else if ($(item).text().length > 0) {
				$('#moveBtn' + index).css("display", "block");
				//$('#movePartBtn' + index).css("display", "block");
				//$('#partialBtn' + index).css("display", "block");
			}
		})
	}

	// function checkBoxes() {
	// 	$('.inspection_required').each(function(index,item){
	// 		if($(this).not(':checked')) {
	// 			let bay = this.value;
	// 			$('.clearBtn' + bay).each(function(index,item){
	// 				$(this).attr("disabled","disabled")
	// 			})
	// 		}
	// 	})
	// }

	function page_init() {
		displayButtons();
		//checkBoxes();
	}
</script>
<?php
print renderClosePanel();
// include('footer.php');
?>