<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');


if (isset($_POST['start'])) {
	$start=$_POST['start'];
	$startTime=$_POST['start_time'];
	list($hm,$ampm)=explode(" ",$startTime);
	list($sh,$sm)=explode(":",$hm);
	if ($ampm == "PM") {
		$sh+=12;
	} else {
		if ($sh == "12") {
			$sh="00";
		}
	}
	$end=$_POST['end'];
	$endTime=$_POST['end_time'];
	list($hm,$ampm)=explode(" ",$endTime);
	list($eh,$em)=explode(":",$hm);
	if ($ampm == "PM") {
		$eh+=12;
	} else {
		if ($eh == "12") {
			$eh="00";
		}
	}
	$sortby=$_POST['sortby'];
} else {
	$start=Date("m/d/Y");
	$end=Date("m/d/Y");
	$startTime="12:00 AM";
	$endTime="11:59 PM";
	$sh="00";
	$sm="00";
	$eh="23";
	$em="59";
	$sortby="date_loaded";
}	

print renderPanel("Staging Audit","Staging","primary","span11");
print "<p>This report will show all items cleared for the date/time range and compare against what has shipped</p>";
print "<form name='findform' action='stagingAudit.php' method='POST'>";
print renderButton("Find","primary","document.findform.submit();");
print "<div style='clear: both;'></div>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderTimePicker(TRUE,"start_time",$startTime,"Start Time");
print renderDateBox(TRUE,"end",$start,"End Date");
print renderTimePicker(TRUE,"end_time",$endTime,"End Time");
print renderStartItem(TRUE,"sort","Sort By");
print "<select name='sortby' id='sortby'><option value='date_loaded'>Date Loaded</option>";
print "<option value='folder_number' ";
if ($sortby == "folder_number") {
	print " selected ";
}
print ">Folder</option>";
print "<option value='h.item_id' ";
if ($sortby == "h.item_id") {
	print " selected ";
}
print ">Part #</option>";
print "</select>";
print renderEndItem();
print "</form>\n";
$st=formatDateWebToDB($start);
$et=formatDateWebToDB($end);
## op 2 is weld we disregard those parts
$sql="select h.bay_name, h.date_loaded, h.item_id, h.quantity, h.folder_number, coalesce(l.packing_list_id,0) as packing_slip, coalesce(l.quantity,0) as quantity_shipped, ol.due_date, u.full_name from staging_bay_history h left outer join packing_slip_lines l on h.line_id=l.order_line inner join order_lines ol on h.line_id=ol.line_id left outer join order_line_operations olo on h.line_id=olo.line_id and operation_id=2 left outer join site_admins u on h.user_id=u.user_id where olo.operation_id is null and bay_name not like 'W%' and h.date_loaded >= '$st $sh:$sm:00' and h.date_loaded <= '$et $eh:$em:00' and h.action = 'CLEAR' order by $sortby ";
print "<table class='table table-striped'><thead><tr>";
print "<td>Bay</td>";
print "<td>Date Cleared</td>";
print "<td>Part</td>";
print "<td>Quantity Cleared</td>";
print "<td>Who Cleared</td>";
print "<td>Sales Order</td>";
print "<td>Date Due</td>";
print "<td>Packing Slip</td>";
print "<td>Loaded By</td>";
print "<td>Quantity Shipped</td>";
print "</tr>";
print "</thead>";
print "<tbody>";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
	$bay=$data['bay_name'];
	$dt=formatDateDBToWeb($data['due_date']);
	$cleared=formatDateDBToWeb($data['date_loaded']);
	$part=$data['item_id'];
	$qty=abs($data['quantity']);
	$order=$data['folder_number'];
	$packslip=$data['packing_slip'];
	$sqty=$data['quantity_shipped'];
	$who=$data['full_name'];
	$sql="select distinct full_name from staging_bay_history h, site_admins u where action='LOAD' and folder_number=? and item_id=? and h.user_id=u.user_id";
	list($wrs,$err)=runIQuery($db,$sql,array("ss",$order,$part));
	$comma="";
	$loadby="";
	foreach ($wrs as $wdata) {
		$fn=$wdata['full_name'];
		$loadby.=$comma;
		$loadby.=$fn;
		$comma=",";
	}
	$font="black";
	if ($sqty < $qty) {
		$font="red";
	}
	print "<Tr><td>$bay</td><td>$cleared</td>";
	print "<td style='color: $font'>";
	print $part;
	print "</td>";
	print "<td style='color: $font'>";
	print $qty;
	print "</td>";
	print "<td style='color: $font'>";
	print $who;
	print "</td>";
	print "<td style='color: $font'>";
	print $order;
	print "</td>";
	print "<td>$dt</td>";
	if (! $packslip) {
		$packslip="MISSING";
	}
	print "<td>$packslip</td>";	
	print "<td>$loadby</td>";
	print "<td>$sqty</td>";
	print "</tr>\n";
}
print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>
	function page_init() {
		$('.datepicker').datepicker();
		$('.timepicker').timepicker();
	}
</script>
<?php
include('footer.php');
?>
