<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Available For Assembly";
include('header.php');
print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
## 9 is Back From Processor, 12 is partially back
$sql="select po_number, l.* from orders o, order_lines l where o.order_id=l.order_id and status in (9, 12) order by l.due_date ";
list($rs,$err)=runIQuery($db,$sql);
print "<table class='table table-striped'><thead><tr><th>Finished Good</th><th>Description</th><th>Due</th><th>Quantity</th><th>SO</th><th>Customer PO</th><th>WO</th><th>Receipts</th><th>Stage</th></tr></thead><tbody>";
$lc=0;
foreach ($rs as $data) {
    $lc++;
    $fg=$data['item_id'];
    $so=$data['order_id'];
    $due=formatDateDBToWeb($data['due_date']);
    $description=$data['item_description'];
    $quantity=$data['quantity'];
    $po=$data['po_number'];
    $poLine=$data['po_line'];
    $line=$data['line_id'];
    $sql="select * from jobs where line_id=? and item_id=?";
    list($jrs,$err)=runIQuery($db,$sql,array("is",$line,$fg));
    $jdata=$jrs[0];
    $job=$jdata[0];
    print "<tr><td valign='top'>$fg</td><td valign='top'>$description</td><td valign='top'>$due</td><td valign='top'>$quantity</td><td valign='top'>$so</td><td valign='top'>$po</td><td valign='top'>$job</td><td valign='top'>";
    print "<div id='detail$lc' style='display: none; cursor: pointer;' onclick=\"hideDetail('$lc');\"><table><tr><td>PO#</td><td>Sub</td><td>Component</td><td>ON PO</td><td>Received</td></tr>";
    $check=1;
    $sql="select status_name, j.item_id as child_part, i.item_name,  l.* from jobs j, po_lines   l, purchase_orders po, po_status s, items i  ";
    $sql.=" where j.line_id=? and j.job_id=l.job_id and l.po_id=po.po_id and po.status=s.status_id and  l.item_id=i.item_id order by i.item_name";
    list($lrs,$err)=runIQuery($db,$sql,array("i",$line));
    foreach ($lrs as $ldata) {
        $po=$ldata['po_id'];
        $status=$ldata['status'];
        $child=$ldata['child_part'];
        $component=$ldata['item_name'];
        $onpo=$ldata['quantity'];
        $received=$ldata['quantity_received'];
        if ($received < $onpo) {
            if ($status != "Closed" and $status != "Cancelled" ) {
                $check=0;
            }
        }
        if ($onpo >  0 and $status != "Cancelled") {
            print "<tr><td>$po</td><td>$child</td><td>$component</td><td>$onpo</td><td>$received</td></tr>\n";
        }
    }
    print "</table></div>";
    print "<div id='showdetail$lc' onclick=\"showDetail('$lc');\" style='display: none; cursor: pointer;'>Show Detail</div>";
    print "<td valign='top'>";
    if ($check) {
        ## make button
        print renderButton("Stage This","blue","stageOrder('$so');");
    }
    print "</tr></tr>\n";
}
print "</tbody></table>";
print renderClosePanel();
?>
<script>
function showDetail(lc) {
    $('#showdetail'+lc).hide();
    $('#detail'+lc).show();
}
function hideDetail(lc) {
    $('#detail'+lc).hide();
    $('#showdetail'+lc).show();
}
function page_init() {
	$("[id^='showdetail']").each(function(index) {
		this.style.display='inline';
    });
}
function stageOrder(orderno) {
    url='updateJobStagedAssembly.php?so='+orderno+'&rand='+Math.random();
    $.ajax({url: url, success: function(data){
        alert(data);
        document.location.reload();
    }})
}
</script>
<?php
include('footer.php');
