<?php

function moveBay() {
    include('../dbConnection.php');
    include('../security.php');
    include('../functions.php');

    $order = "";
    $toBay = "";
    $fromBay = "";
    
    if (isset($_POST['order'])) {
        $order = $_POST['order'];
    }

    if (isset($_POST['fromBay'])) {
        $fromBay = $_POST['fromBay'];
    }

    if (isset($_POST['toBay'])) {
        $toBay = $_POST['toBay'];
    }

    if ($toBay == "Move Out of Staging") {
        // reset the staging bay
        $sql = "UPDATE staging_bays 
        SET order_id=NULL,full=0,date_loaded=NULL
        WHERE bay_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$fromBay));

        // insert into staging_bay_history
        $sql = "SELECT item_id, (SUM(quantity) * -1) AS qty, line_id, pallet_id FROM staging_bay_contents WHERE bay_id=? GROUP BY item_id";
        list($staging_rs,$staging_data)=runIQuery($db,$sql,array("i",$fromBay));
        foreach($staging_rs AS $staging_data) {
            $item=$staging_data['item_id'];
            $qty=$staging_data['qty'];
            $line=$staging_data['line_id'];
            $pallet=$staging_data['pallet_id'];

            $sql = "INSERT INTO staging_bay_history (bay_id,date_history,item_id,quantity,order_number,line_id,`action`,pallet_id,`user_id`)
            VALUES (?,now(),?,?,?,?,'MOVED OUT',?,?)";
            list($rs,$err)=runIQuery($db,$sql,array("isiiiii",$fromBay,$item,$qty,$order,$line,$pallet,$userID));
        }

        // delete from staging bay contents
        $sql="DELETE FROM staging_bay_contents WHERE bay_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$fromBay));

        // update pallets table
        $sql = "SELECT pallet_id FROM pallets WHERE assigned_bay=? AND order_id=? AND cleared_from_bay IS NULL";
        list($pallets_rs,$err)=runIQuery($db,$sql,array("ii",$fromBay,$order));
        foreach($pallets_rs AS $pallets_data) {
            $palletID=$pallets_data['pallet_id'];

            $sql= "DELETE FROM pallets WHERE pallet_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("i",$palletID));

            // update pallets_have_parts
            $sql="DELETE FROM pallets_have_parts WHERE pallet_id=? AND order_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$palletID,$order));
    
        }
    } else {
        $sql = "SELECT bay_id FROM staging_bays WHERE bay_name=?";
        list($rs,$err)=runIQuery($db,$sql,array("s",$toBay));
        if (count($rs) == 1) {
            $toBay= $rs[0][0];  ## update to bay from name to id


            // update the staging bays
            $sql = "UPDATE staging_bays 
            SET order_id=NULL,full=0,date_loaded=NULL
            WHERE bay_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("i",$fromBay));

            $sql = "UPDATE staging_bays 
            SET order_id=?,date_loaded=now()
            WHERE bay_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("ii",$order,$toBay));

            // insert into staging_bay_history
            $sql = "SELECT item_id, (SUM(quantity) * -1) AS qty, line_id, pallet_id FROM staging_bay_contents WHERE bay_id=? GROUP BY item_id";
            list($staging_rs,$staging_data)=runIQuery($db,$sql,array("i",$fromBay));
            foreach($staging_rs AS $staging_data) {
                $item=$staging_data['item_id'];
                $qty=$staging_data['qty'];
                $line=$staging_data['line_id'];
                $pallet=$staging_data['pallet_id'];

                $sql = "INSERT INTO staging_bay_history (bay_id,date_history,item_id,quantity,order_number,line_id,`action`,pallet_id,`user_id`)
                VALUES (?,now(),?,?,?,?,'MOVED OUT',?,?)";
                list($rs,$err)=runIQuery($db,$sql,array("isiiiii",$fromBay,$item,$qty,$order,$line,$pallet,$userID));
                $sql = "INSERT INTO staging_bay_history (bay_id,date_history,item_id,quantity,order_number,line_id,`action`,pallet_id,`user_id`)
                VALUES (?,now(),?,?,?,?,'MOVED IN',?,?)";
                list($rs,$err)=runIQuery($db,$sql,array("isiiiii",$toBay,$item,$qty * -1,$order,$line,$pallet,$userID));
            }

            // update staging_bay_contents
            $sql = "UPDATE staging_bay_contents 
            SET bay_id=?, `user_id`=? WHERE bay_id=?";
            list($rs,$err)=runIQuery($db,$sql,array("iii",$toBay,$userID,$fromBay));

            // update pallets table
            $sql = "UPDATE pallets SET assigned_bay=? WHERE assigned_bay=? AND order_id=?";
            list($pallets_rs,$err)=runIQuery($db,$sql,array("iii",$toBay,$fromBay,$order));
        
        }
    }
    

}

moveBay();

?>