<?php

include('../dbConnection.php');
include('../security.php');
include('../functions.php');

$openPallets = 0;
$closedPallets = 0;

if (isset($_POST['bay'])) {
	$bayID = $_POST['bay'];
}
if (isset($_POST['order'])) {
	$orderID = $_POST['order'];
}
if (isset($_POST['part'])) {
	$part = $_POST['part'];
}
if (isset($_POST['quantity'])) {
	$qty = $_POST['quantity'];
}
if (isset($_POST['line'])) {
	$lineID = $_POST['line'];
}
if (isset($_POST['color'])) {
	$colorID = $_POST['color'];
}
if (isset($_POST['orderBy'])) {
	$orderByColor = $_POST['orderBy'];
}
if (isset($_POST['job'])) { // job of parent or 0 if it is order line
	$job = $_POST['job'];
}
if (isset($_POST['stagedFor'])) { // job of parent or 0 if it is order line
	$stagedForLocation = $_POST['stagedFor'];
}

	## get bay type
	$sql = "SELECT bay_type FROM staging_bays WHERE bay_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$bayID));
	$bayType = $rs[0][0];
	## adding in that the wo_parent must be the same as well
	$sql = "SELECT * FROM pallets WHERE assigned_bay=? AND cleared_from_bay is NULL AND complete is NULL AND order_id=? AND color=? AND wo_parent=? ORDER BY bay_sequence DESC";
	list($rsOpen,$err)=runIQuery($db,$sql,array("iiii",$bayID,$orderID,$colorID,$job));
	if ($rsOpen){
	
		$openPallets = count($rsOpen);
	
		if (count($rsOpen)>0) {
			$openPalletData=$rsOpen[0];
		}
	}

	// get all pallets in bay that are full, or rather, pallets within the bay that cannot be used by the staged part
	## bdoss pallets with different colors means that more pallets can be open, look for all pallets
	$sql = "SELECT * FROM pallets WHERE assigned_bay = ? AND order_id=? AND cleared_from_bay IS NULL && (complete = 1 OR NOT color = ? OR NOT wo_parent=?) ";
	list($rsClosed,$err)=runIQuery($db,$sql,array("iiii",$bayID,$orderID,$colorID,$job));
	if ($rsClosed){
		
		$closedPallets = count($rsClosed);

		if ($closedPallets>0) {
			$closedPalletData=$rsClosed[0];
		}

	}
	
			### PALLET MANAGEMENT ADDITION MW ###
			
			// if already open add to open pallet
			// else open new pallet and add item quan to that

			if($openPallets  == 0 && $closedPallets == 0){ // this is for the very first pallet to be opened in the bay
				$nextSequence = 1;

					## bdoss not allowing full pallets at this stage
				
				$sql = "INSERT INTO pallets (assigned_bay,started_by_user,last_touched_by_user,bay_sequence,order_id,created_at,updated_at,color,wo_parent,color_only) VALUES ($bayID,$userID,$userID,$nextSequence,$orderID,now(),now(),$colorID,$job,$orderByColor)";
				list($rs,$err)=runIQuery($db,$sql);
				$sql = "SELECT pallet_id FROM pallets WHERE assigned_bay=? AND bay_sequence=? AND order_id=? AND color=? AND wo_parent=? ORDER BY pallet_id DESC";
				list($rs,$err)=runIQuery($db,$sql,array("iiiii",$bayID,$nextSequence,$orderID,$colorID,$job));
				//$last_id = mysqli_insert_id($db);
				$palletId = $rs[0][0];
				if ($rs) {
					// ADD ITEMS TO THE CREATED PALLET
					// insert into pallets_have_parts here
			
					$plid=$palletId;

						$sql = "INSERT INTO pallets_have_parts (pallet_id,item_id,quantity,order_id,created_at,updated_at) VALUES ($palletId,'$part',$qty,$orderID,now(),now())";
						$plid=$palletId;
					
					list($rs,$err)=runIQuery($db,$sql);
				}
			}
			elseif ($openPallets==0 && $closedPallets>=1) 
			{ 
				$nextSequence = $closedPallets+=1;
			
				$sql= "INSERT INTO pallets (assigned_bay,started_by_user,last_touched_by_user,bay_sequence,order_id,created_at,updated_at,color,wo_parent,color_only) VALUES ($bayID,$userID,$userID,$nextSequence,$orderID,now(),now(),$colorID,$job,$orderByColor)";			
				list($rs,$err)=runIQuery($db,$sql);
				//$last_id = mysqli_insert_id($db);
				//$palletId = $last_id;
				$sql = "SELECT pallet_id FROM pallets WHERE assigned_bay=? AND color=? AND order_id=? AND bay_sequence=? AND wo_parent=?";
				list($irs,$err)=runIQuery($db,$sql,array("iiiii",$bayID,$colorID,$orderID,$nextSequence,$job));
				$palletId = $irs[0][0];
				if ($rs)
				{
					$sql = "INSERT INTO pallets_have_parts (pallet_id,item_id,quantity,order_id,created_at,updated_at) VALUES ($palletId,'$part',$qty,$orderID,now(),now())";
					list($rs,$err)=runIQuery($db,$sql);
					if ($rs)
					{
						## bdoss 1/4/23 $plid is showing up undefined some of the time
						if (!isset($plid)) {
							//$plid = $last_id;
							$plid = $palletId;
						}
	
						$sql="select bay_name, bay_sequence from pallets p, staging_bays b where p.pallet_id=? and assigned_bay=bay_id ";  // was bays and not staging_bays
						list($brs,$err)=runIQuery($db,$sql,array("i",$plid));
						$bdata=$brs[0];
						$plname=$bdata['bay_name']."-".$bdata['bay_sequence'];
						//$_SESSION['notice'] = "<span class='alert alert-success form-control'> Successfully Allocated ".$qty." of ".$part." To Pallet $plname plid $plid lastid $last_id palletid $palletId</span>";  ## bdoss seeing which, if any, variables get through

					}
				}
			}
			else 
			{	
				//if we have an open pallet put the parts just entered onto that pallet
				$palletId = $openPalletData['pallet_id'];
				$openPalletColor=$openPalletData['color'];
				$nextSequence=$openPalletData['bay_sequence'];

				## bdoss make sure the pallet color matches
					// first check to see if this part is already on an open pallet.
					// if on open pallet, update quantity
					$sql = "SELECT * FROM pallets_have_parts WHERE pallet_id = ? && item_id = ? && order_id = ?";
					list($rsExistingOnPallet,$err)=runIQuery($db,$sql,array("isi",$palletId,$part,$orderID));
					if($rsExistingOnPallet) {
		
						$sql = "SELECT quantity FROM order_lines WHERE order_id =? && item_id = ?";
						list($quantityOnOrderResult,$err)=runIQuery($db,$sql,array("is",$orderID,$part));
						if($quantityOnOrderResult){
			
							// if there is an existing part number on that pallet
							if(count($rsExistingOnPallet)>0)
							{ 
								// echo "we are here count existon on pallet is greater than zero";
								// make sure the new quantity will not be more than orderd
								
								// set new quantity
								$newQuantity = $rsExistingOnPallet[0]['quantity']+=$qty;
								// echo "new quantity ".$newQuantity; 
	
								
								if($newQuantity > $quantityOnOrderResult[0]['quantity']){
									//echo '<script>alert("This is more than the quantity ordered")</script>';
								} elseif ($newQuantity <= 0) {  // bdoss 1/5/23 preventing users from entering quantities 0 or below
									//echo '<script>alert("A quantity greater than 0 must be entered.")</script>';
								} else {
									// update that part on the pallet
									$sql="update pallets_have_parts set  updated_at=now(), quantity=? where pallet_id=? and item_id =? ";
									list($rsUpdatedQtyOnPallet,$err)=runIQuery($db,$sql,array("iis",$newQuantity,$palletId,$part)); // bdoss 9/12/22 had been $newQUantity - was inserting null into quantity column rather than the proper new quantity
									if($rsUpdatedQtyOnPallet){
										//$_SESSION['notice'] = "<span class='alert alert-success form-control'> Successfully Allocated ".$newQuantity." of ".$part." To Pallet </span>";
									}
								}
							}
	
						}
					} else {
						// else add to open pallet with quantity being added 
						## BDOSS UPDATE pallets TABLE AS WELL TO HAVE UPDATED TIME IT WAS LAST TOUCHED
						$sql = "UPDATE pallets SET updated_at=now() WHERE pallet_id=? AND order_id = ?";
						list($rs,$err)=runIQuery($db,$sql,array("ii",$palletId,$orderID));
						$sql = "INSERT INTO pallets_have_parts (pallet_id,item_id,quantity,order_id,created_at,updated_at) VALUES (?,?,?,?,now(),now())";
						list($rs,$err)=runIQuery($db,$sql,array("isii",$palletId,$part,$qty,$orderID));
						if ($rs){
							//$_SESSION['notice'] = "<span class='alert alert-success form-control'> Successfully Allocated ".$qty." of ".$part." To Pallet </span>";
						}
					}
			}
	// staging bay contents		
	$sql="insert into staging_bay_contents (bay_id, pallet_id, item_id, quantity, line_id, user_id, job_id, staged_for_location) values ($bayID,$palletId,'$part', $qty, $lineID, $userID, $job,$stagedForLocation) ";
	list($rs,$err)=runIQuery($db,$sql);
	// bdoss adding business unit to order lines so shipping knows where to ship from
	$sql="UPDATE order_lines SET business_unit_assigned=? WHERE line_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$businessUnit,$lineID));
	// staging bay history
	$sql="INSERT INTO staging_bay_history (bay_id,pallet_id,item_id,date_history,quantity,order_number,line_id,`user_id`,`action`)
	VALUES (?,?,?,now(),?,?,?,?,'LOAD') ";	
	list($rs,$err)=runIQuery($db,$sql,array("iisiiii",$bayID,$palletId,$part,$qty,$orderID,$lineID,$userID));	
	//staging bays
	## check if it's a new customer who will require inspection
	$inspectionRequired = 0;	
	if ($bayType == 1 || $bayType == 5) {
		$sql = "SELECT inspection_required FROM customers INNER JOIN orders ON orders.customer_id=customers.customer_id WHERE order_id=?";
		list($irs,$err)=runIQuery($db,$sql,array("i",$orderID));
	
		if ($irs[0][0] == 1) {
			$inspectionRequired = 1;
		}
	}
	
	## bdoss date_loaded isn't always null after merge, maybe add this back in when it's taken care of
	//$sql="UPDATE staging_bays SET date_loaded=now(), order_id=? WHERE bay_id=? AND date_loaded IS NULL ";
	$sql="UPDATE staging_bays SET date_loaded=now(), order_id=?, inspection_required=? WHERE bay_id=? ";  ## bdoss change this so it only updates order when it's a new bay
	list($rs,$err)=runIQuery($db,$sql,array("iii",$orderID,$inspectionRequired,$bayID));

	// return the pallet to the user
	echo json_encode(array('success'=>'true', 'pallet'=> $nextSequence));
?>