<?php
if ($orderByColor) {
    $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, 0 AS order_qty, staged_for_location
    FROM staging_bay_contents sbc 
    WHERE sbc.pallet_id=?
    GROUP BY sbc.item_id;";
    list($staged_rs,$err)=runIQuery($db,$sql,array("i",$palletID));
} elseif ($palletWO == 0) {
    $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, (l.quantity - coalesce(l.shipped_quantity,0)) AS order_qty, business_unit, staged_for_location 
    FROM staging_bay_contents AS sbc 
    INNER JOIN order_lines l ON sbc.line_id=l.line_id
    INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
    INNER JOIN pallets ON pallets.assigned_bay=sbc.bay_id AND pallets.pallet_id=sbc.pallet_id AND pallets.order_id=sb.order_id
    WHERE sbc.bay_id=? AND sbc.pallet_id=? AND pallets.color=?
    GROUP BY sbc.item_id";
    list($staged_rs,$err)=runIQuery($db,$sql,array("iii",$bayID,$palletID,$palletColor));

} elseif ($palletWO > 0) {
    $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, j.quantity_scheduled * bom.quantity_per AS order_qty, staged_for_location
    FROM staging_bay_contents sbc
    INNER JOIN jobs j on sbc.job_id=j.job_id ## this would be the job of the parent
    INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
    INNER JOIN pallets ON pallets.assigned_bay=sbc.bay_id AND pallets.pallet_id=sbc.pallet_id AND pallets.wo_parent=j.job_id AND sb.order_id=pallets.order_id
    LEFT JOIN billofmaterial bom ON bom.child_item=sbc.item_id AND bom.parent_item=j.item_id
    WHERE sbc.bay_id=? AND sbc.pallet_id=? AND pallets.color=?
    GROUP BY sbc.item_id";
    list($staged_rs,$err)=runIQuery($db,$sql,array("iii",$bayID,$palletID,$palletColor));
}

?>