<?php
## I have a part
include('../dbConnection.php');
include('../security.php');
include('../functions.php');
if (! isset($_POST['part'])) {
    $_POST=$_GET;
}
$part = $_POST['part'];
$order=0;
$job=0;
$parent = "";
if (isset($_GET['parent']) && (strlen($_GET['parent']) > 0)) {
    $parent = $_GET['parent'];
}
if (isset($_POST['order'])) {
    $order = $_POST['order'];
}

if ($order) {
    if (strstr($order, "SO")) {
        $order = substr($order,2);
        $job = 0;
    } elseif (strstr($order,"WO")) {
        $job = substr($order,2);
        $order = 0;
    }
}
## I need to look up all possible orders.  Looking for 1. finished goods 2. weldments 3. assembly 
## means that if it's being staged as a child part, but it exists as a finished good, the needed order won't display unless all applicable orders are found to begin with
## -- 1 -- look up every order and parent job applicable to the given part
## -- 2 -- after separating between finished good (order) and child part (job), get the parent job info
if (!$order && !$job) {  
    $sql= "
            SELECT CONCAT('SO', order_lines.order_id) AS order_id FROM orders 
            INNER JOIN order_lines ON orders.order_id=order_lines.order_id  AND order_lines.item_id=?
            INNER JOIN jobs ON jobs.line_id=order_lines.line_id AND jobs.item_id=order_lines.item_id 
            LEFT OUTER JOIN items ON order_lines.item_id=items.item_name 
            WHERE orders.`status` NOT IN (3,4,5,6) 
            UNION ALL
            SELECT CONCAT('WO', j.job_id) AS order_id FROM billofmaterial b 
            INNER JOIN routing r ON b.routing_id=r.routing_id AND r.operation_id IN (3091, 3099, 3108, 3134, 3081, 3100, 3138) 
            INNER JOIN jobs j ON j.item_id=b.child_item AND child_item=?
            INNER JOIN order_lines l ON j.line_id=l.line_id 
            INNER JOIN orders o ON l.order_id=o.order_id AND o.status NOT IN (3,4,5,6) ";

            ##UNION ALL
            ##SELECT CONCAT('WO', j.job_id) AS order_id FROM billofmaterial b 
            ##INNER JOIN routing r ON b.routing_id=r.routing_id AND r.operation_id IN (3091, 3099, 3108, 3134, 3081, 3100, 3138)
            ##AND child_item=?
            ##INNER JOIN jobs j ON j.item_id=b.parent_item 
            ##INNER JOIN order_lines l ON j.line_id=l.line_id 
            ##INNER JOIN orders o ON l.order_id=o.order_id AND o.status NOT IN (3,4,5,6)  ";
    list($rs,$err) = runIQuery($db,$sql,array("ss",$part,$part));

    if ($rs) {
        if (count($rs) > 1) {
            $orderOptions=array();
            foreach ($rs as $data) {
                array_push($orderOptions,$data['order_id']);
            }
            echo json_encode(array('success'=>'true', 'results'=>2, 'options'=>$orderOptions)); 
        } elseif (count($rs) == 1) {
            $return = $rs[0][0];
            if (strstr($return, "SO")) {
                $order = substr($return,2);
                $job = 0;
            } elseif (strstr($return,"WO")) {
                $job = substr($return,2);
                $order = 0;
            }
        } else {
            echo json_encode(array('success'=>'false', 'message'=>'No order was found for that part.  Check that you have the correct part and that the order has a status suitable for staging.'));
        }
    } else {
        echo json_encode(array('success'=>'false', 'message'=>'No order was found for that part.  Check that you have the correct part and that the order has a status suitable for staging.'));
    }
    
} 

if ($order) {
    // check if it's a finished good
    $sql="SELECT job_id, order_lines.order_id, order_lines.line_id, jobs.quantity_scheduled, jobs.quantity_good, order_lines.quantity, powder_color FROM orders
    INNER JOIN order_lines ON orders.order_id=order_lines.order_id
    INNER JOIN jobs ON jobs.line_id=order_lines.line_id AND jobs.item_id=order_lines.item_id
    WHERE order_lines.item_id=? AND orders.`status` NOT IN (3,4,5,6,19,16,17)
    AND orders.order_id=?";
    list($ors,$oerr)=runIQuery($db,$sql,array("si",$part,$order));
       
    if (count($ors)==1) { ## save the order number if it is found
        $data=$ors[0];
        $order=$data['order_id'];
        $line=$data['line_id'];
        $job=0;  // if order line item, job will be 0
        $qtySch=$data['quantity_scheduled'];
        $qtyGood=$data['quantity_good'];
        $color=$data['powder_color'];
        $qtyNeeded=$data['quantity'];

        if (!intval($color) > 0) { ## it might not require a powder bay even though it contains color; the routing might not be set up for powder coat for the item
            $color = 0;
        }
        
        ## successful return for finished good
        echo json_encode(array('success'=>'true', 'results'=>1,'order'=>$order, 'line'=>$line, 'job'=>$job, 'bayType'=>1, 'color'=>$color, 'qty'=>$qtyNeeded));
       
    } 
} elseif ($job) { ## not a finished good, try children that will be staged according to parent job next

    $sql="SELECT distinct jp.job_id, jp.item_id, jp.line_id, jp.quantity_scheduled, ol.order_id, r.operation_id, COALESCE(i.powder_color, 0) AS color  
    FROM billofmaterial b, jobs j, jobs jp, order_lines ol, routing r, items i 
    WHERE j.job_id=? AND j.item_id=b.child_item AND jp.line_id=j.line_id AND jp.item_id=b.parent_item AND ol.line_id = jp.line_id 
    AND r.routing_id=b.routing_id AND i.item_name=b.child_item
    UNION ALL 
    SELECT distinct job_id, jobs.item_id, jobs.line_id, quantity_scheduled, ol.order_id, r.operation_id, ol.powder_color as color
        from jobs  inner join order_lines ol on jobs.line_id=ol.line_id
        inner join billofmaterial b on jobs.item_id=b.parent_item
        inner join routing r on b.routing_id=r.routing_id
        WHERE job_id=?";
    list($ors,$err)=runIQuery($db,$sql,array("ii",$job,$job));


    if (count($ors)==1) {
        $bayType = 2;
        $data=$ors[0];
        $parent=$data['item_id'];
        $parentJob=$data['job_id'];
        $order=$data['order_id'];
        $line=$data['line_id'];
        $parentQty=$data['quantity_scheduled']; // might not be order line qty if it's a child of a child
        $useUpOp=$data['operation_id'];
        $color=$data['color'];

        if ($useUpOp == 3081 || $useUpOp == 3091 || $useUpOp == 3099 || $useUpOp == 3108 || $useUpOp == 3134) {
            $bayType = 2;
        } elseif ($useUpOp == 3100) {
            $bayType = 4;
        } elseif ($useUpOp == 3113 || $useUpOp == 3116 || $useUpOp == 3138 || $useUpOp == 3139 || $useUpOp == 3140) {
            $bayType = 3;
        }

        ## successful return for child of weldment
        echo json_encode(array('success'=>'true', 'results'=>1,'order'=>$order, 'line'=>$line, 'parent'=>$parent, 'job'=>$parentJob, 'bayType'=>$bayType, 'parentQuantity'=>$parentQty, 'useUpOp'=>$useUpOp, 'color'=>$color));
    
    } else {
        ## we've tried every scenario, but that part doesn't have a match
        echo json_encode(array('success'=>'false','message'=>'Part cannot be found.'));   
    }
} 


?>