<?php

if (!$isComponentBay) {
    $sql = "SELECT DISTINCT order_lines.item_id, (order_lines.quantity - COALESCE(shipped_quantity,0) - COALESCE( ( SELECT SUM(quantity) FROM staging_bay_contents WHERE staging_bay_contents.line_id=order_lines.line_id AND staging_bay_contents.item_id=order_lines.item_id),0)) AS waiting_qty, vc.color_code
    FROM order_lines
    INNER JOIN items ON items.item_name=order_lines.item_id
    LEFT JOIN vendor_colors vc ON vc.vc_id=items.powder_color
    LEFT JOIN pallets ON pallets.order_id=order_lines.order_id AND pallets.color=items.powder_color
    LEFT JOIN staging_ignore ON staging_ignore.part_number=order_lines.item_id
    WHERE order_lines.order_id=?
    AND order_lines.item_id NOT IN ('PPF')
    AND staging_ignore.part_number IS NULL
    AND pallets.color IS NULL
    GROUP BY item_id";
    list($waitingColors_rs,$err) = runIQuery($db,$sql,array("i",$order));
} elseif ($isComponentBay || $orderByColor) {

    $sql = "SELECT i.item_name AS item_id, ii.item_name AS child_item, 
        (j.quantity_scheduled - 
        COALESCE((SELECT SUM(quantity) FROM staging_bay_contents 
        INNER JOIN staging_bays ON staging_bays.bay_id=staging_bay_contents.bay_id
        WHERE staging_bays.order_id = ol.order_id
        AND (staging_bay_contents.item_id=i.item_name OR staging_bay_contents.item_id=ii.item_name)),0)) AS waiting_qty,
        COALESCE(i.powder_color,0) AS color, vc.color_code
        FROM jobs j 
        INNER JOIN order_lines ol ON ol.line_id=j.line_id 
        INNER JOIN routing r ON r.parent_part=j.item_id 
        INNER JOIN items i ON i.item_name=j.item_id 
        INNER JOIN routing rout ON rout.parent_part=j.item_id
        INNER JOIN vendor_colors vc ON i.powder_color
        LEFT JOIN pallets p ON p.order_id=ol.order_id AND p.color=i.powder_color
        LEFT JOIN billofmaterial b ON b.parent_item=j.item_id AND r.parent_part=b.parent_item AND b.routing_id=rout.routing_id
        LEFT JOIN items ii ON ii.item_name=b.child_item 
        WHERE r.operation_id IN (3116,3138) 
        AND rout.operation_id IN (3116,3138)
        AND ol.order_id=?
        AND p.color IS NULL
        GROUP BY i.item_name 
        ORDER BY i.item_name";
        list($waitingColors_rs,$err) = runIQuery($db,$sql,array("i",$order));

    // $sql="SELECT DISTINCT b.child_item as item_id, b.quantity_per * j.quantity_scheduled -    
    // COALESCE( ( SELECT SUM(quantity) FROM staging_bay_contents
    //     inner join jobs on staging_bay_contents.item_id=jobs.item_id
    //     and j.line_id=jobs.line_id    
    //     and jobs.item_id=b.child_item
    //     and staging_bay_contents.job_id=sbc.job_id  ## bdoss without this, it was counting duplicate staged parts that belonged to other jobs
    // ),0)   AS waiting_qty, vc.color_code
    // from staging_bay_contents sbc 
    // INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
    // inner join  jobs j  on sbc.job_id=j.job_id 
    // INNER JOIN billofmaterial b ON j.item_id=b.parent_item 
    // INNER JOIN items ON items.item_name=b.child_item
    // INNER JOIN vendor_colors vc ON vc.vc_id=items.powder_color ";
    // if ($bayType == 2) {
    //     ## see if any of the various weldment operations
    //     $sql.=" INNER JOIN routing r on b.routing_id=r.routing_id and r.operation_id in (3081, 3091, 3099, 3108, 3134)  ";
    // }
    // if ($bayType == 4) {
    //     $sql.=" INNER JOIN routing r on b.routing_id=r.routing_id and r.operation_id in (3100) ";
    // }
    // $sql.="LEFT JOIN staging_ignore ON staging_ignore.part_number=b.child_item
    // LEFT JOIN pallets ON pallets.assigned_bay=sbc.bay_id AND pallets.color=items.powder_color AND pallets.order_id=sb.order_id
    // where sbc.bay_id=?
    // AND staging_ignore.part_number IS NULL AND pallets.color IS NULL AND b.child_item NOT IN ('PPF')";
    // list($waitingColors_rs,$err)=runIQuery($db,$sql,array("i",$bayID));
}

















?>