<?php

   include('../dbConnection.php');
   include('../security.php');
   include('../functions.php');

    $order="";
    $part="";
    $qty=0;
    $pallet="";

    if (isset($_POST['order'])) {
        $order = $_POST['order'];
    }
    if (isset($_POST['pallet'])) {
        $pallet = $_POST['pallet'];
    }
    if (isset($_POST['part'])) {
        $part = $_POST['part'];
    }
    if (isset($_POST['qty'])) {
        $qty = $_POST['qty'];
    }
    if (isset($_POST['action'])) {
        $updateType = $_POST['action'];
    }

    $sql = "SELECT line_id, bay_id, SUM(quantity) as staged_qty, `user_id`, job_id FROM staging_bay_contents WHERE item_id=? and pallet_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("si",$part,$pallet));
    $line=$rs[0]['line_id'];
    $bay=$rs[0]['bay_id'];
    $stagedQty=$rs[0]['staged_qty'];
    $originalUser=$rs[0]['user_id'];
    $wo=$rs[0]['job_id'];

    // insert into staging_bay_history
    $minusQty = $qty * -1;
    if ($updateType == "move") {
        $action = "MOVED OUT";
    } elseif ($updateType == "partial") {
        $action = "CLEAR";
    }
    

    $sql = "INSERT INTO staging_bay_history (bay_id,date_history,item_id,quantity,order_number,line_id,`action`,pallet_id,`user_id`)
    VALUES (?,now(),?,?,?,?,?,?,?)";
    list($rs,$err)=runIQuery($db,$sql,array("isiiisii",$bay,$part,$minusQty,$order,$line,$action,$pallet,$userID));

    // update staging_bay_contents 
    // no matter what delete all staging_bay_contents rows; it will be easier to add back in the remainder than sort through which rows need to be deleted to equal the amount
    $sql = "DELETE FROM staging_bay_contents WHERE bay_id=? AND item_id=? AND line_id=? AND job_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("isii",$bay,$part,$line,$wo));

    if ($stagedQty > $qty) {  ## add remainder back in
        $newStagedQty=$stagedQty - $qty;
        $sql = "INSERT INTO staging_bay_contents (bay_id,item_id,quantity,line_id,pallet_id,`user_id`,job_id)
        VALUES (?,?,?,?,?,?,?)";
        list($rs,$err)=runIQuery($db,$sql,array("isiiiii",$bay,$part,$newStagedQty,$line,$pallet,$originalUser,$wo));
    }

    // TODO get more specific with pallets, for now just clear them a pallet at a time
    // update pallets_have_parts
    if ($stagedQty > $qty) { // update with new quantity
        $sql="UPDATE pallets_have_parts SET updated_at=now(), quantity=? WHERE pallet_id=? AND order_id=? AND item_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("iiis",$newStagedQty,$pallet,$order,$part));
    } else { // declare the parts cleared
        $sql="UPDATE pallets_have_parts SET cleared=1,updated_at=now(), cleared_by=? WHERE pallet_id=? AND order_id=? AND item_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("iiis",$userID,$pallet,$order,$part));
    }
?>